/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import id.onyx.obdp.server.topology.Configuration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigurationFactory {
    private static final String SCHEMA_IS_NOT_SUPPORTED_MESSAGE = "Provided configuration format is not supported";

    public Configuration getConfiguration(Collection<Map<String, String>> configProperties) {
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, Map<String, String>>> attributes = new HashMap<String, Map<String, Map<String, String>>>();
        Configuration configuration = new Configuration(properties, attributes);
        if (configProperties != null) {
            for (Map<String, String> typeMap : configProperties) {
                ConfigurationStrategy strategy = this.decidePopulationStrategy(typeMap);
                for (Map.Entry<String, String> entry : typeMap.entrySet()) {
                    String[] propertyNameTokens = entry.getKey().split("/");
                    strategy.setConfiguration(configuration, propertyNameTokens, entry.getValue());
                }
            }
        }
        return configuration;
    }

    private ConfigurationStrategy decidePopulationStrategy(Map<String, String> configuration) {
        if (configuration != null && !configuration.isEmpty()) {
            String keyEntry = configuration.keySet().iterator().next();
            List<String> keyNameTokens = ConfigurationFactory.splitConfigurationKey(keyEntry);
            if (ConfigurationFactory.isKeyInLegacyFormat(keyNameTokens)) {
                return new ConfigurationStrategyV1();
            }
            if (ConfigurationFactory.isKeyInNewFormat(keyNameTokens)) {
                return new ConfigurationStrategyV2();
            }
            throw new IllegalArgumentException(SCHEMA_IS_NOT_SUPPORTED_MESSAGE);
        }
        return new ConfigurationStrategyV2();
    }

    static List<String> splitConfigurationKey(String configurationKey) {
        return Arrays.asList(configurationKey.split("/"));
    }

    static boolean isKeyInLegacyFormat(List<String> configurationKey) {
        return configurationKey.size() == 2;
    }

    static boolean isKeyInNewFormat(List<String> configurationKey) {
        String propertiesType = configurationKey.get(1);
        return configurationKey.size() == 3 && "properties".equals(propertiesType) || configurationKey.size() == 4 && "properties_attributes".equals(propertiesType);
    }

    private static abstract class ConfigurationStrategy {
        private ConfigurationStrategy() {
        }

        protected abstract void setConfiguration(Configuration var1, String[] var2, String var3);
    }

    protected static class ConfigurationStrategyV1
    extends ConfigurationStrategy {
        protected ConfigurationStrategyV1() {
        }

        @Override
        protected void setConfiguration(Configuration configuration, String[] propertyNameTokens, String propertyValue) {
            configuration.setProperty(propertyNameTokens[0], propertyNameTokens[1], propertyValue);
        }
    }

    protected static class ConfigurationStrategyV2
    extends ConfigurationStrategy {
        protected ConfigurationStrategyV2() {
        }

        @Override
        protected void setConfiguration(Configuration configuration, String[] propertyNameTokens, String propertyValue) {
            String type = propertyNameTokens[0];
            if ("properties".equals(propertyNameTokens[1])) {
                configuration.setProperty(type, propertyNameTokens[2], propertyValue);
            } else if ("properties_attributes".equals(propertyNameTokens[1])) {
                configuration.setAttribute(type, propertyNameTokens[3], propertyNameTokens[2], propertyValue);
            }
        }
    }
}

