/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    private Map<String, Map<String, String>> properties;
    private Map<String, Map<String, Map<String, String>>> attributes;
    private Configuration parentConfiguration;

    public static Configuration newEmpty() {
        return new Configuration(new HashMap<String, Map<String, String>>(), new HashMap<String, Map<String, Map<String, String>>>());
    }

    public Set<String> applyUpdatesToStackDefaultProperties(Configuration stackDefaultConfig, Map<String, Map<String, String>> existingConfigurations, Map<String, Map<String, String>> updatedConfigs) {
        HashSet<String> updatedConfigTypes = new HashSet<String>();
        Map<String, Map<String, String>> stackDefaults = stackDefaultConfig.getProperties();
        for (Map.Entry<String, Map<String, String>> configEntry : updatedConfigs.entrySet()) {
            String configType = configEntry.getKey();
            Map<String, String> propertyMap = configEntry.getValue();
            Map<String, String> clusterConfigProperties = existingConfigurations.get(configType);
            Map<String, String> stackDefaultConfigProperties = stackDefaults.get(configType);
            for (Map.Entry<String, String> propertyEntry : propertyMap.entrySet()) {
                String property = propertyEntry.getKey();
                String newValue = propertyEntry.getValue();
                String currentValue = this.getPropertyValue(configType, property);
                if (Configuration.propertyHasCustomValue(clusterConfigProperties, stackDefaultConfigProperties, property) || Objects.equals(currentValue, newValue)) continue;
                LOG.debug("Update config property {}/{}: {} -> {}", new Object[]{configType, property, currentValue, newValue});
                this.setProperty(configType, property, newValue);
                updatedConfigTypes.add(configType);
            }
        }
        return updatedConfigTypes;
    }

    private static boolean propertyHasCustomValue(Map<String, String> clusterConfigProperties, Map<String, String> stackDefaultConfigProperties, String property) {
        String propertyValue;
        boolean propertyHasCustomValue = false;
        if (clusterConfigProperties != null && (propertyValue = clusterConfigProperties.get(property)) != null) {
            String stackDefaultValue;
            propertyHasCustomValue = stackDefaultConfigProperties != null ? ((stackDefaultValue = stackDefaultConfigProperties.get(property)) != null ? !propertyValue.equals(stackDefaultValue) : true) : true;
        }
        return propertyHasCustomValue;
    }

    public Configuration copy() {
        Configuration parent = this.parentConfiguration;
        this.parentConfiguration = null;
        Configuration copy = new Configuration(this.getFullProperties(), this.getFullAttributes());
        this.parentConfiguration = parent;
        return copy;
    }

    public Configuration(Map<String, Map<String, String>> properties, Map<String, Map<String, Map<String, String>>> attributes, Configuration parentConfiguration) {
        this.properties = properties;
        this.attributes = attributes;
        this.parentConfiguration = parentConfiguration;
    }

    public Configuration(Map<String, Map<String, String>> properties, Map<String, Map<String, Map<String, String>>> attributes) {
        this.properties = properties;
        this.attributes = attributes;
    }

    public Map<String, Map<String, String>> getProperties() {
        return this.properties;
    }

    public Map<String, Map<String, String>> getFullProperties() {
        return this.getFullProperties(Integer.MAX_VALUE);
    }

    public Map<String, Map<String, String>> getFullProperties(int depthLimit) {
        HashMap<String, Map<String, String>> hashMap;
        if (depthLimit == 0) {
            HashMap<String, Map<String, String>> propertiesCopy = new HashMap<String, Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> typeProperties : this.properties.entrySet()) {
                propertiesCopy.put(typeProperties.getKey(), new HashMap<String, String>(typeProperties.getValue()));
            }
            return propertiesCopy;
        }
        if (this.parentConfiguration == null) {
            hashMap = new HashMap<String, Map<String, String>>();
        } else {
            HashMap<String, Map<String, String>> hashMap2 = new HashMap<String, Map<String, String>>(this.parentConfiguration.getFullProperties(--depthLimit));
            hashMap = hashMap2;
        }
        HashMap<String, Map<String, String>> mergedProperties = hashMap;
        for (Map.Entry<String, Map<String, String>> entry : this.properties.entrySet()) {
            String configType = entry.getKey();
            HashMap<String, String> typeProps = new HashMap<String, String>(entry.getValue());
            if (mergedProperties.containsKey(configType)) {
                ((Map)mergedProperties.get(configType)).putAll(typeProps);
                continue;
            }
            mergedProperties.put(configType, typeProps);
        }
        return mergedProperties;
    }

    public Map<String, Map<String, Map<String, String>>> getAttributes() {
        return this.attributes;
    }

    public Map<String, Map<String, Map<String, String>>> getFullAttributes() {
        HashMap<String, Map<String, Map<String, String>>> mergedAttributeMap = this.parentConfiguration == null ? new HashMap<String, Map<String, Map<String, String>>>() : new HashMap<String, Map<String, Map<String, String>>>(this.parentConfiguration.getFullAttributes());
        for (Map.Entry<String, Map<String, Map<String, String>>> typeEntry : this.attributes.entrySet()) {
            String type = typeEntry.getKey();
            HashMap<String, HashMap<String, String>> typeAttributes = new HashMap<String, HashMap<String, String>>();
            for (Map.Entry<String, Map<String, String>> attributeEntry : typeEntry.getValue().entrySet()) {
                typeAttributes.put(attributeEntry.getKey(), new HashMap<String, String>(attributeEntry.getValue()));
            }
            if (!mergedAttributeMap.containsKey(type)) {
                mergedAttributeMap.put(type, typeAttributes);
                continue;
            }
            Map mergedAttributes = (Map)mergedAttributeMap.get(type);
            for (Map.Entry attributeEntry : typeAttributes.entrySet()) {
                String attribute = (String)attributeEntry.getKey();
                if (!mergedAttributes.containsKey(attribute)) {
                    mergedAttributes.put(attribute, (Map)attributeEntry.getValue());
                    continue;
                }
                Map mergedAttributeProps = (Map)mergedAttributes.get(attribute);
                for (Map.Entry propEntry : ((Map)attributeEntry.getValue()).entrySet()) {
                    mergedAttributeProps.put((String)propEntry.getKey(), (String)propEntry.getValue());
                }
            }
        }
        return mergedAttributeMap;
    }

    public String getPropertyValue(String configType, String propertyName) {
        String value = null;
        if (this.properties.containsKey(configType) && this.properties.get(configType).containsKey(propertyName)) {
            value = this.properties.get(configType).get(propertyName);
        } else if (this.parentConfiguration != null) {
            value = this.parentConfiguration.getPropertyValue(configType, propertyName);
        }
        return value;
    }

    public String getAttributeValue(String configType, String propertyName, String attributeName) {
        String value = null;
        if (this.attributes.containsKey(configType) && this.attributes.get(configType).containsKey(attributeName) && this.attributes.get(configType).get(attributeName).containsKey(propertyName)) {
            value = this.attributes.get(configType).get(attributeName).get(propertyName);
        } else if (this.parentConfiguration != null) {
            value = this.parentConfiguration.getAttributeValue(configType, propertyName, attributeName);
        }
        return value;
    }

    public String setProperty(String configType, String propertyName, String value) {
        String previousValue = this.getPropertyValue(configType, propertyName);
        Map<String, String> typeProperties = this.properties.get(configType);
        if (typeProperties == null) {
            typeProperties = new HashMap<String, String>();
            this.properties.put(configType, typeProperties);
        }
        typeProperties.put(propertyName, value);
        return previousValue;
    }

    public String removeProperty(String configType, String propertyName) {
        String previousValue = null;
        if (this.properties.containsKey(configType)) {
            previousValue = this.properties.get(configType).remove(propertyName);
        }
        if (this.parentConfiguration != null) {
            String parentPreviousValue = this.parentConfiguration.removeProperty(configType, propertyName);
            if (previousValue == null) {
                previousValue = parentPreviousValue;
            }
        }
        return previousValue;
    }

    public Set<String> moveProperties(String sourceConfigType, String targetConfigType, Set<String> propertiesToMove) {
        HashSet<String> moved = new HashSet<String>();
        for (String property : propertiesToMove) {
            if (!this.isPropertySet(sourceConfigType, property)) continue;
            String value = this.removeProperty(sourceConfigType, property);
            if (!this.isPropertySet(targetConfigType, property)) {
                this.setProperty(targetConfigType, property, value);
            }
            moved.add(property);
        }
        return moved;
    }

    public boolean isPropertySet(String configType, String propertyName) {
        return this.properties.containsKey(configType) && this.properties.get(configType).containsKey(propertyName) || this.parentConfiguration != null && this.parentConfiguration.isPropertySet(configType, propertyName);
    }

    public String setAttribute(String configType, String propertyName, String attributeName, String attributeValue) {
        Map<String, String> attributes;
        String previousValue = this.getAttributeValue(configType, propertyName, attributeName);
        Map<String, Map<String, String>> typeAttributes = this.attributes.get(configType);
        if (typeAttributes == null) {
            typeAttributes = new HashMap<String, Map<String, String>>();
            this.attributes.put(configType, typeAttributes);
        }
        if ((attributes = typeAttributes.get(attributeName)) == null) {
            attributes = new HashMap<String, String>();
            typeAttributes.put(attributeName, attributes);
        }
        attributes.put(propertyName, attributeValue);
        return previousValue;
    }

    public Collection<String> getAllConfigTypes() {
        HashSet<String> allTypes = new HashSet<String>();
        allTypes.addAll(this.getFullProperties().keySet());
        allTypes.addAll(this.getFullAttributes().keySet());
        return allTypes;
    }

    public boolean containsConfigType(String configType) {
        return this.properties.containsKey(configType) || this.attributes.containsKey(configType) || this.parentConfiguration != null && this.parentConfiguration.containsConfigType(configType);
    }

    public boolean containsConfig(String configType, String propertyName) {
        return this.properties.containsKey(configType) && this.properties.get(configType).containsKey(propertyName) || this.attributes.containsKey(configType) && this.attributes.get(configType).values().stream().filter(map -> map.containsKey(propertyName)).findAny().isPresent() || this.parentConfiguration != null && this.parentConfiguration.containsConfig(configType, propertyName);
    }

    public Configuration getParentConfiguration() {
        return this.parentConfiguration;
    }

    public void setParentConfiguration(Configuration parent) {
        this.parentConfiguration = parent;
    }

    public void removeConfigType(String configType) {
        if (this.properties != null) {
            this.properties.remove(configType);
        }
        if (this.attributes != null) {
            this.attributes.remove(configType);
        }
        if (this.parentConfiguration != null) {
            this.parentConfiguration.removeConfigType(configType);
        }
    }

    public static Configuration of(Pair<Map<String, Map<String, String>>, Map<String, Map<String, Map<String, String>>>> propertiesAndAttributes) {
        return new Configuration((Map)propertiesAndAttributes.getLeft(), (Map)propertiesAndAttributes.getRight());
    }

    public Pair<Map<String, Map<String, String>>, Map<String, Map<String, Map<String, String>>>> asPair() {
        return Pair.of(this.properties, this.attributes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return Objects.equals(this.properties, other.properties) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.parentConfiguration, other.parentConfiguration);
    }
}

