/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.ConfigurationFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Triple;

public class ConfigurableHelper {
    private static final ImmutableSet<String> PERMITTED_CONFIG_FIELDS = ImmutableSet.of((Object)"properties", (Object)"properties_attributes");

    public static Configuration parseConfigs(@Nullable Collection<? extends Map<String, ?>> configs) {
        Configuration configuration;
        if (null == configs || configs.isEmpty()) {
            configuration = Configuration.newEmpty();
        } else if (configs.iterator().next().keySet().iterator().next().contains("/")) {
            ConfigurableHelper.checkFlattenedConfig(configs);
            configuration = new ConfigurationFactory().getConfiguration(configs);
        } else {
            HashMap<String, Map<String, String>> allProperties = new HashMap<String, Map<String, String>>();
            HashMap<String, Map<String, Map<String, String>>> allAttributes = new HashMap<String, Map<String, Map<String, String>>>();
            configs.forEach(item -> {
                Preconditions.checkArgument((item.size() == 1 ? 1 : 0) != 0, (Object)"Each config object must have a single property which is the name of the config, e.g. \"cluster-env\" : {...}");
                Map.Entry configEntry = item.entrySet().iterator().next();
                String configName = (String)item.keySet().iterator().next();
                Preconditions.checkArgument((boolean)(configEntry.getValue() instanceof Map), (String)"The value for %s must be a JSON object (found: %s)", (Object)configName, (Object)ConfigurableHelper.getClassName(configEntry.getValue()));
                Map configData = (Map)configEntry.getValue();
                Sets.SetView extraKeys = Sets.difference(configData.keySet(), PERMITTED_CONFIG_FIELDS);
                boolean legacy = extraKeys.size() == configData.keySet().size();
                Preconditions.checkArgument((legacy || extraKeys.isEmpty() ? 1 : 0) != 0, (String)"Invalid fields in %s configuration: %s", (Object)configName, (Object)extraKeys);
                if (legacy) {
                    ConfigurableHelper.checkMap("don't care", configData, String.class);
                    Map properties = configData;
                    allProperties.put(configName, properties);
                } else {
                    if (configData.containsKey("properties")) {
                        ConfigurableHelper.checkMap("properties", configData.get("properties"), String.class);
                        Map properties = (Map)configData.get("properties");
                        allProperties.put(configName, properties);
                    }
                    if (configData.containsKey("properties_attributes")) {
                        ConfigurableHelper.checkMap("properties_attributes", configData.get("properties_attributes"), Map.class);
                        Map attributes = (Map)configData.get("properties_attributes");
                        attributes.forEach((key, value) -> ConfigurableHelper.checkMap(key, value, String.class));
                        allAttributes.put(configName, attributes);
                    }
                }
            });
            configuration = new Configuration(allProperties, allAttributes);
        }
        return configuration;
    }

    public static Collection<Map<String, Map<String, ?>>> convertConfigToMap(Configuration configuration) {
        ArrayList configurations = new ArrayList();
        Sets.SetView allConfigTypes = Sets.union(configuration.getProperties().keySet(), configuration.getAttributes().keySet());
        for (String configType : allConfigTypes) {
            HashMap<String, Map<String, Object>> configData = new HashMap<String, Map<String, Object>>();
            if (configuration.getProperties().containsKey(configType)) {
                configData.put("properties", configuration.getProperties().get(configType));
            }
            if (configuration.getAttributes().containsKey(configType)) {
                configData.put("properties_attributes", configuration.getAttributes().get(configType));
            }
            configurations.add((Map<String, Map<String, ?>>)ImmutableMap.of((Object)configType, configData));
        }
        return configurations;
    }

    private static void checkFlattenedConfig(Collection<? extends Map<String, ?>> configs) {
        configs.forEach(config -> {
            if (!config.isEmpty()) {
                List<String> firstKey = ConfigurationFactory.splitConfigurationKey((String)config.keySet().iterator().next());
                String configType = firstKey.get(0);
                boolean legacyConfig = ConfigurationFactory.isKeyInLegacyFormat(firstKey);
                config.keySet().forEach(key -> {
                    List<String> keyParts = ConfigurationFactory.splitConfigurationKey(key);
                    Preconditions.checkArgument((boolean)Objects.equals(configType, keyParts.get(0)), (String)"Invalid config type: %s. Should be: %s", (Object)keyParts.get(0), (Object)configType);
                    Preconditions.checkArgument((legacyConfig && ConfigurationFactory.isKeyInLegacyFormat(keyParts) || !legacyConfig && ConfigurationFactory.isKeyInNewFormat(keyParts) ? 1 : 0) != 0, (String)"Expected key in %s format, found [%s]", (Object)(legacyConfig ? "[config_type/property_name]" : "[config_type/properties/config_name] or [config_type/properties_attributes/attribute_name/property_name]"), (Object)key);
                });
            }
        });
    }

    private static void checkMap(String fieldName, Object mapObj, Class<?> valueType) {
        Preconditions.checkArgument((boolean)(mapObj instanceof Map), (String)"'%s' needs to be a JSON object. Found: %s", (Object)fieldName, (Object)ConfigurableHelper.getClassName(mapObj));
        Map map = (Map)mapObj;
        map.forEach((__, value) -> Preconditions.checkArgument((boolean)valueType.isInstance(value), (String)"Expected %s as value type, found %s, type: %s", (Object)valueType.getName(), (Object)value, (Object)ConfigurableHelper.getClassName(value)));
    }

    private static String getClassName(Object object) {
        return null != object ? object.getClass().getName() : null;
    }

    public static Map<String, Map<String, String>> transformAttributesMap(Map<String, Map<String, String>> input) {
        return input.entrySet().stream().flatMap(outer -> ((Map)outer.getValue()).entrySet().stream().map(inner -> Triple.of((Object)((String)outer.getKey()), (Object)((String)inner.getKey()), (Object)((String)inner.getValue())))).collect(Collectors.groupingBy(Triple::getMiddle, Collectors.toMap(Triple::getLeft, Triple::getRight)));
    }
}

