/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.controller.internal.ProvisionClusterRequest;
import id.onyx.obdp.server.topology.AdvisedConfiguration;
import id.onyx.obdp.server.topology.AmbariContext;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.ConfigRecommendationStrategy;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.NoSuchHostGroupException;
import id.onyx.obdp.server.topology.TopologyRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTopologyImpl
implements ClusterTopology {
    private Long clusterId;
    private Blueprint blueprint;
    private Configuration configuration;
    private ConfigRecommendationStrategy configRecommendationStrategy;
    private ProvisionAction provisionAction = ProvisionAction.INSTALL_AND_START;
    private Map<String, AdvisedConfiguration> advisedConfigurations = new HashMap<String, AdvisedConfiguration>();
    private final Map<String, HostGroupInfo> hostGroupInfoMap = new HashMap<String, HostGroupInfo>();
    private final AmbariContext ambariContext;
    private final String defaultPassword;
    private static final Logger LOG = LoggerFactory.getLogger(ClusterTopologyImpl.class);

    public ClusterTopologyImpl(AmbariContext ambariContext, TopologyRequest topologyRequest) throws InvalidTopologyException {
        this.clusterId = topologyRequest.getClusterId();
        this.blueprint = topologyRequest.getBlueprint();
        this.configuration = topologyRequest.getConfiguration();
        this.defaultPassword = topologyRequest instanceof ProvisionClusterRequest ? ((ProvisionClusterRequest)topologyRequest).getDefaultPassword() : null;
        this.registerHostGroupInfo(topologyRequest.getHostGroupInfo());
        this.ambariContext = ambariContext;
    }

    @Override
    public void update(TopologyRequest topologyRequest) throws InvalidTopologyException {
        this.registerHostGroupInfo(topologyRequest.getHostGroupInfo());
    }

    @Override
    public Long getClusterId() {
        return this.clusterId;
    }

    @Override
    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Map<String, HostGroupInfo> getHostGroupInfo() {
        return this.hostGroupInfoMap;
    }

    @Override
    public Collection<String> getHostGroupsForComponent(String component) {
        ArrayList<String> resultGroups = new ArrayList<String>();
        for (HostGroup group : this.getBlueprint().getHostGroups().values()) {
            if (!group.getComponentNames().contains(component)) continue;
            resultGroups.add(group.getName());
        }
        return resultGroups;
    }

    @Override
    public String getHostGroupForHost(String hostname) {
        for (HostGroupInfo groupInfo : this.hostGroupInfoMap.values()) {
            if (!groupInfo.getHostNames().contains(hostname)) continue;
            return groupInfo.getHostGroupName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHostToTopology(String hostGroupName, String host) throws InvalidTopologyException, NoSuchHostGroupException {
        if (this.blueprint.getHostGroup(hostGroupName) == null) {
            throw new NoSuchHostGroupException("Attempted to add host to non-existing host group: " + hostGroupName);
        }
        String groupContainsHost = this.getHostGroupForHost(host);
        if (groupContainsHost != null && !hostGroupName.equals(groupContainsHost)) {
            throw new InvalidTopologyException(String.format("Attempted to add host '%s' to hostgroup '%s' but it is already associated with hostgroup '%s'.", host, hostGroupName, groupContainsHost));
        }
        Map<String, HostGroupInfo> map = this.hostGroupInfoMap;
        synchronized (map) {
            HostGroupInfo existingHostGroupInfo = this.hostGroupInfoMap.get(hostGroupName);
            if (existingHostGroupInfo == null) {
                throw new RuntimeException(String.format("An attempt was made to add host '%s' to an unregistered hostgroup '%s'", host, hostGroupName));
            }
            existingHostGroupInfo.addHost(host);
            LOG.info("ClusterTopologyImpl.addHostTopology: added host = " + host + " to host group = " + existingHostGroupInfo.getHostGroupName());
        }
    }

    @Override
    public Set<String> getAllHosts() {
        return this.hostGroupInfoMap.values().stream().flatMap(hg -> hg.getHostNames().stream()).collect(Collectors.toSet());
    }

    @Override
    public Collection<String> getHostAssignmentsForComponent(String component) {
        ArrayList<String> hosts = new ArrayList<String>();
        Collection<String> hostGroups = this.getHostGroupsForComponent(component);
        for (String group : hostGroups) {
            HostGroupInfo hostGroupInfo = this.getHostGroupInfo().get(group);
            if (hostGroupInfo != null) {
                hosts.addAll(hostGroupInfo.getHostNames());
                continue;
            }
            LOG.warn("HostGroup {} not found, when checking for hosts for component {}", (Object)group, (Object)component);
        }
        return hosts;
    }

    @Override
    public boolean isNameNodeHAEnabled() {
        return ClusterTopologyImpl.isNameNodeHAEnabled(this.configuration.getFullProperties());
    }

    public static boolean isNameNodeHAEnabled(Map<String, Map<String, String>> configurationProperties) {
        return configurationProperties.containsKey("hdfs-site") && (configurationProperties.get("hdfs-site").containsKey("dfs.nameservices") || configurationProperties.get("hdfs-site").containsKey("dfs.internal.nameservices"));
    }

    @Override
    public boolean isYarnResourceManagerHAEnabled() {
        return ClusterTopologyImpl.isYarnResourceManagerHAEnabled(this.configuration.getFullProperties());
    }

    static boolean isYarnResourceManagerHAEnabled(Map<String, Map<String, String>> configProperties) {
        return configProperties.containsKey("yarn-site") && configProperties.get("yarn-site").containsKey("yarn.resourcemanager.ha.enabled") && configProperties.get("yarn-site").get("yarn.resourcemanager.ha.enabled").equals("true");
    }

    @Override
    public boolean isClusterKerberosEnabled() {
        return this.ambariContext.isClusterKerberosEnabled(this.getClusterId());
    }

    @Override
    public RequestStatusResponse installHost(String hostName, boolean skipInstallTaskCreate, boolean skipFailure) {
        try {
            String hostGroupName = this.getHostGroupForHost(hostName);
            HostGroup hostGroup = this.blueprint.getHostGroup(hostGroupName);
            ArrayList<String> skipInstallForComponents = new ArrayList<String>();
            if (skipInstallTaskCreate) {
                skipInstallForComponents.add("ALL");
            } else {
                skipInstallForComponents.addAll(hostGroup.getComponentNames(ProvisionAction.START_ONLY));
            }
            Collection<String> dontSkipInstallForComponents = hostGroup.getComponentNames(ProvisionAction.INSTALL_ONLY);
            dontSkipInstallForComponents.addAll(hostGroup.getComponentNames(ProvisionAction.INSTALL_AND_START));
            return this.ambariContext.installHost(hostName, this.ambariContext.getClusterName(this.getClusterId()), skipInstallForComponents, dontSkipInstallForComponents, skipFailure);
        }
        catch (OBDPException e) {
            LOG.error("Cannot get cluster name for clusterId = " + this.getClusterId(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public RequestStatusResponse startHost(String hostName, boolean skipFailure) {
        try {
            String hostGroupName = this.getHostGroupForHost(hostName);
            HostGroup hostGroup = this.blueprint.getHostGroup(hostGroupName);
            Collection<String> installOnlyComponents = hostGroup.getComponentNames(ProvisionAction.INSTALL_ONLY);
            return this.ambariContext.startHost(hostName, this.ambariContext.getClusterName(this.getClusterId()), installOnlyComponents, skipFailure);
        }
        catch (OBDPException e) {
            LOG.error("Cannot get cluster name for clusterId = " + this.getClusterId(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setConfigRecommendationStrategy(ConfigRecommendationStrategy strategy) {
        this.configRecommendationStrategy = strategy;
    }

    @Override
    public ConfigRecommendationStrategy getConfigRecommendationStrategy() {
        return this.configRecommendationStrategy;
    }

    @Override
    public ProvisionAction getProvisionAction() {
        return this.provisionAction;
    }

    @Override
    public void setProvisionAction(ProvisionAction provisionAction) {
        this.provisionAction = provisionAction;
    }

    @Override
    public Map<String, AdvisedConfiguration> getAdvisedConfigurations() {
        return this.advisedConfigurations;
    }

    @Override
    public AmbariContext getAmbariContext() {
        return this.ambariContext;
    }

    @Override
    public void removeHost(String hostname) {
        for (Map.Entry<String, HostGroupInfo> entry : this.hostGroupInfoMap.entrySet()) {
            entry.getValue().removeHost(hostname);
        }
    }

    @Override
    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    @Override
    public boolean hasHadoopCompatibleService() {
        return this.blueprint.getServiceInfos().stream().anyMatch(service -> "HCFS".equals(service.getServiceType()));
    }

    private void registerHostGroupInfo(Map<String, HostGroupInfo> requestedHostGroupInfoMap) throws InvalidTopologyException {
        LOG.debug("Registering requested host group information for {} hostgroups", (Object)requestedHostGroupInfoMap.size());
        this.checkForDuplicateHosts(requestedHostGroupInfoMap);
        for (HostGroupInfo requestedHostGroupInfo : requestedHostGroupInfoMap.values()) {
            String hostGroupName = requestedHostGroupInfo.getHostGroupName();
            HostGroup baseHostGroup = this.getBlueprint().getHostGroup(hostGroupName);
            if (baseHostGroup == null) {
                throw new IllegalArgumentException("Invalid host_group specified: " + hostGroupName + ".  All request host groups must have a corresponding host group in the specified blueprint");
            }
            HostGroupInfo currentHostGroupInfo = this.hostGroupInfoMap.get(hostGroupName);
            if (currentHostGroupInfo == null) {
                Configuration bpHostGroupConfig = baseHostGroup.getConfiguration();
                Configuration parentConfiguration = new Configuration(bpHostGroupConfig.getProperties(), bpHostGroupConfig.getAttributes(), this.getConfiguration());
                requestedHostGroupInfo.getConfiguration().setParentConfiguration(parentConfiguration);
                this.hostGroupInfoMap.put(hostGroupName, requestedHostGroupInfo);
                continue;
            }
            if (!requestedHostGroupInfo.getHostNames().isEmpty()) {
                try {
                    this.addHostsToTopology(requestedHostGroupInfo);
                    continue;
                }
                catch (NoSuchHostGroupException e) {
                    throw new InvalidTopologyException("Attempted to add hosts to unknown host group: " + hostGroupName);
                }
            }
            currentHostGroupInfo.setRequestedCount(currentHostGroupInfo.getRequestedHostCount() + requestedHostGroupInfo.getRequestedHostCount());
        }
    }

    private void addHostsToTopology(HostGroupInfo hostGroupInfo) throws InvalidTopologyException, NoSuchHostGroupException {
        for (String host : hostGroupInfo.getHostNames()) {
            this.registerRackInfo(hostGroupInfo, host);
            this.addHostToTopology(hostGroupInfo.getHostGroupName(), host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRackInfo(HostGroupInfo hostGroupInfo, String host) {
        Map<String, HostGroupInfo> map = this.hostGroupInfoMap;
        synchronized (map) {
            HostGroupInfo cachedHGI = this.hostGroupInfoMap.get(hostGroupInfo.getHostGroupName());
            if (null != cachedHGI) {
                cachedHGI.addHostRackInfo(host, hostGroupInfo.getHostRackInfo().get(host));
            }
        }
    }

    private void checkForDuplicateHosts(Map<String, HostGroupInfo> groupInfoMap) throws InvalidTopologyException {
        HashSet<String> hosts = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (HostGroupInfo group : groupInfoMap.values()) {
            Collection<String> groupHosts = group.getHostNames();
            HashSet<String> groupHostsCopy = new HashSet<String>(group.getHostNames());
            groupHostsCopy.retainAll(hosts);
            duplicates.addAll(groupHostsCopy);
            hosts.addAll(groupHosts);
            for (String host : groupHosts) {
                if (this.getHostGroupForHost(host) == null) continue;
                duplicates.add(host);
            }
        }
        if (!duplicates.isEmpty()) {
            throw new InvalidTopologyException("The following hosts are mapped to multiple host groups: " + duplicates + ". Be aware that host names are converted to lowercase, case differences do not matter in Ambari deployments.");
        }
    }
}

