/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorBlueprintProcessor;
import id.onyx.obdp.server.controller.ClusterRequest;
import id.onyx.obdp.server.controller.ConfigurationRequest;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.internal.BlueprintConfigurationProcessor;
import id.onyx.obdp.server.controller.internal.ConfigurationTopologyException;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.serveraction.kerberos.KerberosInvalidConfigurationException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.topology.AmbariContext;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.ConfigRecommendationStrategy;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigurationRequest {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterConfigurationRequest.class);
    private static final Pattern CLUSTER_HOST_INFO_PATTERN_VARIABLE = Pattern.compile("\\$\\{clusterHostInfo/?([\\w\\-\\.]+)_host(?:\\s*\\|\\s*(.+?))?\\}");
    private AmbariContext ambariContext;
    private ClusterTopology clusterTopology;
    private BlueprintConfigurationProcessor configurationProcessor;
    private StackAdvisorBlueprintProcessor stackAdvisorBlueprintProcessor;
    private Stack stack;
    private boolean configureSecurity = false;

    public ClusterConfigurationRequest(AmbariContext ambariContext, ClusterTopology topology, boolean setInitial, StackAdvisorBlueprintProcessor stackAdvisorBlueprintProcessor, boolean configureSecurity) {
        this(ambariContext, topology, setInitial, stackAdvisorBlueprintProcessor);
        this.configureSecurity = configureSecurity;
    }

    public ClusterConfigurationRequest(AmbariContext ambariContext, ClusterTopology clusterTopology, boolean setInitial, StackAdvisorBlueprintProcessor stackAdvisorBlueprintProcessor) {
        this.ambariContext = ambariContext;
        this.clusterTopology = clusterTopology;
        Blueprint blueprint = clusterTopology.getBlueprint();
        this.stack = blueprint.getStack();
        this.configurationProcessor = new BlueprintConfigurationProcessor(clusterTopology);
        this.stackAdvisorBlueprintProcessor = stackAdvisorBlueprintProcessor;
        this.removeOrphanConfigTypes();
        if (setInitial) {
            this.setConfigurationsOnCluster(clusterTopology, "INITIAL", Collections.emptySet());
        }
    }

    private void removeOrphanConfigTypes(Configuration configuration) {
        Blueprint blueprint = this.clusterTopology.getBlueprint();
        Collection<String> configTypes = configuration.getAllConfigTypes();
        for (String configType : configTypes) {
            if (blueprint.isValidConfigType(configType)) continue;
            configuration.removeConfigType(configType);
            LOG.info("Removing config type '{}' as related service is not present in either Blueprint or cluster creation template.", (Object)configType);
        }
    }

    private void removeOrphanConfigTypes() {
        Configuration configuration = this.clusterTopology.getConfiguration();
        this.removeOrphanConfigTypes(configuration);
        Map<String, HostGroupInfo> hostGroupInfoMap = this.clusterTopology.getHostGroupInfo();
        if (MapUtils.isNotEmpty(hostGroupInfoMap)) {
            for (Map.Entry<String, HostGroupInfo> hostGroupInfo : hostGroupInfoMap.entrySet()) {
                configuration = hostGroupInfo.getValue().getConfiguration();
                if (configuration == null) continue;
                this.removeOrphanConfigTypes(configuration);
            }
        }
    }

    public Collection<String> getRequiredHostGroups() {
        HashSet<String> requiredHostGroups = new HashSet<String>();
        requiredHostGroups.addAll(this.configurationProcessor.getRequiredHostGroups());
        if (this.configureSecurity) {
            requiredHostGroups.addAll(this.getRequiredHostgroupsForKerberosConfiguration());
        }
        return requiredHostGroups;
    }

    public void process() throws OBDPException, ConfigurationTopologyException {
        HashSet<String> updatedConfigTypes = new HashSet<String>();
        Map<String, Map<String, String>> userProvidedConfigurations = this.clusterTopology.getConfiguration().getFullProperties(1);
        try {
            if (this.configureSecurity) {
                Configuration clusterConfiguration = this.clusterTopology.getConfiguration();
                Map<String, Map<String, String>> existingConfigurations = clusterConfiguration.getFullProperties();
                updatedConfigTypes.addAll(this.configureKerberos(clusterConfiguration, existingConfigurations));
            }
            if (!ConfigRecommendationStrategy.NEVER_APPLY.equals((Object)this.clusterTopology.getConfigRecommendationStrategy())) {
                this.stackAdvisorBlueprintProcessor.adviseConfiguration(this.clusterTopology, userProvidedConfigurations);
            }
            updatedConfigTypes.addAll(this.configurationProcessor.doUpdateForClusterCreate());
        }
        catch (ConfigurationTopologyException e) {
            LOG.error("An exception occurred while doing configuration topology update: " + e, (Throwable)e);
        }
        this.setConfigurationsOnCluster(this.clusterTopology, "TOPOLOGY_RESOLVED", updatedConfigTypes);
    }

    private Set<String> configureKerberos(Configuration clusterConfiguration, Map<String, Map<String, String>> existingConfigurations) throws OBDPException {
        Cluster cluster = this.getCluster();
        Blueprint blueprint = this.clusterTopology.getBlueprint();
        ImmutableSet services = ImmutableSet.copyOf(blueprint.getServices());
        Configuration stackDefaults = blueprint.getStack().getConfiguration((Collection<String>)services);
        Map<String, String> componentHostsMap = this.createComponentHostMap(blueprint);
        existingConfigurations.put("clusterHostInfo", componentHostsMap);
        try {
            KerberosHelper kerberosHelper = AmbariContext.getController().getKerberosHelper();
            kerberosHelper.ensureHeadlessIdentities(cluster, existingConfigurations, (Set<String>)services);
            Map<String, Map<String, String>> updatedConfigs = kerberosHelper.getServiceConfigurationUpdates(cluster, existingConfigurations, this.createServiceComponentMap(blueprint), null, null, true, false);
            updatedConfigs.computeIfAbsent("cluster-env", __ -> new HashMap()).put("security_enabled", "true");
            updatedConfigs.keySet().removeIf(configType -> !blueprint.isValidConfigType((String)configType));
            return clusterConfiguration.applyUpdatesToStackDefaultProperties(stackDefaults, existingConfigurations, updatedConfigs);
        }
        catch (KerberosInvalidConfigurationException e) {
            LOG.error("An exception occurred while doing Kerberos related configuration update: " + e, (Throwable)e);
            return ImmutableSet.of();
        }
    }

    private Map<String, Set<String>> createServiceComponentMap(Blueprint blueprint) {
        HashMap<String, Set<String>> serviceComponents = new HashMap<String, Set<String>>();
        Collection<String> services = blueprint.getServices();
        if (services != null) {
            for (String service : services) {
                Collection<String> components = blueprint.getComponents(service);
                ImmutableSet componentSet = components == null ? ImmutableSet.of() : ImmutableSet.copyOf(components);
                serviceComponents.put(service, (Set<String>)componentSet);
            }
        }
        return serviceComponents;
    }

    private Map<String, String> createComponentHostMap(Blueprint blueprint) {
        return StageUtils.createComponentHostMap(blueprint.getServices(), blueprint::getComponents, (service, component) -> this.clusterTopology.getHostAssignmentsForComponent((String)component));
    }

    private Collection<String> getRequiredHostgroupsForKerberosConfiguration() {
        HashSet<String> requiredHostGroups = new HashSet<String>();
        try {
            Cluster cluster = this.getCluster();
            Blueprint blueprint = this.clusterTopology.getBlueprint();
            Configuration clusterConfiguration = this.clusterTopology.getConfiguration();
            Map<String, Map<String, String>> existingConfigurations = clusterConfiguration.getFullProperties();
            existingConfigurations.put("clusterHostInfo", new HashMap());
            Map<String, Map<String, String>> updatedConfigs = AmbariContext.getController().getKerberosHelper().getServiceConfigurationUpdates(cluster, existingConfigurations, this.createServiceComponentMap(blueprint), null, null, true, false);
            for (String configType : updatedConfigs.keySet()) {
                Map<String, String> propertyMap = updatedConfigs.get(configType);
                for (String property : propertyMap.keySet()) {
                    String propertyValue = propertyMap.get(property);
                    Matcher matcher = CLUSTER_HOST_INFO_PATTERN_VARIABLE.matcher(propertyValue);
                    while (matcher.find()) {
                        String component = matcher.group(1).toUpperCase();
                        Collection<String> hostGroups = this.clusterTopology.getHostGroupsForComponent(component);
                        if (hostGroups.isEmpty()) {
                            LOG.warn("No matching hostgroup found for component: {} specified in Kerberos config type: {} property: {}", new Object[]{component, configType, property});
                            continue;
                        }
                        requiredHostGroups.addAll(hostGroups);
                    }
                }
            }
        }
        catch (OBDPException | KerberosInvalidConfigurationException e) {
            LOG.error("An exception occurred while doing Kerberos related configuration update: " + (Exception)e, e);
        }
        return requiredHostGroups;
    }

    private Cluster getCluster() throws OBDPException {
        String clusterName = this.ambariContext.getClusterName(this.clusterTopology.getClusterId());
        return AmbariContext.getController().getClusters().getCluster(clusterName);
    }

    public void setConfigurationsOnCluster(ClusterTopology clusterTopology, String tag, Set<String> updatedConfigTypes) {
        LinkedList<BlueprintServiceConfigRequest> configurationRequests = new LinkedList<BlueprintServiceConfigRequest>();
        Blueprint blueprint = clusterTopology.getBlueprint();
        Configuration clusterConfiguration = clusterTopology.getConfiguration();
        for (String service : blueprint.getServices()) {
            BlueprintServiceConfigRequest blueprintConfigRequest = new BlueprintServiceConfigRequest(service);
            for (String serviceConfigType : this.stack.getAllConfigurationTypes(service)) {
                Set<String> excludedConfigTypes = this.stack.getExcludedConfigurationTypes(service);
                if (excludedConfigTypes.contains(serviceConfigType) || serviceConfigType.equals("cluster-env") || !clusterConfiguration.getFullProperties().containsKey(serviceConfigType)) continue;
                blueprintConfigRequest.addConfigElement(serviceConfigType, clusterConfiguration.getFullProperties().get(serviceConfigType), clusterConfiguration.getFullAttributes().get(serviceConfigType));
            }
            configurationRequests.add(blueprintConfigRequest);
        }
        BlueprintServiceConfigRequest globalConfigRequest = new BlueprintServiceConfigRequest("GLOBAL-CONFIG");
        Map<String, String> clusterEnvProps = clusterConfiguration.getFullProperties().get("cluster-env");
        Map<String, Map<String, String>> clusterEnvAttributes = clusterConfiguration.getFullAttributes().get("cluster-env");
        globalConfigRequest.addConfigElement("cluster-env", clusterEnvProps, clusterEnvAttributes);
        configurationRequests.add(globalConfigRequest);
        this.setConfigurationsOnCluster(configurationRequests, tag, updatedConfigTypes);
    }

    private void setConfigurationsOnCluster(List<BlueprintServiceConfigRequest> configurationRequests, String tag, Set<String> updatedConfigTypes) {
        Cluster cluster;
        String clusterName;
        try {
            clusterName = this.ambariContext.getClusterName(this.clusterTopology.getClusterId());
            cluster = AmbariContext.getController().getClusters().getCluster(clusterName);
        }
        catch (OBDPException e) {
            LOG.error("Cannot get cluster name for clusterId = " + this.clusterTopology.getClusterId(), (Throwable)e);
            throw new RuntimeException(e);
        }
        for (BlueprintServiceConfigRequest blueprintConfigRequest : configurationRequests) {
            ClusterRequest clusterRequest = null;
            LinkedList<ConfigurationRequest> requestsPerService = new LinkedList<ConfigurationRequest>();
            for (BlueprintServiceConfigElement blueprintElement : blueprintConfigRequest.getConfigElements()) {
                HashMap<String, Object> clusterProperties = new HashMap<String, Object>();
                clusterProperties.put("Clusters/cluster_name", clusterName);
                clusterProperties.put("Clusters/desired_configs/type", blueprintElement.getTypeName());
                clusterProperties.put("Clusters/desired_configs/tag", tag);
                for (Map.Entry<String, String> entry : blueprintElement.getConfiguration().entrySet()) {
                    clusterProperties.put("Clusters/desired_configs/properties/" + entry.getKey(), entry.getValue());
                }
                if (blueprintElement.getAttributes() != null) {
                    for (Map.Entry<String, Object> entry : blueprintElement.getAttributes().entrySet()) {
                        String attributeName = entry.getKey();
                        for (Map.Entry attributeOccurrence : ((Map)entry.getValue()).entrySet()) {
                            clusterProperties.put("Clusters/desired_configs/properties_attributes/" + attributeName + "/" + (String)attributeOccurrence.getKey(), attributeOccurrence.getValue());
                        }
                    }
                }
                if (clusterRequest == null) {
                    SecurityType securityType;
                    String string = (String)clusterProperties.get("Clusters/security_type");
                    if (string == null) {
                        securityType = null;
                    } else {
                        try {
                            securityType = SecurityType.valueOf(string.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException(String.format("Cannot set cluster security type to invalid value: %s", string));
                        }
                    }
                    clusterRequest = new ClusterRequest((Long)clusterProperties.get("Clusters/cluster_id"), (String)clusterProperties.get("Clusters/cluster_name"), (String)clusterProperties.get("Clusters/provisioning_state"), securityType, (String)clusterProperties.get("Clusters/version"), null);
                }
                List<ConfigurationRequest> listOfRequests = this.ambariContext.createConfigurationRequests(clusterProperties);
                requestsPerService.addAll(listOfRequests);
            }
            if (clusterRequest != null) {
                clusterRequest.setDesiredConfig(requestsPerService);
                LOG.info("Sending cluster config update request for service = " + blueprintConfigRequest.getServiceName());
                this.ambariContext.setConfigurationOnCluster(clusterRequest);
                continue;
            }
            LOG.error("ClusterRequest should not be null for service = " + blueprintConfigRequest.getServiceName());
        }
        cluster.refresh();
        this.ambariContext.notifyAgentsAboutConfigsChanges(clusterName);
        if (tag.equals("TOPOLOGY_RESOLVED")) {
            try {
                this.ambariContext.waitForConfigurationResolution(clusterName, updatedConfigTypes);
            }
            catch (OBDPException e) {
                LOG.error("Error while attempting to wait for the cluster configuration to reach TOPOLOGY_RESOLVED state.", (Throwable)e);
            }
        }
    }

    private static class BlueprintServiceConfigRequest {
        private final String serviceName;
        private List<BlueprintServiceConfigElement> configElements = new LinkedList<BlueprintServiceConfigElement>();

        BlueprintServiceConfigRequest(String serviceName) {
            this.serviceName = serviceName;
        }

        void addConfigElement(String type, Map<String, String> props, Map<String, Map<String, String>> attributes) {
            if (props == null) {
                props = Collections.emptyMap();
            }
            if (attributes == null) {
                attributes = Collections.emptyMap();
            }
            this.configElements.add(new BlueprintServiceConfigElement(type, props, attributes));
        }

        public String getServiceName() {
            return this.serviceName;
        }

        List<BlueprintServiceConfigElement> getConfigElements() {
            return this.configElements;
        }
    }

    private static class BlueprintServiceConfigElement {
        private final String typeName;
        private final Map<String, String> configuration;
        private final Map<String, Map<String, String>> attributes;

        BlueprintServiceConfigElement(String type, Map<String, String> props, Map<String, Map<String, String>> attributes) {
            this.typeName = type;
            this.configuration = props;
            this.attributes = attributes;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Map<String, String> getConfiguration() {
            return this.configuration;
        }

        public Map<String, Map<String, String>> getAttributes() {
            return this.attributes;
        }
    }
}

