/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

public class Cardinality {
    String cardinality;
    int min = 0;
    int max = Integer.MAX_VALUE;
    int exact = -1;
    boolean isAll = false;

    public Cardinality(String cardinality) {
        this.cardinality = cardinality;
        if (cardinality != null && !cardinality.isEmpty()) {
            if (cardinality.contains("+")) {
                this.min = Integer.parseInt(cardinality.split("\\+")[0]);
            } else if (cardinality.contains("-")) {
                String[] toks = cardinality.split("-");
                this.min = Integer.parseInt(toks[0]);
                this.max = Integer.parseInt(toks[1]);
            } else if (cardinality.equals("ALL")) {
                this.isAll = true;
            } else {
                this.exact = Integer.parseInt(cardinality);
            }
        }
    }

    public boolean isAll() {
        return this.isAll;
    }

    public boolean isValidCount(int count) {
        if (this.isAll) {
            return false;
        }
        if (this.exact != -1) {
            return count == this.exact;
        }
        return count >= this.min && count <= this.max;
    }

    public boolean supportsAutoDeploy() {
        return this.isValidCount(1) || this.isAll;
    }

    public String getValue() {
        return this.cardinality;
    }
}

