/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.inject.Inject;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.state.AutoDeployInfo;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.DependencyConditionInfo;
import id.onyx.obdp.server.state.DependencyInfo;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.BlueprintValidator;
import id.onyx.obdp.server.topology.Cardinality;
import id.onyx.obdp.server.topology.ClusterTopologyImpl;
import id.onyx.obdp.server.topology.GPLLicenseNotAcceptedException;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.utils.SecretReference;
import id.onyx.obdp.server.utils.VersionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class BlueprintValidatorImpl
implements BlueprintValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintValidatorImpl.class);
    private final Blueprint blueprint;
    private final Stack stack;
    public static final String LZO_CODEC_CLASS_PROPERTY_NAME = "io.compression.codec.lzo.class";
    public static final String CODEC_CLASSES_PROPERTY_NAME = "io.compression.codecs";
    public static final String LZO_CODEC_CLASS = "com.hadoop.compression.lzo.LzoCodec";
    @Inject
    private static Configuration configuration;

    public BlueprintValidatorImpl(Blueprint blueprint) {
        this.blueprint = blueprint;
        this.stack = blueprint.getStack();
    }

    @Override
    public void validateTopology() throws InvalidTopologyException {
        LOGGER.info("Validating topology for blueprint: [{}]", (Object)this.blueprint.getName());
        Collection<HostGroup> hostGroups = this.blueprint.getHostGroups().values();
        HashMap<String, Map<String, Collection<DependencyInfo>>> dependenciesValidationIssues = new HashMap<String, Map<String, Collection<DependencyInfo>>>();
        for (HostGroup group : hostGroups) {
            Map<String, Collection<DependencyInfo>> groupDependenciesValidationIssues = this.validateHostGroup(group, "inclusive");
            groupDependenciesValidationIssues.putAll(this.validateHostGroup(group, "exclusive"));
            if (groupDependenciesValidationIssues.isEmpty()) continue;
            dependenciesValidationIssues.put(group.getName(), groupDependenciesValidationIssues);
        }
        HashSet<String> cardinalityFailures = new HashSet<String>();
        Collection<String> services = this.blueprint.getServices();
        for (String service : services) {
            for (String component : this.stack.getComponents(service)) {
                Cardinality cardinality = this.stack.getCardinality(component);
                AutoDeployInfo autoDeploy = this.stack.getAutoDeployInfo(component);
                if (cardinality.isAll()) {
                    cardinalityFailures.addAll(this.verifyComponentInAllHostGroups(component, autoDeploy));
                    continue;
                }
                cardinalityFailures.addAll(this.verifyComponentCardinalityCount(component, cardinality, autoDeploy));
            }
        }
        if (!dependenciesValidationIssues.isEmpty() || !cardinalityFailures.isEmpty()) {
            this.generateInvalidTopologyException(dependenciesValidationIssues, cardinalityFailures);
        }
    }

    @Override
    public void validateRequiredProperties() throws InvalidTopologyException, GPLLicenseNotAcceptedException {
        Map<String, Map<String, String>> clusterConfigurations = this.blueprint.getConfiguration().getProperties();
        if (clusterConfigurations != null) {
            boolean gplEnabled = configuration.getGplLicenseAccepted();
            StringBuilder errorMessage = new StringBuilder();
            boolean containsSecretReferences = false;
            for (Map.Entry<String, Map<String, String>> configEntry : clusterConfigurations.entrySet()) {
                String configType = configEntry.getKey();
                if (configEntry.getValue() == null) continue;
                for (Map.Entry<String, String> propertyEntry : configEntry.getValue().entrySet()) {
                    String propertyName = propertyEntry.getKey();
                    String propertyValue = propertyEntry.getValue();
                    if (propertyValue == null) continue;
                    if (!gplEnabled && configType.equals("core-site") && (propertyName.equals(LZO_CODEC_CLASS_PROPERTY_NAME) || propertyName.equals(CODEC_CLASSES_PROPERTY_NAME)) && propertyValue.contains(LZO_CODEC_CLASS)) {
                        throw new GPLLicenseNotAcceptedException("Your Ambari server has not been configured to download LZO GPL software. Please refer to documentation to configure Ambari before proceeding.");
                    }
                    if (!SecretReference.isSecret(propertyValue)) continue;
                    errorMessage.append("  Config:" + configType + " Property:" + propertyName + "\n");
                    containsSecretReferences = true;
                }
            }
            if (containsSecretReferences) {
                throw new InvalidTopologyException("Secret references are not allowed in blueprints, replace following properties with real passwords:\n" + errorMessage);
            }
        }
        for (HostGroup hostGroup : this.blueprint.getHostGroups().values()) {
            HashMap<String, Map<String, String>> operationalConfiguration = new HashMap<String, Map<String, String>>(clusterConfigurations);
            operationalConfiguration.putAll(hostGroup.getConfiguration().getProperties());
            for (String component : hostGroup.getComponentNames()) {
                Map<String, String> oozieEnvConfig;
                Map<String, String> hadoopEnvConfig;
                Map<String, String> hiveEnvConfig;
                if (component.equals("MYSQL_SERVER") && (hiveEnvConfig = clusterConfigurations.get("hive-env")) != null && !hiveEnvConfig.isEmpty() && hiveEnvConfig.get("hive_database") != null && hiveEnvConfig.get("hive_database").startsWith("Existing")) {
                    throw new InvalidTopologyException("Incorrect configuration: MYSQL_SERVER component is available but hive using existing db!");
                }
                if (ClusterTopologyImpl.isNameNodeHAEnabled(clusterConfigurations) && component.equals("NAMENODE") && (hadoopEnvConfig = clusterConfigurations.get("hadoop-env")) != null && !hadoopEnvConfig.isEmpty() && hadoopEnvConfig.containsKey("dfs_ha_initial_namenode_active") && hadoopEnvConfig.containsKey("dfs_ha_initial_namenode_standby")) {
                    ArrayList<HostGroup> hostGroupsForComponent = new ArrayList<HostGroup>(this.blueprint.getHostGroupsForComponent(component));
                    HashSet<String> givenHostGroups = new HashSet<String>();
                    givenHostGroups.add(hadoopEnvConfig.get("dfs_ha_initial_namenode_active"));
                    givenHostGroups.add(hadoopEnvConfig.get("dfs_ha_initial_namenode_standby"));
                    if (givenHostGroups.size() != hostGroupsForComponent.size()) {
                        throw new IllegalArgumentException("NAMENODE HA host groups mapped incorrectly for properties 'dfs_ha_initial_namenode_active' and 'dfs_ha_initial_namenode_standby'. Expected Host groups are :" + hostGroupsForComponent);
                    }
                    if (HostGroup.HOSTGROUP_REGEX.matcher(hadoopEnvConfig.get("dfs_ha_initial_namenode_active")).matches() && HostGroup.HOSTGROUP_REGEX.matcher(hadoopEnvConfig.get("dfs_ha_initial_namenode_standby")).matches()) {
                        for (HostGroup hostGroupForComponent : hostGroupsForComponent) {
                            Iterator itr = givenHostGroups.iterator();
                            while (itr.hasNext()) {
                                if (!((String)itr.next()).contains(hostGroupForComponent.getName())) continue;
                                itr.remove();
                            }
                        }
                        if (!givenHostGroups.isEmpty()) {
                            throw new IllegalArgumentException("NAMENODE HA host groups mapped incorrectly for properties 'dfs_ha_initial_namenode_active' and 'dfs_ha_initial_namenode_standby'. Expected Host groups are :" + hostGroupsForComponent);
                        }
                    }
                }
                if (component.equals("HIVE_METASTORE") && (hiveEnvConfig = clusterConfigurations.get("hive-env")) != null && !hiveEnvConfig.isEmpty() && hiveEnvConfig.get("hive_database") != null && hiveEnvConfig.get("hive_database").equals("Existing SQL Anywhere Database") && VersionUtils.compareVersions((String)this.stack.getVersion(), (String)"2.3.0.0") < 0 && this.stack.getName().equalsIgnoreCase("HDP")) {
                    throw new InvalidTopologyException("Incorrect configuration: SQL Anywhere db is available only for stack HDP-2.3+ and repo version 2.3.2+!");
                }
                if (!component.equals("OOZIE_SERVER") || (oozieEnvConfig = clusterConfigurations.get("oozie-env")) == null || oozieEnvConfig.isEmpty() || oozieEnvConfig.get("oozie_database") == null || !oozieEnvConfig.get("oozie_database").equals("Existing SQL Anywhere Database") || VersionUtils.compareVersions((String)this.stack.getVersion(), (String)"2.3.0.0") >= 0 || !this.stack.getName().equalsIgnoreCase("HDP")) continue;
                throw new InvalidTopologyException("Incorrect configuration: SQL Anywhere db is available only for stack HDP-2.3+ and repo version 2.3.2+!");
            }
        }
    }

    private Collection<String> verifyComponentInAllHostGroups(String component, AutoDeployInfo autoDeploy) {
        Map<String, HostGroup> hostGroups;
        HashSet<String> cardinalityFailures = new HashSet<String>();
        int actualCount = this.blueprint.getHostGroupsForComponent(component).size();
        if (actualCount != (hostGroups = this.blueprint.getHostGroups()).size()) {
            if (autoDeploy != null && autoDeploy.isEnabled()) {
                for (HostGroup group : hostGroups.values()) {
                    group.addComponent(component);
                }
            } else {
                cardinalityFailures.add(component + "(actual=" + actualCount + ", required=ALL)");
            }
        }
        return cardinalityFailures;
    }

    private Map<String, Collection<DependencyInfo>> validateHostGroup(HostGroup group, String dependencyValidationType) {
        LOGGER.info("Validating hostgroup: {}", (Object)group.getName());
        HashMap<String, Collection<DependencyInfo>> dependenciesIssues = new HashMap<String, Collection<DependencyInfo>>();
        for (String component : new HashSet<String>(group.getComponentNames())) {
            LOGGER.debug("Processing component: {}", (Object)component);
            for (DependencyInfo dependency : this.stack.getDependenciesForComponent(component)) {
                LOGGER.debug("Processing dependency [{}] for component [{}]", (Object)dependency.getName(), (Object)component);
                String conditionalService = this.stack.getConditionalServiceForDependency(dependency);
                if (conditionalService != null && !this.blueprint.getServices().contains(conditionalService)) {
                    LOGGER.debug("Conditional service  [{}] is missing from the blueprint, skipping dependency [{}]", (Object)conditionalService, (Object)dependency.getName());
                    continue;
                }
                ComponentInfo dependencyComponent = this.stack.getComponentInfo(dependency.getComponentName());
                if (dependencyComponent == null) {
                    LOGGER.debug("The component [{}] is not associated with any known services, skipping dependency", (Object)dependency.getComponentName());
                    continue;
                }
                boolean isClientDependency = dependencyComponent.isClient();
                if (isClientDependency && !this.blueprint.getServices().contains(dependency.getServiceName())) {
                    LOGGER.debug("The service [{}] for component [{}] is missing from the blueprint [{}], skipping dependency", new Object[]{dependency.getServiceName(), dependency.getComponentName(), this.blueprint.getName()});
                    continue;
                }
                String dependencyScope = dependency.getScope();
                String dependencyType = dependency.getType();
                String componentName = dependency.getComponentName();
                AutoDeployInfo autoDeployInfo = dependency.getAutoDeploy();
                boolean resolved = false;
                if (dependencyValidationType != null && !dependencyValidationType.equals(dependencyType)) continue;
                if (dependency.hasDependencyConditions()) {
                    boolean conditionsSatisfied = true;
                    for (DependencyConditionInfo dependencyCondition : dependency.getDependencyConditions()) {
                        if (dependencyCondition.isResolved(this.blueprint.getConfiguration().getFullProperties())) continue;
                        conditionsSatisfied = false;
                        break;
                    }
                    if (!conditionsSatisfied) continue;
                }
                if (dependencyScope.equals("cluster")) {
                    Collection<String> missingDependencyInfo = this.verifyComponentCardinalityCount(componentName, new Cardinality("1+"), autoDeployInfo);
                    resolved = missingDependencyInfo.isEmpty();
                    if (dependencyType.equals("exclusive")) {
                        resolved = !resolved;
                    }
                } else if (dependencyScope.equals("host")) {
                    if (dependencyType.equals("exclusive")) {
                        if (!group.getComponentNames().contains(componentName)) {
                            resolved = true;
                        }
                    } else if (group.getComponentNames().contains(componentName) || autoDeployInfo != null && autoDeployInfo.isEnabled()) {
                        resolved = true;
                        group.addComponent(componentName);
                    }
                }
                if (resolved) continue;
                HashSet<DependencyInfo> compDependenciesIssues = (HashSet<DependencyInfo>)dependenciesIssues.get(component);
                if (compDependenciesIssues == null) {
                    compDependenciesIssues = new HashSet<DependencyInfo>();
                    dependenciesIssues.put(component, compDependenciesIssues);
                }
                compDependenciesIssues.add(dependency);
            }
        }
        return dependenciesIssues;
    }

    public Collection<String> verifyComponentCardinalityCount(String component, Cardinality cardinality, AutoDeployInfo autoDeploy) {
        int actualCount;
        Map<String, Map<String, String>> configProperties = this.blueprint.getConfiguration().getProperties();
        HashSet<String> cardinalityFailures = new HashSet<String>();
        if (ClusterTopologyImpl.isNameNodeHAEnabled(configProperties) && component.equals("SECONDARY_NAMENODE")) {
            cardinality = new Cardinality("0");
        }
        if (!cardinality.isValidCount(actualCount = this.blueprint.getHostGroupsForComponent(component).size())) {
            Collection<HostGroup> coLocateHostGroups;
            String coLocateName;
            boolean validated;
            boolean bl = validated = !this.isDependencyManaged(this.stack, component, configProperties);
            if (!validated && autoDeploy != null && autoDeploy.isEnabled() && cardinality.supportsAutoDeploy() && (coLocateName = autoDeploy.getCoLocate()) != null && !coLocateName.isEmpty() && !(coLocateHostGroups = this.blueprint.getHostGroupsForComponent(coLocateName.split("/")[1])).isEmpty()) {
                validated = true;
                HostGroup group = coLocateHostGroups.iterator().next();
                group.addComponent(component);
            }
            if (!validated) {
                cardinalityFailures.add(component + "(actual=" + actualCount + ", required=" + cardinality.getValue() + ")");
            }
        }
        return cardinalityFailures;
    }

    protected boolean isDependencyManaged(Stack stack, String component, Map<String, Map<String, String>> clusterConfig) {
        boolean isManaged = true;
        String externalComponentConfig = stack.getExternalComponentConfig(component);
        if (externalComponentConfig != null) {
            String[] toks = externalComponentConfig.split("/");
            String externalComponentConfigType = toks[0];
            String externalComponentConfigProp = toks[1];
            Map<String, String> properties = clusterConfig.get(externalComponentConfigType);
            if (properties != null && properties.containsKey(externalComponentConfigProp) && properties.get(externalComponentConfigProp).startsWith("Existing")) {
                isManaged = false;
            }
        }
        return isManaged;
    }

    private void generateInvalidTopologyException(Map<String, Map<String, Collection<DependencyInfo>>> dependenciesIssues, Collection<String> cardinalityFailures) throws InvalidTopologyException {
        Object msg = "Cluster Topology validation failed.";
        if (!cardinalityFailures.isEmpty()) {
            msg = (String)msg + "  Invalid service component count: " + cardinalityFailures;
        }
        if (!dependenciesIssues.isEmpty()) {
            msg = (String)msg + " Component dependencies issues: " + dependenciesIssues;
        }
        msg = (String)msg + ".  To disable topology validation and create the blueprint, add the following to the end of the url: '?validate_topology=false'";
        throw new InvalidTopologyException((String)msg);
    }
}

