/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.gson.Gson;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StackAccessException;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.orm.entities.BlueprintConfigEntity;
import id.onyx.obdp.server.orm.entities.BlueprintConfiguration;
import id.onyx.obdp.server.orm.entities.BlueprintEntity;
import id.onyx.obdp.server.orm.entities.BlueprintSettingEntity;
import id.onyx.obdp.server.orm.entities.HostGroupComponentEntity;
import id.onyx.obdp.server.orm.entities.HostGroupConfigEntity;
import id.onyx.obdp.server.orm.entities.HostGroupEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.stack.NoSuchStackException;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.BlueprintValidator;
import id.onyx.obdp.server.topology.BlueprintValidatorImpl;
import id.onyx.obdp.server.topology.Component;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.GPLLicenseNotAcceptedException;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostGroupImpl;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.RepositorySetting;
import id.onyx.obdp.server.topology.SecurityConfiguration;
import id.onyx.obdp.server.topology.Setting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class BlueprintImpl
implements Blueprint {
    private String name;
    private Map<String, HostGroup> hostGroups = new HashMap<String, HostGroup>();
    private Stack stack;
    private Configuration configuration;
    private BlueprintValidator validator;
    private SecurityConfiguration security;
    private Setting setting;
    private List<RepositorySetting> repoSettings;

    public BlueprintImpl(BlueprintEntity entity) throws NoSuchStackException {
        this.name = entity.getBlueprintName();
        if (entity.getSecurityType() != null) {
            this.security = SecurityConfiguration.of(entity.getSecurityType(), entity.getSecurityDescriptorReference(), null);
        }
        this.parseStack(entity.getStack());
        this.processConfiguration(entity.getConfigurations());
        this.parseBlueprintHostGroups(entity);
        this.configuration.setParentConfiguration(this.stack.getConfiguration(this.getServices()));
        this.validator = new BlueprintValidatorImpl(this);
        this.processSetting(entity.getSettings());
        this.processRepoSettings();
    }

    public BlueprintImpl(String name, Collection<HostGroup> groups, Stack stack, Configuration configuration, SecurityConfiguration security) {
        this(name, groups, stack, configuration, security, null);
    }

    public BlueprintImpl(String name, Collection<HostGroup> groups, Stack stack, Configuration configuration, SecurityConfiguration security, Setting setting) {
        this.name = name;
        this.stack = stack;
        this.security = security;
        for (HostGroup hostGroup : groups) {
            this.hostGroups.put(hostGroup.getName(), hostGroup);
        }
        this.configuration = configuration;
        if (configuration.getParentConfiguration() == null) {
            configuration.setParentConfiguration(stack.getConfiguration(this.getServices()));
        }
        this.validator = new BlueprintValidatorImpl(this);
        this.setting = setting;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getStackName() {
        return this.stack.getName();
    }

    public String getStackVersion() {
        return this.stack.getVersion();
    }

    @Override
    public SecurityConfiguration getSecurity() {
        return this.security;
    }

    @Override
    public Map<String, HostGroup> getHostGroups() {
        return this.hostGroups;
    }

    @Override
    public HostGroup getHostGroup(String name) {
        return this.hostGroups.get(name);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Setting getSetting() {
        return this.setting;
    }

    @Override
    public Collection<String> getServices() {
        HashSet<String> services = new HashSet<String>();
        for (HostGroup group : this.getHostGroups().values()) {
            services.addAll(group.getServices());
        }
        return services;
    }

    @Override
    public Collection<ServiceInfo> getServiceInfos() {
        return this.getServices().stream().map(this.stack::getServiceInfo).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getComponents(String service) {
        HashSet<String> components = new HashSet<String>();
        for (HostGroup group : this.getHostGroupsForService(service)) {
            components.addAll(group.getComponents(service));
        }
        return components;
    }

    @Override
    public String getRecoveryEnabled(String serviceName, String componentName) {
        String name;
        if (this.setting == null) {
            return null;
        }
        Set<HashMap<String, String>> settingValue = this.setting.getSettingValue("component_settings");
        for (Map map : settingValue) {
            name = (String)map.get("name");
            if (!StringUtils.equals((String)name, (String)componentName) || StringUtils.isEmpty((String)((String)map.get("recovery_enabled")))) continue;
            return (String)map.get("recovery_enabled");
        }
        settingValue = this.setting.getSettingValue("service_settings");
        for (Map map : settingValue) {
            name = (String)map.get("name");
            if (!StringUtils.equals((String)name, (String)serviceName) || StringUtils.isEmpty((String)((String)map.get("recovery_enabled")))) continue;
            return (String)map.get("recovery_enabled");
        }
        settingValue = this.setting.getSettingValue("recovery_settings");
        for (Map map : settingValue) {
            if (StringUtils.isEmpty((String)((String)map.get("recovery_enabled")))) continue;
            return (String)map.get("recovery_enabled");
        }
        return null;
    }

    @Override
    public String getCredentialStoreEnabled(String serviceName) {
        if (this.setting == null) {
            return null;
        }
        Set<HashMap<String, String>> settingValue = this.setting.getSettingValue("service_settings");
        for (Map map : settingValue) {
            String name = (String)map.get("name");
            if (!StringUtils.equals((String)name, (String)serviceName)) continue;
            if (StringUtils.isEmpty((String)((String)map.get("credential_store_enabled")))) break;
            return (String)map.get("credential_store_enabled");
        }
        return null;
    }

    @Override
    public boolean shouldSkipFailure() {
        if (this.setting == null) {
            return false;
        }
        Set<HashMap<String, String>> settingValue = this.setting.getSettingValue("deployment_settings");
        for (Map map : settingValue) {
            if (!map.containsKey("skip_failure")) continue;
            return ((String)map.get("skip_failure")).equalsIgnoreCase("true");
        }
        return false;
    }

    @Override
    public Stack getStack() {
        return this.stack;
    }

    @Override
    public Collection<HostGroup> getHostGroupsForComponent(String component) {
        HashSet<HostGroup> resultGroups = new HashSet<HostGroup>();
        for (HostGroup group : this.hostGroups.values()) {
            if (!group.getComponentNames().contains(component)) continue;
            resultGroups.add(group);
        }
        return resultGroups;
    }

    @Override
    public Collection<HostGroup> getHostGroupsForService(String service) {
        HashSet<HostGroup> resultGroups = new HashSet<HostGroup>();
        for (HostGroup group : this.hostGroups.values()) {
            if (!group.getServices().contains(service)) continue;
            resultGroups.add(group);
        }
        return resultGroups;
    }

    @Override
    public void validateTopology() throws InvalidTopologyException {
        this.validator.validateTopology();
    }

    @Override
    public BlueprintEntity toEntity() {
        BlueprintEntity entity = new BlueprintEntity();
        entity.setBlueprintName(this.name);
        if (this.security != null) {
            if (this.security.getType() != null) {
                entity.setSecurityType(this.security.getType());
            }
            if (this.security.getDescriptorReference() != null) {
                entity.setSecurityDescriptorReference(this.security.getDescriptorReference());
            }
        }
        StackEntity stackEntity = new StackEntity();
        stackEntity.setStackName(this.stack.getName());
        stackEntity.setStackVersion(this.stack.getVersion());
        entity.setStack(stackEntity);
        this.createHostGroupEntities(entity);
        this.createBlueprintConfigEntities(entity);
        this.createBlueprintSettingEntities(entity);
        return entity;
    }

    @Override
    public void validateRequiredProperties() throws InvalidTopologyException, GPLLicenseNotAcceptedException {
        this.validator.validateRequiredProperties();
    }

    private void parseStack(StackEntity stackEntity) throws NoSuchStackException {
        try {
            this.stack = new Stack(stackEntity.getStackName(), stackEntity.getStackVersion(), OBDPServer.getController());
        }
        catch (StackAccessException e) {
            throw new NoSuchStackException(stackEntity.getStackName(), stackEntity.getStackVersion());
        }
        catch (OBDPException e) {
            throw new RuntimeException("An error occurred parsing the stack information.", e);
        }
    }

    private Map<String, HostGroup> parseBlueprintHostGroups(BlueprintEntity entity) {
        for (HostGroupEntity hostGroupEntity : entity.getHostGroups()) {
            HostGroupImpl hostGroup = new HostGroupImpl(hostGroupEntity, this.getName(), this.stack);
            hostGroup.getConfiguration().setParentConfiguration(this.configuration);
            this.hostGroups.put(hostGroupEntity.getName(), hostGroup);
        }
        return this.hostGroups;
    }

    private void processConfiguration(Collection<BlueprintConfigEntity> configs) {
        this.configuration = new Configuration(this.parseConfigurations(configs), this.parseAttributes(configs), null);
    }

    private void processSetting(Collection<BlueprintSettingEntity> blueprintSetting) {
        if (blueprintSetting != null) {
            this.setting = new Setting(this.parseSetting(blueprintSetting));
        }
    }

    private Map<String, Map<String, String>> parseConfigurations(Collection<BlueprintConfigEntity> configs) {
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
        Gson gson = new Gson();
        for (BlueprintConfiguration blueprintConfiguration : configs) {
            String type = blueprintConfiguration.getType();
            Map typeProperties = (Map)gson.fromJson(blueprintConfiguration.getConfigData(), Map.class);
            properties.put(type, typeProperties);
        }
        return properties;
    }

    private Map<String, Set<HashMap<String, String>>> parseSetting(Collection<BlueprintSettingEntity> blueprintSetting) {
        HashMap<String, Set<HashMap<String, String>>> properties = new HashMap<String, Set<HashMap<String, String>>>();
        Gson gson = new Gson();
        for (BlueprintSettingEntity setting : blueprintSetting) {
            String settingName = setting.getSettingName();
            Set settingProperties = (Set)gson.fromJson(setting.getSettingData(), Set.class);
            properties.put(settingName, settingProperties);
        }
        return properties;
    }

    private Map<String, Map<String, Map<String, String>>> parseAttributes(Collection<BlueprintConfigEntity> configs) {
        HashMap<String, Map<String, Map<String, String>>> mapAttributes = new HashMap<String, Map<String, Map<String, String>>>();
        if (configs != null) {
            Gson gson = new Gson();
            for (BlueprintConfigEntity config : configs) {
                Map typeAttrs = (Map)gson.fromJson(config.getConfigAttributes(), Map.class);
                if (typeAttrs == null || typeAttrs.isEmpty()) continue;
                mapAttributes.put(config.getType(), typeAttrs);
            }
        }
        return mapAttributes;
    }

    private void createHostGroupEntities(BlueprintEntity blueprintEntity) {
        ArrayList<HostGroupEntity> entities = new ArrayList<HostGroupEntity>();
        for (HostGroup group : this.getHostGroups().values()) {
            HostGroupEntity hostGroupEntity = new HostGroupEntity();
            entities.add(hostGroupEntity);
            hostGroupEntity.setName(group.getName());
            hostGroupEntity.setBlueprintEntity(blueprintEntity);
            hostGroupEntity.setBlueprintName(this.getName());
            hostGroupEntity.setCardinality(group.getCardinality());
            this.createHostGroupConfigEntities(hostGroupEntity, group.getConfiguration());
            this.createComponentEntities(hostGroupEntity, group.getComponents());
        }
        blueprintEntity.setHostGroups(entities);
    }

    private void createHostGroupConfigEntities(HostGroupEntity hostGroup, Configuration groupConfiguration) {
        String type;
        Gson jsonSerializer = new Gson();
        HashMap<String, HostGroupConfigEntity> configEntityMap = new HashMap<String, HostGroupConfigEntity>();
        for (Map.Entry<String, Map<String, String>> entry : groupConfiguration.getProperties().entrySet()) {
            type = entry.getKey();
            Map<String, String> properties = entry.getValue();
            HostGroupConfigEntity configEntity = new HostGroupConfigEntity();
            configEntityMap.put(type, configEntity);
            configEntity.setBlueprintName(this.getName());
            configEntity.setHostGroupEntity(hostGroup);
            configEntity.setHostGroupName(hostGroup.getName());
            configEntity.setType(type);
            configEntity.setConfigData(jsonSerializer.toJson(properties));
        }
        for (Map.Entry<String, Map<String, Object>> entry : groupConfiguration.getAttributes().entrySet()) {
            type = entry.getKey();
            Map<String, Object> attributes = entry.getValue();
            HostGroupConfigEntity entity = (HostGroupConfigEntity)configEntityMap.get(type);
            if (entity == null) {
                entity = new HostGroupConfigEntity();
                configEntityMap.put(type, entity);
                entity.setBlueprintName(this.getName());
                entity.setHostGroupEntity(hostGroup);
                entity.setHostGroupName(hostGroup.getName());
                entity.setType(type);
            }
            entity.setConfigAttributes(jsonSerializer.toJson(attributes));
        }
        hostGroup.setConfigurations(configEntityMap.values());
    }

    private void createComponentEntities(HostGroupEntity group, Collection<Component> components) {
        HashSet<HostGroupComponentEntity> componentEntities = new HashSet<HostGroupComponentEntity>();
        group.setComponents(componentEntities);
        for (Component component : components) {
            HostGroupComponentEntity componentEntity = new HostGroupComponentEntity();
            componentEntities.add(componentEntity);
            componentEntity.setName(component.getName());
            componentEntity.setBlueprintName(group.getBlueprintName());
            componentEntity.setHostGroupEntity(group);
            componentEntity.setHostGroupName(group.getName());
            if (component.getProvisionAction() == null) continue;
            componentEntity.setProvisionAction(component.getProvisionAction().toString());
        }
        group.setComponents(componentEntities);
    }

    private void createBlueprintConfigEntities(BlueprintEntity blueprintEntity) {
        String type;
        Gson jsonSerializer = new Gson();
        Configuration config = this.getConfiguration();
        HashMap<String, BlueprintConfigEntity> configEntityMap = new HashMap<String, BlueprintConfigEntity>();
        for (Map.Entry<String, Map<String, String>> entry : config.getProperties().entrySet()) {
            type = entry.getKey();
            Map<String, String> properties = entry.getValue();
            BlueprintConfigEntity configEntity = new BlueprintConfigEntity();
            configEntityMap.put(type, configEntity);
            configEntity.setBlueprintName(this.getName());
            configEntity.setBlueprintEntity(blueprintEntity);
            configEntity.setType(type);
            configEntity.setConfigData(jsonSerializer.toJson(properties));
        }
        for (Map.Entry<String, Map<String, Object>> entry : config.getAttributes().entrySet()) {
            type = entry.getKey();
            Map<String, Object> attributes = entry.getValue();
            BlueprintConfigEntity entity = (BlueprintConfigEntity)configEntityMap.get(type);
            if (entity == null) {
                entity = new BlueprintConfigEntity();
                configEntityMap.put(type, entity);
                entity.setBlueprintName(this.getName());
                entity.setBlueprintEntity(blueprintEntity);
                entity.setType(type);
            }
            entity.setConfigAttributes(jsonSerializer.toJson(attributes));
        }
        blueprintEntity.setConfigurations(configEntityMap.values());
    }

    private void createBlueprintSettingEntities(BlueprintEntity blueprintEntity) {
        Gson jsonSerializer = new Gson();
        Setting blueprintSetting = this.getSetting();
        if (blueprintSetting != null) {
            HashMap<String, BlueprintSettingEntity> settingEntityMap = new HashMap<String, BlueprintSettingEntity>();
            for (Map.Entry<String, Set<HashMap<String, String>>> propEntry : blueprintSetting.getProperties().entrySet()) {
                String settingName = propEntry.getKey();
                Set<HashMap<String, String>> properties = propEntry.getValue();
                BlueprintSettingEntity settingEntity = new BlueprintSettingEntity();
                settingEntityMap.put(settingName, settingEntity);
                settingEntity.setBlueprintName(this.getName());
                settingEntity.setBlueprintEntity(blueprintEntity);
                settingEntity.setSettingName(settingName);
                settingEntity.setSettingData(jsonSerializer.toJson(properties));
            }
            blueprintEntity.setSettings(settingEntityMap.values());
        }
    }

    @Override
    public boolean isValidConfigType(String configType) {
        if ("cluster-env".equals(configType) || "global".equals(configType)) {
            return true;
        }
        return this.getStack().getServicesForConfigType(configType).stream().anyMatch(this.getServices()::contains);
    }

    private void processRepoSettings() {
        this.repoSettings = new ArrayList<RepositorySetting>();
        if (this.setting != null) {
            Set<HashMap<String, String>> settingValue = this.setting.getSettingValue("repository_settings");
            for (Map map : settingValue) {
                RepositorySetting rs = this.parseRepositorySetting(map);
                this.repoSettings.add(rs);
            }
        }
    }

    private RepositorySetting parseRepositorySetting(Map<String, String> setting) {
        RepositorySetting result = new RepositorySetting();
        result.setOperatingSystem(setting.get("operating_system"));
        result.setOverrideStrategy(setting.get("override_strategy"));
        result.setRepoId(setting.get("repo_id"));
        result.setBaseUrl(setting.get("base_url"));
        return result;
    }

    @Override
    public List<RepositorySetting> getRepositorySettings() {
        return this.repoSettings;
    }
}

