/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.BlueprintDAO;
import id.onyx.obdp.server.orm.entities.BlueprintEntity;
import id.onyx.obdp.server.stack.NoSuchStackException;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.BlueprintImpl;
import id.onyx.obdp.server.topology.Component;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.ConfigurationFactory;
import id.onyx.obdp.server.topology.DefaultStackFactory;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostGroupImpl;
import id.onyx.obdp.server.topology.SecurityConfiguration;
import id.onyx.obdp.server.topology.Setting;
import id.onyx.obdp.server.topology.SettingFactory;
import id.onyx.obdp.server.topology.StackFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BlueprintFactory {
    protected static final String BLUEPRINT_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Blueprints", "blueprint_name");
    protected static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Blueprints", "stack_name");
    protected static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("Blueprints", "stack_version");
    protected static final String HOST_GROUP_PROPERTY_ID = "host_groups";
    protected static final String HOST_GROUP_NAME_PROPERTY_ID = "name";
    protected static final String HOST_GROUP_CARDINALITY_PROPERTY_ID = "cardinality";
    protected static final String COMPONENT_PROPERTY_ID = "components";
    protected static final String COMPONENT_NAME_PROPERTY_ID = "name";
    protected static final String COMPONENT_PROVISION_ACTION_PROPERTY_ID = "provision_action";
    protected static final String CONFIGURATION_PROPERTY_ID = "configurations";
    protected static final String PROPERTIES_PROPERTY_ID = "properties";
    protected static final String PROPERTIES_ATTRIBUTES_PROPERTY_ID = "properties_attributes";
    protected static final String SETTINGS_PROPERTY_ID = "settings";
    private static BlueprintDAO blueprintDAO;
    private ConfigurationFactory configFactory = new ConfigurationFactory();
    private final StackFactory stackFactory;

    public BlueprintFactory() {
        this(new DefaultStackFactory());
    }

    protected BlueprintFactory(StackFactory stackFactory) {
        this.stackFactory = stackFactory;
    }

    public Blueprint getBlueprint(String blueprintName) throws NoSuchStackException {
        BlueprintEntity entity = blueprintDAO.findByName(blueprintName);
        return entity == null ? null : new BlueprintImpl(entity);
    }

    public Blueprint createBlueprint(Map<String, Object> properties, SecurityConfiguration securityConfiguration) throws NoSuchStackException {
        String name = String.valueOf(properties.get(BLUEPRINT_NAME_PROPERTY_ID));
        if (name.equals("null") || name.isEmpty()) {
            throw new IllegalArgumentException("Blueprint name must be provided");
        }
        Stack stack = this.createStack(properties);
        Collection<HostGroup> hostGroups = this.processHostGroups(name, stack, properties);
        Configuration configuration = this.configFactory.getConfiguration((Collection)properties.get(CONFIGURATION_PROPERTY_ID));
        Setting setting = SettingFactory.getSetting((Collection)properties.get(SETTINGS_PROPERTY_ID));
        return new BlueprintImpl(name, hostGroups, stack, configuration, securityConfiguration, setting);
    }

    protected Stack createStack(Map<String, Object> properties) throws NoSuchStackException {
        String stackName = String.valueOf(properties.get(STACK_NAME_PROPERTY_ID));
        String stackVersion = String.valueOf(properties.get(STACK_VERSION_PROPERTY_ID));
        try {
            return this.stackFactory.createStack(stackName, stackVersion, OBDPServer.getController());
        }
        catch (ObjectNotFoundException e) {
            throw new NoSuchStackException(stackName, stackVersion);
        }
        catch (OBDPException e) {
            throw new RuntimeException("An error occurred parsing the stack information.", e);
        }
    }

    private Collection<HostGroup> processHostGroups(String bpName, Stack stack, Map<String, Object> properties) {
        HashSet hostGroupProps = (HashSet)properties.get(HOST_GROUP_PROPERTY_ID);
        if (hostGroupProps == null || hostGroupProps.isEmpty()) {
            throw new IllegalArgumentException("At least one host group must be specified in a blueprint");
        }
        ArrayList<HostGroup> hostGroups = new ArrayList<HostGroup>();
        for (HashMap hostGroupProperties : hostGroupProps) {
            String hostGroupName = (String)hostGroupProperties.get("name");
            if (hostGroupName == null || hostGroupName.isEmpty()) {
                throw new IllegalArgumentException("Every host group must include a non-null 'name' property");
            }
            HashSet componentProps = (HashSet)hostGroupProperties.get(COMPONENT_PROPERTY_ID);
            Collection configProps = (Collection)hostGroupProperties.get(CONFIGURATION_PROPERTY_ID);
            Collection<Component> components = this.processHostGroupComponents(stack, hostGroupName, componentProps);
            Configuration configuration = this.configFactory.getConfiguration(configProps);
            String cardinality = String.valueOf(hostGroupProperties.get(HOST_GROUP_CARDINALITY_PROPERTY_ID));
            HostGroupImpl group = new HostGroupImpl(hostGroupName, bpName, stack, components, configuration, cardinality);
            hostGroups.add(group);
        }
        return hostGroups;
    }

    private Collection<Component> processHostGroupComponents(Stack stack, String groupName, HashSet<HashMap<String, String>> componentProps) {
        if (componentProps == null || componentProps.isEmpty()) {
            throw new IllegalArgumentException("Host group '" + groupName + "' must contain at least one component");
        }
        Collection<String> stackComponentNames = this.getAllStackComponents(stack);
        ArrayList<Component> components = new ArrayList<Component>();
        for (HashMap<String, String> componentProperties : componentProps) {
            String componentName = componentProperties.get("name");
            if (componentName == null || componentName.isEmpty()) {
                throw new IllegalArgumentException("Host group '" + groupName + "' contains a component with no 'name' property");
            }
            if (!stackComponentNames.contains(componentName)) {
                throw new IllegalArgumentException("The component '" + componentName + "' in host group '" + groupName + "' is not valid for the specified stack");
            }
            String componentProvisionAction = componentProperties.get(COMPONENT_PROVISION_ACTION_PROPERTY_ID);
            if (componentProvisionAction != null) {
                components.add(new Component(componentName, ProvisionAction.valueOf(componentProvisionAction)));
                continue;
            }
            components.add(new Component(componentName));
        }
        return components;
    }

    private Collection<String> getAllStackComponents(Stack stack) {
        HashSet<String> allComponents = new HashSet<String>();
        for (Collection<String> components : stack.getComponents().values()) {
            allComponents.addAll(components);
        }
        allComponents.add(RootComponent.OBDP_SERVER.name());
        return allComponents;
    }

    @Inject
    public static void init(BlueprintDAO dao) {
        blueprintDAO = dao;
    }
}

