/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.topology;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Striped;
import com.google.inject.Provider;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.stomp.HostLevelParamsHolder;
import id.onyx.obdp.server.controller.ClusterRequest;
import id.onyx.obdp.server.controller.ConfigGroupRequest;
import id.onyx.obdp.server.controller.ConfigurationRequest;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.ServiceComponentRequest;
import id.onyx.obdp.server.controller.ServiceRequest;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.ConfigGroupResourceProvider;
import id.onyx.obdp.server.controller.internal.HostComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.HostResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.internal.ServiceResourceProvider;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.controller.internal.VersionDefinitionResourceProvider;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigFactory;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.PersistedState;
import id.onyx.obdp.server.utils.RetryHelper;
import id.onyx.obdp.spi.RepositoryType;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmbariContext {
    @Inject
    private PersistedState persistedState;
    @Inject
    ConfigFactory configFactory;
    @Inject
    RepositoryVersionDAO repositoryVersionDAO;
    @Inject
    private Provider<ConfigHelper> configHelper;
    @Inject
    HostLevelParamsHolder hostLevelParamsHolder;
    private static OBDPManagementController controller;
    private static ClusterController clusterController;
    private static final AtomicLong nextTaskId;
    private static HostRoleCommandFactory hostRoleCommandFactory;
    private static HostResourceProvider hostResourceProvider;
    private static ServiceResourceProvider serviceResourceProvider;
    private static ComponentResourceProvider componentResourceProvider;
    private static HostComponentResourceProvider hostComponentResourceProvider;
    private static VersionDefinitionResourceProvider versionDefinitionResourceProvider;
    private static final Logger LOG;
    private Striped<Lock> configGroupCreateLock = Striped.lazyWeakLock((int)1);

    public boolean isClusterKerberosEnabled(long clusterId) {
        Cluster cluster;
        try {
            cluster = AmbariContext.getController().getClusters().getClusterById(clusterId);
        }
        catch (OBDPException e) {
            throw new RuntimeException("Parent Cluster resource doesn't exist.  clusterId= " + clusterId);
        }
        return cluster.getSecurityType() == SecurityType.KERBEROS;
    }

    public HostRoleCommand createAmbariTask(long requestId, long stageId, String component, String host, TaskType type, boolean skipFailure) {
        HostRoleCommand task = hostRoleCommandFactory.create(host, Role.valueOf(component), null, RoleCommand.valueOf(type.name()), false, skipFailure);
        task.setStatus(HostRoleStatus.PENDING);
        task.setCommandDetail(String.format("Logical Task: %s component %s on host %s", type.name(), component, host));
        task.setTaskId(nextTaskId.getAndIncrement());
        task.setRequestId(requestId);
        task.setStageId(stageId);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostRoleCommand createAmbariTask(long taskId, long requestId, long stageId, String component, String host, TaskType type, boolean skipFailure) {
        AtomicLong atomicLong = nextTaskId;
        synchronized (atomicLong) {
            if (nextTaskId.get() <= taskId) {
                nextTaskId.set(taskId + 1L);
            }
        }
        HostRoleCommand task = hostRoleCommandFactory.create(host, Role.valueOf(component), null, RoleCommand.valueOf(type.name()), false, skipFailure);
        task.setStatus(HostRoleStatus.PENDING);
        task.setCommandDetail(String.format("Logical Task: %s component %s on host %s", type.name(), component, host));
        task.setTaskId(taskId);
        task.setRequestId(requestId);
        task.setStageId(stageId);
        return task;
    }

    public HostRoleCommand getPhysicalTask(long id) {
        return AmbariContext.getController().getActionManager().getTaskById(id);
    }

    public Collection<HostRoleCommand> getPhysicalTasks(Collection<Long> ids) {
        return AmbariContext.getController().getActionManager().getTasks(ids);
    }

    public void createAmbariResources(ClusterTopology topology, String clusterName, SecurityType securityType, String repoVersionString, Long repoVersionId) {
        Stack stack = topology.getBlueprint().getStack();
        StackId stackId = new StackId(stack.getName(), stack.getVersion());
        RepositoryVersionEntity repoVersion = null;
        if (StringUtils.isEmpty((String)repoVersionString) && null == repoVersionId) {
            List<RepositoryVersionEntity> stackRepoVersions = this.repositoryVersionDAO.findByStack(stackId);
            if (stackRepoVersions.isEmpty()) {
                VersionDefinitionResourceProvider vdfProvider = this.getVersionDefinitionResourceProvider();
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("VersionDefinition/available", stackId.toString());
                RequestImpl request = new RequestImpl(Collections.emptySet(), Collections.singleton(properties), Collections.emptyMap(), null);
                Long defaultRepoVersionId = null;
                try {
                    RequestStatus requestStatus = vdfProvider.createResources(request);
                    if (!requestStatus.getAssociatedResources().isEmpty()) {
                        Resource resource = requestStatus.getAssociatedResources().iterator().next();
                        defaultRepoVersionId = (Long)resource.getPropertyValue("VersionDefinition/id");
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Failed to create a default repository version definition for stack %s. This typically is a result of not loading the stack correctly or being able to load information about released versions.  Create a repository version  and try again.", stackId), e);
                }
                repoVersion = (RepositoryVersionEntity)this.repositoryVersionDAO.findByPK(defaultRepoVersionId);
                if (null == repoVersion) {
                    throw new IllegalArgumentException(String.format("Failed to load the default repository version definition for stack %s. Check for a valid repository version and try again.", stackId));
                }
            } else {
                if (stackRepoVersions.size() > 1) {
                    Function<RepositoryVersionEntity, String> function = new Function<RepositoryVersionEntity, String>(){

                        public String apply(RepositoryVersionEntity input) {
                            return input.getVersion();
                        }
                    };
                    Collection versions = Collections2.transform(stackRepoVersions, (Function)function);
                    throw new IllegalArgumentException(String.format("Several repositories were found for %s:  %s.  Specify the version with '%s'", stackId, StringUtils.join((Collection)versions, (String)", "), "repository_version"));
                }
                repoVersion = stackRepoVersions.get(0);
                LOG.warn("Cluster is being provisioned using the single matching repository version {}", (Object)repoVersion.getVersion());
            }
        } else {
            if (null != repoVersionId) {
                repoVersion = (RepositoryVersionEntity)this.repositoryVersionDAO.findByPK(repoVersionId);
                if (null == repoVersion) {
                    throw new IllegalArgumentException(String.format("Could not identify repository version with repository version id %s for installing services. Specify a valid repository version id with '%s'", repoVersionId, "repository_version_id"));
                }
            } else {
                repoVersion = this.repositoryVersionDAO.findByStackAndVersion(stackId, repoVersionString);
                if (null == repoVersion) {
                    throw new IllegalArgumentException(String.format("Could not identify repository version with stack %s and version %s for installing services. Specify a valid version with '%s'", stackId, repoVersionString, "repository_version"));
                }
            }
            if (!Objects.equals(repoVersion.getStackId(), stackId)) {
                String repoVersionPair = repoVersionId != null ? String.format("'%s' = %d", "repository_version_id", repoVersionId) : String.format("'%s' = '%s'", "repository_version", repoVersionString);
                String msg = String.format("The stack specified in the blueprint (%s) and the repository version (%s for %s) should match", stackId, repoVersion.getStackId(), repoVersionPair);
                throw new IllegalArgumentException(msg);
            }
        }
        if (repoVersion.getType() != RepositoryType.STANDARD) {
            throw new IllegalArgumentException(String.format("Unable to create a cluster using the following repository since it is not a STANDARD type: %s", repoVersion));
        }
        this.createAmbariClusterResource(clusterName, stack.getName(), stack.getVersion(), securityType);
        this.createAmbariServiceAndComponentResources(topology, clusterName, stackId, repoVersion.getId());
    }

    public void createAmbariClusterResource(String clusterName, String stackName, String stackVersion, SecurityType securityType) {
        String stackInfo = String.format("%s-%s", stackName, stackVersion);
        final ClusterRequest clusterRequest = new ClusterRequest(null, clusterName, null, securityType, stackInfo, null);
        try {
            RetryHelper.executeWithRetry(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AmbariContext.getController().createCluster(clusterRequest);
                    return null;
                }
            });
        }
        catch (OBDPException e) {
            LOG.error("Failed to create Cluster resource: ", (Throwable)e);
            if (e.getCause() instanceof DuplicateResourceException) {
                throw new IllegalArgumentException(e);
            }
            throw new RuntimeException("Failed to create Cluster resource: " + e, e);
        }
    }

    public void createAmbariServiceAndComponentResources(ClusterTopology topology, String clusterName, StackId stackId, Long repositoryVersionId) {
        Collection<String> services = topology.getBlueprint().getServices();
        try {
            Cluster cluster = AmbariContext.getController().getClusters().getCluster(clusterName);
            services.removeAll(cluster.getServices().keySet());
        }
        catch (OBDPException e) {
            throw new RuntimeException("Failed to persist service and component resources: " + e, e);
        }
        HashSet<ServiceRequest> serviceRequests = new HashSet<ServiceRequest>();
        HashSet<ServiceComponentRequest> componentRequests = new HashSet<ServiceComponentRequest>();
        for (String service : services) {
            String credentialStoreEnabled = topology.getBlueprint().getCredentialStoreEnabled(service);
            serviceRequests.add(new ServiceRequest(clusterName, service, repositoryVersionId, null, credentialStoreEnabled));
            for (String component : topology.getBlueprint().getComponents(service)) {
                String recoveryEnabled = topology.getBlueprint().getRecoveryEnabled(service, component);
                componentRequests.add(new ServiceComponentRequest(clusterName, service, component, null, recoveryEnabled));
            }
        }
        try {
            this.getServiceResourceProvider().createServices(serviceRequests);
            this.getComponentResourceProvider().createComponents(componentRequests);
        }
        catch (OBDPException | AuthorizationException e) {
            throw new RuntimeException("Failed to persist service and component resources: " + (Exception)e, e);
        }
        HashMap<String, String> installProps = new HashMap<String, String>();
        installProps.put(ServiceResourceProvider.SERVICE_SERVICE_STATE_PROPERTY_ID, "INSTALLED");
        installProps.put(ServiceResourceProvider.SERVICE_CLUSTER_NAME_PROPERTY_ID, clusterName);
        HashMap<String, String> startProps = new HashMap<String, String>();
        startProps.put(ServiceResourceProvider.SERVICE_SERVICE_STATE_PROPERTY_ID, "STARTED");
        startProps.put(ServiceResourceProvider.SERVICE_CLUSTER_NAME_PROPERTY_ID, clusterName);
        EqualsPredicate predicate = new EqualsPredicate(ServiceResourceProvider.SERVICE_CLUSTER_NAME_PROPERTY_ID, clusterName);
        try {
            this.getServiceResourceProvider().updateResources(new RequestImpl(null, Collections.singleton(installProps), null, null), predicate);
            this.getServiceResourceProvider().updateResources(new RequestImpl(null, Collections.singleton(startProps), null, null), predicate);
        }
        catch (Exception e) {
            LOG.error("Unable to update state of services during cluster provision: " + e, (Throwable)e);
        }
    }

    public void createAmbariHostResources(long clusterId, String hostName, Map<String, Collection<String>> components) {
        Host host;
        try {
            host = AmbariContext.getController().getClusters().getHost(hostName);
        }
        catch (OBDPException e) {
            throw new RuntimeException(String.format("Unable to obtain host instance '%s' when persisting host resources", hostName));
        }
        Cluster cluster = null;
        try {
            cluster = AmbariContext.getController().getClusters().getClusterById(clusterId);
        }
        catch (OBDPException e) {
            LOG.error("Cannot get cluster for clusterId = " + clusterId, (Throwable)e);
            throw new RuntimeException(e);
        }
        String clusterName = cluster.getClusterName();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Hosts/cluster_name", clusterName);
        properties.put("Hosts/host_name", hostName);
        properties.put("Hosts/rack_info", host.getRackInfo());
        try {
            this.getHostResourceProvider().createHosts(new RequestImpl(null, Collections.singleton(properties), null, null));
        }
        catch (OBDPException | AuthorizationException e) {
            LOG.error("Unable to create host component resource for host {}", (Object)hostName, (Object)e);
            throw new RuntimeException(String.format("Unable to create host resource for host '%s': %s", hostName, e.toString()), e);
        }
        final HashSet<ServiceComponentHostRequest> requests = new HashSet<ServiceComponentHostRequest>();
        for (Map.Entry<String, Collection<String>> entry : components.entrySet()) {
            String service = entry.getKey();
            for (String component : entry.getValue()) {
                try {
                    if (cluster.getService(service) == null || component.equals(RootComponent.OBDP_SERVER.name())) continue;
                    requests.add(new ServiceComponentHostRequest(clusterName, service, component, hostName, null));
                }
                catch (OBDPException se) {
                    LOG.warn("Service already deleted from cluster: {}", (Object)service);
                }
            }
        }
        try {
            RetryHelper.executeWithRetry(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AmbariContext.getController().createHostComponents(requests, true);
                    return null;
                }
            });
            this.hostLevelParamsHolder.updateData(this.hostLevelParamsHolder.getCurrentData(host.getHostId()));
        }
        catch (OBDPException e) {
            LOG.error("Unable to create host component resource for host {}", (Object)hostName, (Object)e);
            throw new RuntimeException(String.format("Unable to create host component resource for host '%s': %s", hostName, e.toString()), e);
        }
    }

    public Long getNextRequestId() {
        return AmbariContext.getController().getActionManager().getNextRequestId();
    }

    public static synchronized OBDPManagementController getController() {
        if (controller == null) {
            controller = OBDPServer.getController();
        }
        return controller;
    }

    public static synchronized ClusterController getClusterController() {
        if (clusterController == null) {
            clusterController = ClusterControllerHelper.getClusterController();
        }
        return clusterController;
    }

    public static void init(HostRoleCommandFactory factory) {
        hostRoleCommandFactory = factory;
    }

    public void registerHostWithConfigGroup(final String hostName, final ClusterTopology topology, String groupName) {
        final String qualifiedGroupName = this.getConfigurationGroupName(topology.getBlueprint().getName(), groupName);
        Lock configGroupLock = (Lock)this.configGroupCreateLock.get((Object)qualifiedGroupName);
        try {
            configGroupLock.lock();
            boolean hostAdded = RetryHelper.executeWithRetry(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AmbariContext.this.addHostToExistingConfigGroups(hostName, topology, qualifiedGroupName);
                }
            });
            if (!hostAdded) {
                this.createConfigGroupsAndRegisterHost(topology, groupName);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to register config group for host: ", (Throwable)e);
            throw new RuntimeException("Unable to register config group for host: " + hostName);
        }
        finally {
            configGroupLock.unlock();
        }
    }

    public RequestStatusResponse installHost(String hostName, String clusterName, Collection<String> skipInstallForComponents, Collection<String> dontSkipInstallForComponents, boolean skipFailure) {
        try {
            return this.getHostResourceProvider().install(clusterName, hostName, skipInstallForComponents, dontSkipInstallForComponents, skipFailure, true);
        }
        catch (Exception e) {
            LOG.error("INSTALL Host request submission failed:", (Throwable)e);
            throw new RuntimeException("INSTALL Host request submission failed: " + e, e);
        }
    }

    public RequestStatusResponse startHost(String hostName, String clusterName, Collection<String> installOnlyComponents, boolean skipFailure) {
        try {
            return this.getHostComponentResourceProvider().start(clusterName, hostName, installOnlyComponents, skipFailure, true);
        }
        catch (Exception e) {
            LOG.error("START Host request submission failed:", (Throwable)e);
            throw new RuntimeException("START Host request submission failed: " + e, e);
        }
    }

    public void persistInstallStateForUI(String clusterName, String stackName, String stackVersion) {
        String stackInfo = String.format("%s-%s", stackName, stackVersion);
        final ClusterRequest clusterRequest = new ClusterRequest(null, clusterName, "INSTALLED", null, stackInfo, null);
        try {
            RetryHelper.executeWithRetry(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AmbariContext.getController().updateClusters(Collections.singleton(clusterRequest), null);
                    return null;
                }
            });
        }
        catch (OBDPException e) {
            LOG.error("Unable to set install state for UI", (Throwable)e);
        }
    }

    public List<ConfigurationRequest> createConfigurationRequests(Map<String, Object> clusterProperties) {
        return AbstractResourceProvider.getConfigurationRequests("Clusters", clusterProperties);
    }

    public void setConfigurationOnCluster(final ClusterRequest clusterRequest) {
        try {
            RetryHelper.executeWithRetry(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AmbariContext.getController().updateClusters(Collections.singleton(clusterRequest), null, false, false);
                    return null;
                }
            });
        }
        catch (OBDPException e) {
            LOG.error("Failed to set configurations on cluster: ", (Throwable)e);
            throw new RuntimeException("Failed to set configurations on cluster: " + e, e);
        }
    }

    public void notifyAgentsAboutConfigsChanges(String clusterName) {
        try {
            ((ConfigHelper)this.configHelper.get()).updateAgentConfigs(Collections.singleton(clusterName));
        }
        catch (OBDPException e) {
            LOG.error("Failed to set send agent updates: ", (Throwable)e);
            throw new RuntimeException("Failed to set send agent updates: " + e, e);
        }
    }

    public void waitForConfigurationResolution(String clusterName, Set<String> updatedConfigTypes) throws OBDPException {
        Cluster cluster = AmbariContext.getController().getClusters().getCluster(clusterName);
        boolean shouldWaitForResolution = true;
        while (shouldWaitForResolution) {
            int numOfRequestsStillRequiringResolution = 0;
            for (String actualConfigType : updatedConfigTypes) {
                DesiredConfig actualConfig = cluster.getDesiredConfigs().get(actualConfigType);
                if (actualConfig == null || actualConfigType.equals("core-site")) continue;
                if (!actualConfig.getTag().equals("TOPOLOGY_RESOLVED")) {
                    LOG.info("Config type " + actualConfigType + " not resolved yet, Blueprint deployment will wait until configuration update is completed");
                    ++numOfRequestsStillRequiringResolution;
                    continue;
                }
                LOG.info("Config type " + actualConfigType + " is resolved in the cluster config.");
            }
            if (numOfRequestsStillRequiringResolution == 0) {
                LOG.info("All required configuration types are in the TOPOLOGY_RESOLVED state.  Blueprint deployment can now continue.");
                shouldWaitForResolution = false;
                continue;
            }
            LOG.info("Waiting for " + numOfRequestsStillRequiringResolution + " configuration types to be resolved before Blueprint deployment can continue");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.warn("sleep interrupted");
            }
        }
    }

    public boolean isTopologyResolved(long clusterId) {
        boolean isTopologyResolved = false;
        try {
            Cluster cluster = AmbariContext.getController().getClusters().getClusterById(clusterId);
            Map<String, Set<DesiredConfig>> allDesiredConfigsByType = cluster.getAllDesiredConfigVersions();
            for (String configType : allDesiredConfigsByType.keySet()) {
                Set<DesiredConfig> desiredConfigVersions = allDesiredConfigsByType.get(configType);
                TreeSet<DesiredConfig> desiredConfigsOrderedByVersion = new TreeSet<DesiredConfig>(new Comparator<DesiredConfig>(){

                    @Override
                    public int compare(DesiredConfig o1, DesiredConfig o2) {
                        if (o1.getVersion() < o2.getVersion()) {
                            return -1;
                        }
                        if (o1.getVersion() > o2.getVersion()) {
                            return 1;
                        }
                        return 0;
                    }
                });
                desiredConfigsOrderedByVersion.addAll(desiredConfigVersions);
                int tagMatchState = 0;
                for (DesiredConfig config : desiredConfigsOrderedByVersion) {
                    if (config.getTag().equals("INITIAL") && tagMatchState == 0) {
                        tagMatchState = 1;
                        continue;
                    }
                    if (!config.getTag().equals("TOPOLOGY_RESOLVED") || tagMatchState != 1) continue;
                    tagMatchState = 2;
                    break;
                }
                if (tagMatchState != 2) continue;
                isTopologyResolved = true;
                break;
            }
        }
        catch (ClusterNotFoundException e) {
            LOG.info("Attempted to determine if configuration is topology resolved for a non-existent cluster: {}", (Object)clusterId);
        }
        catch (OBDPException e) {
            throw new RuntimeException("Unable to determine if cluster config is topology resolved due to unknown error: " + e, e);
        }
        return isTopologyResolved;
    }

    public PersistedState getPersistedTopologyState() {
        return this.persistedState;
    }

    public boolean isHostRegisteredWithCluster(long clusterId, String host) {
        boolean found = false;
        try {
            Collection<Host> hosts = AmbariContext.getController().getClusters().getClusterById(clusterId).getHosts();
            for (Host h : hosts) {
                if (!h.getHostName().equals(host)) continue;
                found = true;
                break;
            }
        }
        catch (OBDPException e) {
            throw new RuntimeException(String.format("Unable to get hosts for cluster ID = %s: %s", new Object[]{clusterId, e}), e);
        }
        return found;
    }

    public long getClusterId(String clusterName) throws OBDPException {
        return AmbariContext.getController().getClusters().getCluster(clusterName).getClusterId();
    }

    public String getClusterName(long clusterId) throws OBDPException {
        return AmbariContext.getController().getClusters().getClusterById(clusterId).getClusterName();
    }

    private boolean addHostToExistingConfigGroups(String hostName, ClusterTopology topology, String configGroupName) {
        Cluster cluster;
        Clusters clusters;
        boolean addedHost = false;
        try {
            clusters = AmbariContext.getController().getClusters();
            cluster = clusters.getClusterById(topology.getClusterId());
        }
        catch (OBDPException e) {
            throw new RuntimeException(String.format("Attempt to add hosts to a non-existent cluster: '%s'", topology.getClusterId()));
        }
        Map<Long, ConfigGroup> configGroups = cluster.getConfigGroups();
        for (ConfigGroup group : configGroups.values()) {
            if (!group.getName().equals(configGroupName)) continue;
            try {
                Host host = clusters.getHost(hostName);
                addedHost = true;
                if (group.getHosts().containsKey(host.getHostId())) continue;
                group.addHost(host);
            }
            catch (OBDPException e) {
                throw new RuntimeException(String.format("An error occurred while registering host '%s' with config group '%s' ", hostName, group.getName()), e);
            }
        }
        return addedHost;
    }

    private void createConfigGroupsAndRegisterHost(ClusterTopology topology, String groupName) throws OBDPException {
        HashMap<String, HashMap<String, Config>> groupConfigs = new HashMap<String, HashMap<String, Config>>();
        Stack stack = topology.getBlueprint().getStack();
        Configuration topologyHostGroupConfig = topology.getHostGroupInfo().get(groupName).getConfiguration();
        Map<String, Map<String, String>> userProvidedGroupProperties = topologyHostGroupConfig.getFullProperties(1);
        for (Map.Entry<String, Map<String, String>> entry : userProvidedGroupProperties.entrySet()) {
            String type = entry.getKey();
            List<String> services = stack.getServicesForConfigType(type);
            String service = services.stream().filter(each -> topology.getBlueprint().getServices().contains(each)).findFirst().orElseThrow(() -> new IllegalArgumentException("Specified configuration type is not associated with any service: " + type));
            Config config = this.configFactory.createReadOnly(type, groupName, entry.getValue(), null);
            HashMap<String, Config> serviceConfigs = (HashMap<String, Config>)groupConfigs.get(service);
            if (serviceConfigs == null) {
                serviceConfigs = new HashMap<String, Config>();
                groupConfigs.put(service, serviceConfigs);
            }
            serviceConfigs.put(type, config);
        }
        String bpName = topology.getBlueprint().getName();
        for (Map.Entry entry : groupConfigs.entrySet()) {
            String service = (String)entry.getKey();
            Map serviceConfigs = (Map)entry.getValue();
            String absoluteGroupName = this.getConfigurationGroupName(bpName, groupName);
            Collection<String> groupHosts = topology.getHostGroupInfo().get(groupName).getHostNames();
            String clusterName = null;
            try {
                clusterName = this.getClusterName(topology.getClusterId());
            }
            catch (OBDPException e) {
                LOG.error("Cannot get cluster name for clusterId = " + topology.getClusterId(), (Throwable)e);
                throw new RuntimeException(e);
            }
            final Map<String, Host> clusterHosts = AmbariContext.getController().getClusters().getHostsForCluster(clusterName);
            Iterable filteredGroupHosts = Iterables.filter(groupHosts, (Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String groupHost) {
                    return clusterHosts.containsKey(groupHost);
                }
            });
            ConfigGroupRequest request = new ConfigGroupRequest(null, clusterName, absoluteGroupName, service, service, "Host Group Configuration", Sets.newHashSet((Iterable)filteredGroupHosts), serviceConfigs);
            ConfigGroupResourceProvider configGroupProvider = (ConfigGroupResourceProvider)AmbariContext.getClusterController().ensureResourceProvider(Resource.Type.ConfigGroup);
            try {
                configGroupProvider.createResources(Collections.singleton(request));
            }
            catch (Exception e) {
                LOG.error("Failed to create new configuration group: " + e);
                throw new RuntimeException("Failed to create new configuration group: " + e, e);
            }
        }
    }

    private String getConfigurationGroupName(String bpName, String hostGroupName) {
        return String.format("%s:%s", bpName, hostGroupName);
    }

    public ConfigHelper getConfigHelper() {
        return (ConfigHelper)this.configHelper.get();
    }

    private synchronized HostResourceProvider getHostResourceProvider() {
        if (hostResourceProvider == null) {
            hostResourceProvider = (HostResourceProvider)ClusterControllerHelper.getClusterController().ensureResourceProvider(Resource.Type.Host);
        }
        return hostResourceProvider;
    }

    private synchronized HostComponentResourceProvider getHostComponentResourceProvider() {
        if (hostComponentResourceProvider == null) {
            hostComponentResourceProvider = (HostComponentResourceProvider)ClusterControllerHelper.getClusterController().ensureResourceProvider(Resource.Type.HostComponent);
        }
        return hostComponentResourceProvider;
    }

    private synchronized ServiceResourceProvider getServiceResourceProvider() {
        if (serviceResourceProvider == null) {
            serviceResourceProvider = (ServiceResourceProvider)ClusterControllerHelper.getClusterController().ensureResourceProvider(Resource.Type.Service);
        }
        return serviceResourceProvider;
    }

    private synchronized ComponentResourceProvider getComponentResourceProvider() {
        if (componentResourceProvider == null) {
            componentResourceProvider = (ComponentResourceProvider)ClusterControllerHelper.getClusterController().ensureResourceProvider(Resource.Type.Component);
        }
        return componentResourceProvider;
    }

    private synchronized VersionDefinitionResourceProvider getVersionDefinitionResourceProvider() {
        if (versionDefinitionResourceProvider == null) {
            versionDefinitionResourceProvider = (VersionDefinitionResourceProvider)ClusterControllerHelper.getClusterController().ensureResourceProvider(Resource.Type.VersionDefinition);
        }
        return versionDefinitionResourceProvider;
    }

    static {
        nextTaskId = new AtomicLong(10000L);
        LOG = LoggerFactory.getLogger(AmbariContext.class);
    }

    public static enum TaskType {
        INSTALL,
        START;

    }
}

