/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.theme;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.controller.ApiModel;
import id.onyx.obdp.server.state.theme.Layout;
import id.onyx.obdp.server.state.theme.Placement;
import id.onyx.obdp.server.state.theme.WidgetEntry;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ThemeConfiguration
implements ApiModel {
    @JsonProperty(value="placement")
    private Placement placement;
    @JsonProperty(value="widgets")
    private List<WidgetEntry> widgets;
    @JsonProperty(value="layouts")
    private List<Layout> layouts;

    @ApiModelProperty(name="placement")
    public Placement getPlacement() {
        return this.placement;
    }

    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    @ApiModelProperty(name="widgets")
    public List<WidgetEntry> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(List<WidgetEntry> widgets) {
        this.widgets = widgets;
    }

    @ApiModelProperty(name="layouts")
    public List<Layout> getLayouts() {
        return this.layouts;
    }

    public void setLayouts(List<Layout> layouts) {
        this.layouts = layouts;
    }

    public void mergeWithParent(ThemeConfiguration parent) {
        if (parent == null) {
            return;
        }
        if (this.placement == null) {
            this.placement = parent.placement;
        } else {
            this.placement.mergeWithParent(parent.placement);
        }
        if (this.widgets == null) {
            this.widgets = parent.widgets;
        } else if (parent.widgets != null) {
            this.widgets = this.mergeWidgets(parent.widgets, this.widgets);
        }
        if (this.layouts == null) {
            this.layouts = parent.layouts;
        } else if (parent.layouts != null) {
            this.layouts = this.mergeLayouts(parent.layouts, this.layouts);
        }
    }

    private List<Layout> mergeLayouts(List<Layout> parentLayouts, List<Layout> childLayouts) {
        LinkedHashMap<String, Layout> mergedLayouts = new LinkedHashMap<String, Layout>();
        for (Layout parentLayout : parentLayouts) {
            mergedLayouts.put(parentLayout.getName(), parentLayout);
        }
        for (Layout childLayout : childLayouts) {
            if (childLayout.getName() == null) continue;
            if (childLayout.getTabs() == null) {
                mergedLayouts.remove(childLayout.getName());
                continue;
            }
            Layout parentLayout = (Layout)mergedLayouts.get(childLayout.getName());
            childLayout.mergeWithParent(parentLayout);
            mergedLayouts.put(childLayout.getName(), childLayout);
        }
        return new ArrayList<Layout>(mergedLayouts.values());
    }

    private List<WidgetEntry> mergeWidgets(List<WidgetEntry> parentWidgets, List<WidgetEntry> childWidgets) {
        LinkedHashMap<String, WidgetEntry> mergedWidgets = new LinkedHashMap<String, WidgetEntry>();
        for (WidgetEntry widgetEntry : parentWidgets) {
            mergedWidgets.put(widgetEntry.getConfig(), widgetEntry);
        }
        for (WidgetEntry widgetEntry : childWidgets) {
            if (widgetEntry.getConfig() == null) continue;
            if (widgetEntry.getWidget() == null) {
                mergedWidgets.remove(widgetEntry.getConfig());
                continue;
            }
            mergedWidgets.put(widgetEntry.getConfig(), widgetEntry);
        }
        return new ArrayList<WidgetEntry>(mergedWidgets.values());
    }
}

