/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.theme;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.state.theme.Section;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TabLayout {
    @JsonProperty(value="tab-rows")
    private String tabRows;
    @JsonProperty(value="sections")
    private List<Section> sections;
    @JsonProperty(value="tab-columns")
    private String tabColumns;

    @ApiModelProperty(name="tab-rows")
    public String getTabRows() {
        return this.tabRows;
    }

    public void setTabRows(String tabRows) {
        this.tabRows = tabRows;
    }

    @ApiModelProperty(name="sections")
    public List<Section> getSections() {
        return this.sections;
    }

    public void setSections(List<Section> sections) {
        this.sections = sections;
    }

    @ApiModelProperty(name="tab-columns")
    public String getTabColumns() {
        return this.tabColumns;
    }

    public void setTabColumns(String tabColumns) {
        this.tabColumns = tabColumns;
    }

    public void mergeWithParent(TabLayout parent) {
        if (this.tabColumns == null) {
            this.tabColumns = parent.tabColumns;
        }
        if (this.tabRows == null) {
            this.tabRows = parent.tabRows;
        }
        if (this.sections == null) {
            this.sections = parent.sections;
        } else if (parent.sections != null) {
            this.sections = this.mergedSections(parent.sections, this.sections);
        }
    }

    private List<Section> mergedSections(List<Section> parentSections, List<Section> childSections) {
        HashMap<String, Section> mergedSections = new HashMap<String, Section>();
        for (Section parentSection : parentSections) {
            mergedSections.put(parentSection.getName(), parentSection);
        }
        for (Section childSection : childSections) {
            if (childSection.getName() == null) continue;
            if (childSection.isRemoved()) {
                mergedSections.remove(childSection.getName());
                continue;
            }
            if (mergedSections.containsKey(childSection.getName())) {
                Section parentSection = (Section)mergedSections.get(childSection.getName());
                childSection.mergeWithParent(parentSection);
            } else {
                childSection.mergeWithParent(childSection);
            }
            mergedSections.put(childSection.getName(), childSection);
        }
        return new ArrayList<Section>(mergedSections.values());
    }
}

