/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.theme;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.state.theme.ConfigPlacement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Placement {
    @JsonProperty(value="configs")
    private List<ConfigPlacement> configs;
    @JsonProperty(value="configuration-layout")
    private String configurationLayout;

    public List<ConfigPlacement> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<ConfigPlacement> configs) {
        this.configs = configs;
    }

    public String getConfigurationLayout() {
        return this.configurationLayout;
    }

    public void setConfigurationLayout(String configurationLayout) {
        this.configurationLayout = configurationLayout;
    }

    public void mergeWithParent(Placement parent) {
        if (this.configurationLayout == null) {
            this.configurationLayout = parent.configurationLayout;
        }
        if (this.configs == null) {
            this.configs = parent.configs;
        } else if (parent.configs != null) {
            this.configs = this.mergeConfigs(parent.configs, this.configs);
        }
    }

    private List<ConfigPlacement> mergeConfigs(List<ConfigPlacement> parentConfigs, List<ConfigPlacement> childConfigs) {
        LinkedHashMap<String, ConfigPlacement> mergedConfigPlacements = new LinkedHashMap<String, ConfigPlacement>();
        for (ConfigPlacement parentConfigPlacement : parentConfigs) {
            mergedConfigPlacements.put(parentConfigPlacement.getConfig(), parentConfigPlacement);
        }
        for (ConfigPlacement childConfigPlacement : childConfigs) {
            if (childConfigPlacement.getConfig() == null) continue;
            if (childConfigPlacement.isRemoved()) {
                mergedConfigPlacements.remove(childConfigPlacement.getConfig());
                continue;
            }
            ConfigPlacement parentConfigPlacement = (ConfigPlacement)mergedConfigPlacements.get(childConfigPlacement.getConfig());
            childConfigPlacement.mergeWithParent(parentConfigPlacement);
            mergedConfigPlacements.put(childConfigPlacement.getConfig(), childConfigPlacement);
        }
        return new ArrayList<ConfigPlacement>(mergedConfigPlacements.values());
    }
}

