/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.theme;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.state.theme.Tab;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Layout {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="tabs")
    private List<Tab> tabs;

    @ApiModelProperty(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(name="tabs")
    public List<Tab> getTabs() {
        return this.tabs;
    }

    public void setTabs(List<Tab> tabs) {
        this.tabs = tabs;
    }

    public void mergeWithParent(Layout parentLayout) {
        this.tabs = this.mergeTabs(parentLayout.tabs, this.tabs);
    }

    private List<Tab> mergeTabs(List<Tab> parentTabs, List<Tab> childTabs) {
        HashMap<String, Tab> mergedTabs = new HashMap<String, Tab>();
        for (Tab parentTab : parentTabs) {
            mergedTabs.put(parentTab.getName(), parentTab);
        }
        for (Tab childTab : childTabs) {
            if (childTab.getName() == null) continue;
            if (childTab.getDisplayName() == null && childTab.getTabLayout() == null) {
                mergedTabs.remove(childTab.getName());
                continue;
            }
            Tab parentTab = (Tab)mergedTabs.get(childTab.getName());
            childTab.mergeWithParent(parentTab);
            mergedTabs.put(childTab.getName(), childTab);
        }
        return new ArrayList<Tab>(mergedTabs.values());
    }
}

