/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.svccomphost;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.HostLevelParamsHolder;
import id.onyx.obdp.server.agent.stomp.TopologyHolder;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.ServiceComponentHostResponse;
import id.onyx.obdp.server.controller.internal.DeleteHostComponentStatusMetaData;
import id.onyx.obdp.server.events.AlertHashInvalidationEvent;
import id.onyx.obdp.server.events.HostComponentUpdate;
import id.onyx.obdp.server.events.HostComponentsUpdateEvent;
import id.onyx.obdp.server.events.MaintenanceModeEvent;
import id.onyx.obdp.server.events.ServiceComponentInstalledEvent;
import id.onyx.obdp.server.events.ServiceComponentUninstalledEvent;
import id.onyx.obdp.server.events.StaleConfigsUpdateEvent;
import id.onyx.obdp.server.events.TopologyUpdateEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.HostComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.dao.HostComponentStateDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.dao.ServiceComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.state.BlueprintProvisioningState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostComponentAdminState;
import id.onyx.obdp.server.state.HostConfig;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import id.onyx.obdp.server.state.ServiceComponentHostEventType;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.UpgradeState;
import id.onyx.obdp.server.state.alert.AlertDefinitionHash;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.state.fsm.SingleArcTransition;
import id.onyx.obdp.server.state.fsm.StateMachine;
import id.onyx.obdp.server.state.fsm.StateMachineFactory;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostInstallEvent;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceComponentHostImpl
implements ServiceComponentHost {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceComponentHostImpl.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final ServiceComponent serviceComponent;
    private final Host host;
    private final HostComponentStateDAO hostComponentStateDAO;
    private final HostComponentDesiredStateDAO hostComponentDesiredStateDAO;
    private final HostDAO hostDAO;
    @Inject
    private RepositoryVersionDAO repositoryVersionDAO;
    @Inject
    private HostVersionDAO hostVersionDAO;
    private final ServiceComponentDesiredStateDAO serviceComponentDesiredStateDAO;
    private final Clusters clusters;
    @Inject
    private ConfigHelper helper;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private RepositoryVersionHelper repositoryVersionHelper;
    @Inject
    STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private Provider<TopologyHolder> m_topologyHolder;
    @Inject
    private Provider<HostLevelParamsHolder> m_hostLevelParamsHolder;
    @Inject
    private AlertDefinitionHash alertDefinitionHash;
    @Inject
    private Provider<OBDPManagementController> controller;
    private final OBDPEventPublisher eventPublisher;
    private final StackDAO stackDAO;
    private final Long desiredStateEntityId;
    private final Long hostComponentStateId;
    private long lastOpStartTime;
    private long lastOpEndTime;
    private long lastOpLastUpdateTime;
    private AtomicReference<MaintenanceState> maintenanceState = new AtomicReference();
    private ConcurrentMap<String, HostConfig> actualConfigs = new ConcurrentHashMap<String, HostConfig>();
    private ImmutableList<Map<String, String>> processes = ImmutableList.of();
    private static final Striped<Lock> HOST_VERSION_LOCK = Striped.lazyWeakLock((int)20);
    private final String hostName;
    private static final StateMachineFactory<ServiceComponentHostImpl, State, ServiceComponentHostEventType, ServiceComponentHostEvent> daemonStateMachineFactory = new StateMachineFactory<ServiceComponentHostImpl, State, ServiceComponentHostEventType, ServiceComponentHostEvent>(State.INIT).addTransition(State.INIT, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL, new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLING, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALLING, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new AlertDefinitionCommandTransition()).addTransition(State.INSTALLED, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALLED, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALLING, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.INSTALLING, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLING, State.INSTALL_FAILED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALL_FAILED, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_RESTART, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALL_FAILED, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALL_FAILED, State.INSTALL_FAILED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALLED, State.STARTING, ServiceComponentHostEventType.HOST_SVCCOMP_START, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLED, State.UNINSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_UNINSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLED, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLED, State.STOPPING, ServiceComponentHostEventType.HOST_SVCCOMP_STOP, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLED, State.UPGRADING, ServiceComponentHostEventType.HOST_SVCCOMP_UPGRADE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLED, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.INSTALLED, State.STARTED, ServiceComponentHostEventType.HOST_SVCCOMP_STARTED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALLED, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_STOPPED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.STARTING, State.STARTING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.STARTING, State.STARTING, ServiceComponentHostEventType.HOST_SVCCOMP_START, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.STARTING, State.STARTED, ServiceComponentHostEventType.HOST_SVCCOMP_STARTED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.STARTING, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALLED, State.STARTING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_RESTART, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.STARTED, State.STARTED, ServiceComponentHostEventType.HOST_SVCCOMP_STARTED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.STARTED, State.STOPPING, ServiceComponentHostEventType.HOST_SVCCOMP_STOP, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.STARTED, State.STARTED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.STARTED, State.STARTED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.STARTED, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_STOPPED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.STOPPING, State.STOPPING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.STOPPING, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_STOPPED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.STOPPING, State.STARTED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.STARTED, State.STOPPING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_RESTART, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.UNINSTALLING, State.UNINSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.UNINSTALLING, State.UNINSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.UNINSTALLING, State.UNINSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.UPGRADING, State.UPGRADING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.UPGRADING, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.UPGRADING, State.UPGRADING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.UPGRADING, State.UPGRADING, ServiceComponentHostEventType.HOST_SVCCOMP_UPGRADE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.UPGRADING, State.UPGRADING, ServiceComponentHostEventType.HOST_SVCCOMP_UPGRADE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.UNINSTALLING, State.UNINSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_RESTART, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.UNINSTALLING, State.UNINSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_UNINSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.UNINSTALLED, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.UNINSTALLED, State.WIPING_OUT, ServiceComponentHostEventType.HOST_SVCCOMP_WIPEOUT, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.WIPING_OUT, State.WIPING_OUT, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.WIPING_OUT, State.INIT, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.WIPING_OUT, State.WIPING_OUT, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.WIPING_OUT, State.WIPING_OUT, ServiceComponentHostEventType.HOST_SVCCOMP_OP_RESTART, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.WIPING_OUT, State.WIPING_OUT, ServiceComponentHostEventType.HOST_SVCCOMP_WIPEOUT, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLED, State.DISABLED, ServiceComponentHostEventType.HOST_SVCCOMP_DISABLE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.DISABLED, State.DISABLED, ServiceComponentHostEventType.HOST_SVCCOMP_DISABLE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.UNKNOWN, State.DISABLED, ServiceComponentHostEventType.HOST_SVCCOMP_DISABLE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.UNKNOWN, State.UNKNOWN, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALL_FAILED, State.DISABLED, ServiceComponentHostEventType.HOST_SVCCOMP_DISABLE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.DISABLED, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_RESTORE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).installTopology();
    private static final StateMachineFactory<ServiceComponentHostImpl, State, ServiceComponentHostEventType, ServiceComponentHostEvent> clientStateMachineFactory = new StateMachineFactory<ServiceComponentHostImpl, State, ServiceComponentHostEventType, ServiceComponentHostEvent>(State.INIT).addTransition(State.INIT, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL, new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLING, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALLING, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLING, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.INSTALLED, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.INSTALLED, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALLING, State.INSTALL_FAILED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALL_FAILED, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_RESTART, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALL_FAILED, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALL_FAILED, State.INSTALL_FAILED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALL_FAILED, State.INSTALL_FAILED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.INSTALLED, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.INSTALLED, State.UNINSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_UNINSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLED, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.INSTALLED, State.UPGRADING, ServiceComponentHostEventType.HOST_SVCCOMP_UPGRADE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.UPGRADING, State.UPGRADING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.UPGRADING, State.INSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.UPGRADING, State.UPGRADING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.UPGRADING, State.UPGRADING, ServiceComponentHostEventType.HOST_SVCCOMP_UPGRADE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.UPGRADING, State.UPGRADING, ServiceComponentHostEventType.HOST_SVCCOMP_UPGRADE, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.UNINSTALLING, State.UNINSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.UNINSTALLING, State.UNINSTALLED, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.UNINSTALLING, State.UNINSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.UNINSTALLING, State.UNINSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_OP_RESTART, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.UNINSTALLING, State.UNINSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_UNINSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.UNINSTALLED, State.INSTALLING, ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.UNINSTALLED, State.WIPING_OUT, ServiceComponentHostEventType.HOST_SVCCOMP_WIPEOUT, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.WIPING_OUT, State.WIPING_OUT, ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpInProgressTransition()).addTransition(State.WIPING_OUT, State.INIT, ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.WIPING_OUT, State.WIPING_OUT, ServiceComponentHostEventType.HOST_SVCCOMP_OP_FAILED, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpCompletedTransition()).addTransition(State.WIPING_OUT, State.WIPING_OUT, ServiceComponentHostEventType.HOST_SVCCOMP_OP_RESTART, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).addTransition(State.WIPING_OUT, State.WIPING_OUT, ServiceComponentHostEventType.HOST_SVCCOMP_WIPEOUT, (SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent>)new ServiceComponentHostOpStartedTransition()).installTopology();
    private final StateMachine<State, ServiceComponentHostEventType, ServiceComponentHostEvent> stateMachine;

    private void resetLastOpInfo() {
        this.setLastOpStartTime(-1L);
        this.setLastOpLastUpdateTime(-1L);
        this.setLastOpEndTime(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateLastOpInfo(ServiceComponentHostEventType eventType, long time) {
        try {
            this.writeLock.lock();
            switch (eventType) {
                case HOST_SVCCOMP_INSTALL: 
                case HOST_SVCCOMP_START: 
                case HOST_SVCCOMP_STOP: 
                case HOST_SVCCOMP_UNINSTALL: 
                case HOST_SVCCOMP_WIPEOUT: 
                case HOST_SVCCOMP_OP_RESTART: {
                    this.resetLastOpInfo();
                    this.setLastOpStartTime(time);
                    return;
                }
                case HOST_SVCCOMP_OP_FAILED: 
                case HOST_SVCCOMP_OP_SUCCEEDED: 
                case HOST_SVCCOMP_STOPPED: 
                case HOST_SVCCOMP_STARTED: {
                    this.setLastOpLastUpdateTime(time);
                    this.setLastOpEndTime(time);
                    return;
                }
                case HOST_SVCCOMP_OP_IN_PROGRESS: {
                    this.setLastOpLastUpdateTime(time);
                    return;
                }
            }
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @AssistedInject
    public ServiceComponentHostImpl(@Assisted ServiceComponent serviceComponent, @Assisted String hostName, @Assisted ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity, Clusters clusters, StackDAO stackDAO, HostDAO hostDAO, ServiceComponentDesiredStateDAO serviceComponentDesiredStateDAO, HostComponentStateDAO hostComponentStateDAO, HostComponentDesiredStateDAO hostComponentDesiredStateDAO, OBDPEventPublisher eventPublisher) {
        this.serviceComponent = serviceComponent;
        this.hostName = hostName;
        this.clusters = clusters;
        this.stackDAO = stackDAO;
        this.hostDAO = hostDAO;
        this.serviceComponentDesiredStateDAO = serviceComponentDesiredStateDAO;
        this.hostComponentStateDAO = hostComponentStateDAO;
        this.hostComponentDesiredStateDAO = hostComponentDesiredStateDAO;
        this.eventPublisher = eventPublisher;
        this.stateMachine = serviceComponent.isClientComponent() ? clientStateMachineFactory.make(this) : daemonStateMachineFactory.make(this);
        HostEntity hostEntity = null;
        try {
            this.host = clusters.getHost(hostName);
            hostEntity = hostDAO.findByName(hostName);
            if (hostEntity == null) {
                throw new OBDPException("Could not find host " + hostName);
            }
        }
        catch (OBDPException e) {
            LOG.error("Host '{}' was not found" + hostName);
            throw new RuntimeException(e);
        }
        StackId stackId = serviceComponent.getDesiredStackId();
        StackEntity stackEntity = stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        HostComponentStateEntity stateEntity = new HostComponentStateEntity();
        stateEntity.setClusterId(serviceComponent.getClusterId());
        stateEntity.setComponentName(serviceComponent.getName());
        stateEntity.setServiceName(serviceComponent.getServiceName());
        stateEntity.setVersion(State.UNKNOWN.toString());
        stateEntity.setHostEntity(hostEntity);
        stateEntity.setCurrentState(this.stateMachine.getCurrentState());
        stateEntity.setUpgradeState(UpgradeState.NONE);
        HostComponentDesiredStateEntity desiredStateEntity = new HostComponentDesiredStateEntity();
        desiredStateEntity.setClusterId(serviceComponent.getClusterId());
        desiredStateEntity.setComponentName(serviceComponent.getName());
        desiredStateEntity.setServiceName(serviceComponent.getServiceName());
        desiredStateEntity.setHostEntity(hostEntity);
        desiredStateEntity.setDesiredState(State.INIT);
        if (!serviceComponent.isMasterComponent() && !serviceComponent.isClientComponent()) {
            desiredStateEntity.setAdminState(HostComponentAdminState.INSERVICE);
        } else {
            desiredStateEntity.setAdminState(null);
        }
        this.persistEntities(hostEntity, stateEntity, desiredStateEntity, serviceComponentDesiredStateEntity);
        ServiceComponentInstalledEvent event = new ServiceComponentInstalledEvent(this.getClusterId(), stackId.getStackName(), stackId.getStackVersion(), this.getServiceName(), this.getServiceComponentName(), this.getHostName(), this.isRecoveryEnabled(), serviceComponent.isMasterComponent());
        eventPublisher.publish(event);
        this.desiredStateEntityId = desiredStateEntity.getId();
        this.hostComponentStateId = stateEntity.getId();
        this.resetLastOpInfo();
    }

    @AssistedInject
    public ServiceComponentHostImpl(@Assisted ServiceComponent serviceComponent, @Assisted String hostName, Clusters clusters, StackDAO stackDAO, HostDAO hostDAO, ServiceComponentDesiredStateDAO serviceComponentDesiredStateDAO, HostComponentStateDAO hostComponentStateDAO, HostComponentDesiredStateDAO hostComponentDesiredStateDAO, OBDPEventPublisher eventPublisher) {
        this(serviceComponent, hostName, null, clusters, stackDAO, hostDAO, serviceComponentDesiredStateDAO, hostComponentStateDAO, hostComponentDesiredStateDAO, eventPublisher);
    }

    @AssistedInject
    public ServiceComponentHostImpl(@Assisted ServiceComponent serviceComponent, @Assisted HostComponentStateEntity stateEntity, @Assisted HostComponentDesiredStateEntity desiredStateEntity, Clusters clusters, StackDAO stackDAO, HostDAO hostDAO, ServiceComponentDesiredStateDAO serviceComponentDesiredStateDAO, HostComponentStateDAO hostComponentStateDAO, HostComponentDesiredStateDAO hostComponentDesiredStateDAO, OBDPEventPublisher eventPublisher) {
        this.hostName = stateEntity.getHostName();
        this.serviceComponent = serviceComponent;
        this.clusters = clusters;
        this.stackDAO = stackDAO;
        this.hostDAO = hostDAO;
        this.serviceComponentDesiredStateDAO = serviceComponentDesiredStateDAO;
        this.hostComponentStateDAO = hostComponentStateDAO;
        this.hostComponentDesiredStateDAO = hostComponentDesiredStateDAO;
        this.eventPublisher = eventPublisher;
        this.desiredStateEntityId = desiredStateEntity.getId();
        this.hostComponentStateId = stateEntity.getId();
        this.stateMachine = serviceComponent.isClientComponent() ? clientStateMachineFactory.make(this) : daemonStateMachineFactory.make(this);
        this.stateMachine.setCurrentState(stateEntity.getCurrentState());
        try {
            this.host = clusters.getHost(stateEntity.getHostName());
        }
        catch (OBDPException e) {
            LOG.error("Host '{}' was not found " + stateEntity.getHostName());
            throw new RuntimeException(e);
        }
    }

    @Override
    public State getState() {
        return this.stateMachine.getCurrentState();
    }

    @Override
    @Transactional
    public void setState(State state) {
        State oldState = this.getState();
        this.stateMachine.setCurrentState(state);
        HostComponentStateEntity stateEntity = this.getStateEntity();
        if (stateEntity != null) {
            stateEntity.setCurrentState(state);
            stateEntity = this.hostComponentStateDAO.merge(stateEntity);
            if (!oldState.equals((Object)state)) {
                this.STOMPUpdatePublisher.publish(new HostComponentsUpdateEvent(Collections.singletonList(HostComponentUpdate.createHostComponentStatusUpdate(stateEntity, oldState))));
            }
        } else {
            LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.getServiceComponentName() + ", hostName = " + this.getHostName());
        }
    }

    @Override
    public String getVersion() {
        HostComponentStateEntity stateEntity = this.getStateEntity();
        if (stateEntity != null) {
            return stateEntity.getVersion();
        }
        LOG.warn("Trying to fetch a member from an entity object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.getServiceComponentName() + ", hostName = " + this.getHostName());
        return null;
    }

    @Override
    @Transactional
    public void setVersion(String version) throws OBDPException {
        HostComponentStateEntity stateEntity = this.getStateEntity();
        if (stateEntity != null) {
            stateEntity.setVersion(version);
            stateEntity = this.hostComponentStateDAO.merge(stateEntity);
            ServiceComponentHostRequest serviceComponentHostRequest = new ServiceComponentHostRequest(this.serviceComponent.getClusterName(), this.serviceComponent.getServiceName(), this.serviceComponent.getName(), this.hostName, this.getDesiredState().name());
            TopologyUpdateEvent updateEvent = ((OBDPManagementController)this.controller.get()).getAddedComponentsTopologyEvent(Collections.singleton(serviceComponentHostRequest));
            ((TopologyHolder)this.m_topologyHolder.get()).updateData(updateEvent);
        } else {
            LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.getServiceComponentName() + ", hostName = " + this.getHostName());
        }
    }

    @Override
    @Transactional
    public void setUpgradeState(UpgradeState upgradeState) {
        HostComponentStateEntity stateEntity = this.getStateEntity();
        if (stateEntity != null) {
            stateEntity.setUpgradeState(upgradeState);
            stateEntity = this.hostComponentStateDAO.merge(stateEntity);
        } else {
            LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.getServiceComponentName() + ", hostName = " + this.getHostName());
        }
    }

    @Override
    public UpgradeState getUpgradeState() {
        HostComponentStateEntity stateEntity = this.getStateEntity();
        if (stateEntity != null) {
            return stateEntity.getUpgradeState();
        }
        LOG.warn("Trying to fetch a state entity from an object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.getServiceComponentName() + ", hostName = " + this.getHostName());
        return UpgradeState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void handleEvent(ServiceComponentHostEvent event) throws InvalidStateTransitionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling ServiceComponentHostEvent event, eventType={}, event={}", (Object)((ServiceComponentHostEventType)((Object)event.getType())).name(), (Object)event);
        }
        State oldState = this.getState();
        try {
            this.writeLock.lock();
            try {
                HostComponentDesiredStateEntity desiredStateEntity;
                this.stateMachine.doTransition((ServiceComponentHostEventType)((Object)event.getType()), event);
                HostComponentStateEntity stateEntity = this.getStateEntity();
                boolean statusUpdated = !stateEntity.getCurrentState().equals((Object)this.stateMachine.getCurrentState());
                stateEntity.setCurrentState(this.stateMachine.getCurrentState());
                stateEntity = this.hostComponentStateDAO.merge(stateEntity);
                if (statusUpdated) {
                    this.STOMPUpdatePublisher.publish(new HostComponentsUpdateEvent(Collections.singletonList(HostComponentUpdate.createHostComponentStatusUpdate(stateEntity, oldState))));
                }
                if (((ServiceComponentHostEventType)((Object)event.getType())).equals((Object)ServiceComponentHostEventType.HOST_SVCCOMP_STARTED) && (desiredStateEntity = this.getDesiredStateEntity()).getBlueprintProvisioningState() == BlueprintProvisioningState.IN_PROGRESS) {
                    desiredStateEntity.setBlueprintProvisioningState(BlueprintProvisioningState.FINISHED);
                    this.hostComponentDesiredStateDAO.merge(desiredStateEntity);
                    ((HostLevelParamsHolder)this.m_hostLevelParamsHolder.get()).updateData(((HostLevelParamsHolder)this.m_hostLevelParamsHolder.get()).getCurrentData(this.getHost().getHostId()));
                }
            }
            catch (InvalidStateTransitionException e) {
                LOG.error("Can't handle ServiceComponentHostEvent event at current state, serviceComponentName=" + this.getServiceComponentName() + ", hostName=" + this.getHostName() + ", currentState=" + oldState + ", eventType=" + event.getType() + ", event=" + event);
                throw e;
            }
            catch (OBDPException e) {
                LOG.error("Can't update topology on hosts on ServiceComponentHostEvent event: serviceComponentName=" + this.getServiceComponentName() + ", hostName=" + this.getHostName() + ", currentState=" + oldState + ", eventType=" + event.getType() + ", event=" + event);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (!oldState.equals((Object)this.getState())) {
            LOG.info("Host role transitioned to a new state, serviceComponentName=" + this.getServiceComponentName() + ", hostName=" + this.getHostName() + ", oldState=" + oldState + ", currentState=" + this.getState());
            if (LOG.isDebugEnabled()) {
                LOG.debug("ServiceComponentHost transitioned to a new state, serviceComponentName={}, hostName={}, oldState={}, currentState={}, eventType={}, event={}", new Object[]{this.getServiceComponentName(), this.getHostName(), oldState, this.getState(), ((ServiceComponentHostEventType)((Object)event.getType())).name(), event});
            }
        }
    }

    @Override
    public String getServiceComponentName() {
        return this.serviceComponent.getName();
    }

    @Override
    public String getHostName() {
        return this.host.getHostName();
    }

    @Override
    public String getPublicHostName() {
        return this.host.getPublicHostName();
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    public long getLastOpStartTime() {
        return this.lastOpStartTime;
    }

    public void setLastOpStartTime(long lastOpStartTime) {
        this.lastOpStartTime = lastOpStartTime;
    }

    public long getLastOpEndTime() {
        return this.lastOpEndTime;
    }

    public void setLastOpEndTime(long lastOpEndTime) {
        this.lastOpEndTime = lastOpEndTime;
    }

    public long getLastOpLastUpdateTime() {
        return this.lastOpLastUpdateTime;
    }

    public void setLastOpLastUpdateTime(long lastOpLastUpdateTime) {
        this.lastOpLastUpdateTime = lastOpLastUpdateTime;
    }

    @Override
    public long getClusterId() {
        return this.serviceComponent.getClusterId();
    }

    @Override
    public String getServiceName() {
        return this.serviceComponent.getServiceName();
    }

    @Override
    public boolean isClientComponent() {
        return this.serviceComponent.isClientComponent();
    }

    @Override
    public State getDesiredState() {
        HostComponentDesiredStateEntity desiredStateEntity = this.getDesiredStateEntity();
        if (desiredStateEntity != null) {
            return desiredStateEntity.getDesiredState();
        }
        LOG.warn("Trying to fetch a member from an entity object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.getServiceComponentName() + ", hostName = " + this.getHostName());
        return null;
    }

    @Override
    public void setDesiredState(State state) {
        LOG.debug("Set DesiredState on serviceName = {} componentName = {} hostName = {} to {} ", new Object[]{this.getServiceName(), this.getServiceComponentName(), this.getHostName(), state});
        HostComponentDesiredStateEntity desiredStateEntity = this.getDesiredStateEntity();
        if (desiredStateEntity != null) {
            desiredStateEntity.setDesiredState(state);
            this.hostComponentDesiredStateDAO.merge(desiredStateEntity);
        } else {
            LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.getServiceComponentName() + "hostName = " + this.getHostName());
        }
    }

    @Override
    public HostComponentAdminState getComponentAdminState() {
        HostComponentDesiredStateEntity desiredStateEntity = this.getDesiredStateEntity();
        return this.getComponentAdminStateFromDesiredStateEntity(desiredStateEntity);
    }

    private HostComponentAdminState getComponentAdminStateFromDesiredStateEntity(HostComponentDesiredStateEntity desiredStateEntity) {
        if (desiredStateEntity != null) {
            HostComponentAdminState adminState = desiredStateEntity.getAdminState();
            if (adminState == null && !this.serviceComponent.isClientComponent() && !this.serviceComponent.isMasterComponent()) {
                adminState = HostComponentAdminState.INSERVICE;
            }
            return adminState;
        }
        return null;
    }

    @Override
    public void setComponentAdminState(HostComponentAdminState attribute) {
        LOG.debug("Set ComponentAdminState on serviceName = {} componentName = {} hostName = {} to {}", new Object[]{this.getServiceName(), this.getServiceComponentName(), this.getHostName(), attribute});
        HostComponentDesiredStateEntity desiredStateEntity = this.getDesiredStateEntity();
        if (desiredStateEntity != null) {
            desiredStateEntity.setAdminState(attribute);
            this.hostComponentDesiredStateDAO.merge(desiredStateEntity);
        } else {
            LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.getServiceComponentName() + "hostName = " + this.getHostName());
        }
    }

    @Override
    public ServiceComponentHostResponse convertToResponse(Map<String, DesiredConfig> desiredConfigs) {
        HostComponentStateEntity hostComponentStateEntity = this.getStateEntity();
        HostEntity hostEntity = hostComponentStateEntity.getHostEntity();
        HostComponentDesiredStateEntity hostComponentDesiredStateEntity = this.getDesiredStateEntity();
        String clusterName = this.serviceComponent.getClusterName();
        String serviceName = this.serviceComponent.getServiceName();
        String serviceComponentName = this.serviceComponent.getName();
        String hostName = this.getHostName();
        String publicHostName = hostEntity.getPublicHostName();
        String state = this.getState().toString();
        String desiredState = hostComponentDesiredStateEntity == null ? null : hostComponentDesiredStateEntity.getDesiredState().toString();
        String desiredStackId = this.serviceComponent.getDesiredStackId().getStackId();
        HostComponentAdminState componentAdminState = this.getComponentAdminStateFromDesiredStateEntity(hostComponentDesiredStateEntity);
        UpgradeState upgradeState = hostComponentStateEntity.getUpgradeState();
        String displayName = null;
        try {
            StackId stackVersion = this.serviceComponent.getDesiredStackId();
            ComponentInfo compInfo = this.obdpMetaInfo.getComponent(stackVersion.getStackName(), stackVersion.getStackVersion(), serviceName, serviceComponentName);
            displayName = compInfo.getDisplayName();
        }
        catch (OBDPException e) {
            displayName = serviceComponentName;
        }
        String desiredRepositoryVersion = null;
        RepositoryVersionEntity repositoryVersion = this.serviceComponent.getDesiredRepositoryVersion();
        if (null != repositoryVersion) {
            desiredRepositoryVersion = repositoryVersion.getVersion();
        }
        ServiceComponentHostResponse r = new ServiceComponentHostResponse(clusterName, serviceName, serviceComponentName, displayName, hostName, publicHostName, state, this.getVersion(), desiredState, desiredStackId, desiredRepositoryVersion, componentAdminState);
        r.setActualConfigs(this.actualConfigs);
        r.setUpgradeState(upgradeState);
        try {
            r.setStaleConfig(this.helper.isStaleConfigs(this, desiredConfigs, hostComponentDesiredStateEntity));
        }
        catch (Exception e) {
            LOG.error("Could not determine stale config", (Throwable)e);
        }
        try {
            Cluster cluster = this.clusters.getCluster(clusterName);
            ServiceComponent serviceComponent = cluster.getService(serviceName).getServiceComponent(serviceComponentName);
            ServiceComponentHost sch = serviceComponent.getServiceComponentHost(hostName);
            String refreshConfigsCommand = this.helper.getRefreshConfigsCommand(cluster, sch);
            r.setReloadConfig(refreshConfigsCommand != null);
        }
        catch (Exception e) {
            LOG.error("Could not determine reload config flag", (Throwable)e);
        }
        return r;
    }

    @Override
    public ServiceComponentHostResponse convertToResponseStatusOnly(Map<String, DesiredConfig> desiredConfigs, boolean collectStaleConfigsStatus) {
        String clusterName = this.serviceComponent.getClusterName();
        String serviceName = this.serviceComponent.getServiceName();
        String serviceComponentName = this.serviceComponent.getName();
        String state = this.getState().toString();
        ServiceComponentHostResponse r = new ServiceComponentHostResponse(clusterName, serviceName, serviceComponentName, null, this.hostName, null, state, null, null, null, null, null);
        if (collectStaleConfigsStatus) {
            try {
                HostComponentDesiredStateEntity hostComponentDesiredStateEntity = this.getDesiredStateEntity();
                r.setStaleConfig(this.helper.isStaleConfigs(this, desiredConfigs, hostComponentDesiredStateEntity));
            }
            catch (Exception e) {
                LOG.error("Could not determine stale config", (Throwable)e);
            }
        } else {
            r.setStaleConfig(false);
        }
        return r;
    }

    @Override
    public String getClusterName() {
        return this.serviceComponent.getClusterName();
    }

    @Override
    public void debugDump(StringBuilder sb) {
        sb.append("ServiceComponentHost={ hostname=").append(this.getHostName()).append(", serviceComponentName=").append(this.serviceComponent.getName()).append(", clusterName=").append(this.serviceComponent.getClusterName()).append(", serviceName=").append(this.serviceComponent.getServiceName()).append(", desiredStackVersion=").append(this.serviceComponent.getDesiredStackId()).append(", desiredState=").append((Object)this.getDesiredState()).append(", version=").append(this.getVersion()).append(", state=").append((Object)this.getState()).append(" }");
    }

    @Transactional
    void persistEntities(HostEntity hostEntity, HostComponentStateEntity stateEntity, HostComponentDesiredStateEntity desiredStateEntity, ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity) {
        if (serviceComponentDesiredStateEntity == null) {
            serviceComponentDesiredStateEntity = this.serviceComponentDesiredStateDAO.findByName(this.serviceComponent.getClusterId(), this.serviceComponent.getServiceName(), this.serviceComponent.getName());
        }
        desiredStateEntity.setServiceComponentDesiredStateEntity(serviceComponentDesiredStateEntity);
        desiredStateEntity.setHostEntity(hostEntity);
        desiredStateEntity.setHostId(hostEntity.getHostId());
        stateEntity.setServiceComponentDesiredStateEntity(serviceComponentDesiredStateEntity);
        stateEntity.setHostEntity(hostEntity);
        this.hostComponentStateDAO.create(stateEntity);
        this.hostComponentDesiredStateDAO.create(desiredStateEntity);
        serviceComponentDesiredStateEntity.getHostComponentDesiredStateEntities().add(desiredStateEntity);
        serviceComponentDesiredStateEntity = this.serviceComponentDesiredStateDAO.merge(serviceComponentDesiredStateEntity);
        hostEntity.addHostComponentStateEntity(stateEntity);
        hostEntity.addHostComponentDesiredStateEntity(desiredStateEntity);
        hostEntity = this.hostDAO.merge(hostEntity);
    }

    @Override
    public boolean canBeRemoved() {
        return this.getState().isRemovableState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteHostComponentStatusMetaData deleteMetaData) {
        boolean fireRemovalEvent = false;
        this.writeLock.lock();
        String version = this.getVersion();
        try {
            this.removeEntities();
            fireRemovalEvent = true;
            this.clusters.getCluster(this.getClusterName()).removeServiceComponentHost(this);
        }
        catch (OBDPException ex) {
            LOG.error("Unable to remove a service component from a host", (Throwable)ex);
        }
        finally {
            this.writeLock.unlock();
        }
        if (fireRemovalEvent) {
            long clusterId = this.getClusterId();
            StackId stackId = this.serviceComponent.getDesiredStackId();
            String stackVersion = stackId.getStackVersion();
            String stackName = stackId.getStackName();
            String serviceName = this.getServiceName();
            String componentName = this.getServiceComponentName();
            String hostName = this.getHostName();
            State lastComponentState = this.getState();
            boolean recoveryEnabled = this.isRecoveryEnabled();
            boolean masterComponent = this.serviceComponent.isMasterComponent();
            ServiceComponentUninstalledEvent event = new ServiceComponentUninstalledEvent(clusterId, stackName, stackVersion, serviceName, componentName, hostName, recoveryEnabled, masterComponent, this.host.getHostId());
            this.eventPublisher.publish(event);
            deleteMetaData.addDeletedHostComponent(componentName, serviceName, hostName, this.getHost().getHostId(), Long.toString(clusterId), version, lastComponentState);
        }
    }

    @Transactional
    protected void removeEntities() {
        HostComponentStateEntity stateEntity = this.getStateEntity();
        if (stateEntity != null) {
            HostEntity hostEntity = stateEntity.getHostEntity();
            HostComponentDesiredStateEntity desiredStateEntity = this.getDesiredStateEntity();
            hostEntity.removeHostComponentStateEntity(stateEntity);
            hostEntity.removeHostComponentDesiredStateEntity(desiredStateEntity);
            this.hostDAO.merge(hostEntity);
            this.hostComponentDesiredStateDAO.remove(desiredStateEntity);
            this.hostComponentStateDAO.remove(stateEntity);
        }
    }

    @Override
    public Map<String, HostConfig> getActualConfigs() {
        return this.actualConfigs;
    }

    @Override
    public HostState getHostState() {
        return this.host.getState();
    }

    @Override
    public boolean isRecoveryEnabled() {
        return this.serviceComponent.isRecoveryEnabled();
    }

    @Override
    public void setMaintenanceState(MaintenanceState state) {
        LOG.debug("Set MaintenanceState on serviceName = {} componentName = {} hostName = {} to {}", new Object[]{this.getServiceName(), this.getServiceComponentName(), this.getHostName(), state});
        HostComponentDesiredStateEntity desiredStateEntity = this.getDesiredStateEntity();
        if (desiredStateEntity != null) {
            desiredStateEntity.setMaintenanceState(state);
            this.maintenanceState.set(this.hostComponentDesiredStateDAO.merge(desiredStateEntity).getMaintenanceState());
            MaintenanceModeEvent event = new MaintenanceModeEvent(state, this);
            this.eventPublisher.publish(event);
        } else {
            LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.getServiceComponentName() + ", hostName = " + this.getHostName());
        }
    }

    @Override
    public MaintenanceState getMaintenanceState() {
        if (this.maintenanceState.get() == null) {
            this.maintenanceState.set(this.getDesiredStateEntity().getMaintenanceState());
        }
        return this.maintenanceState.get();
    }

    @Override
    public void setProcesses(List<Map<String, String>> procs) {
        this.processes = ImmutableList.copyOf(procs);
    }

    @Override
    public List<Map<String, String>> getProcesses() {
        return this.processes;
    }

    @Override
    public boolean isRestartRequired() {
        return this.getDesiredStateEntity().isRestartRequired();
    }

    @Override
    public boolean isRestartRequired(HostComponentDesiredStateEntity hostComponentDesiredStateEntity) {
        return hostComponentDesiredStateEntity.isRestartRequired();
    }

    @Override
    @Transactional
    public void setRestartRequired(boolean restartRequired) {
        if (this.setRestartRequiredWithoutEventPublishing(restartRequired)) {
            this.eventPublisher.publish(new StaleConfigsUpdateEvent(this, restartRequired));
        }
    }

    @Override
    @Transactional
    public boolean setRestartRequiredWithoutEventPublishing(boolean restartRequired) {
        LOG.debug("Set RestartRequired on serviceName = {} componentName = {} hostName = {} to {}", new Object[]{this.getServiceName(), this.getServiceComponentName(), this.getHostName(), restartRequired});
        HostComponentDesiredStateEntity desiredStateEntity = this.getDesiredStateEntity();
        if (desiredStateEntity != null) {
            desiredStateEntity.setRestartRequired(restartRequired);
            this.hostComponentDesiredStateDAO.merge(desiredStateEntity);
            return true;
        }
        LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.getServiceComponentName() + ", hostName = " + this.getHostName());
        return false;
    }

    @Transactional
    RepositoryVersionEntity createRepositoryVersion(String version, StackId stackId, StackInfo stackInfo) throws OBDPException {
        LOG.info("Creating new repository version " + stackId.getStackName() + "-" + version);
        StackEntity stackEntity = this.stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        if (null == version) {
            throw new OBDPException(MessageFormat.format("Cannot create Repository Version for Stack {0}-{1} if the version is empty", stackId.getStackName(), stackId.getStackVersion()));
        }
        return this.repositoryVersionDAO.create(stackEntity, version, stackId.getStackName() + "-" + version, this.repositoryVersionHelper.createRepoOsEntities(stackInfo.getRepositories()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public HostVersionEntity recalculateHostVersionState() throws OBDPException {
        HostEntity hostEntity = this.host.getHostEntity();
        RepositoryVersionEntity repositoryVersion = this.serviceComponent.getDesiredRepositoryVersion();
        HostVersionEntity hostVersionEntity = this.hostVersionDAO.findHostVersionByHostAndRepository(hostEntity, repositoryVersion);
        Lock lock = (Lock)HOST_VERSION_LOCK.get((Object)this.host.getHostName());
        lock.lock();
        try {
            if (hostVersionEntity == null) {
                hostVersionEntity = new HostVersionEntity(hostEntity, repositoryVersion, RepositoryVersionState.INSTALLING);
                LOG.info("Creating host version for {}, state={}, repo={} (repo_id={})", new Object[]{hostVersionEntity.getHostName(), hostVersionEntity.getState(), hostVersionEntity.getRepositoryVersion().getVersion(), hostVersionEntity.getRepositoryVersion().getId()});
                this.hostVersionDAO.create(hostVersionEntity);
            }
            if (hostVersionEntity.getState() != RepositoryVersionState.CURRENT && this.host.isRepositoryVersionCorrect(repositoryVersion)) {
                hostVersionEntity.setState(RepositoryVersionState.CURRENT);
                hostVersionEntity = this.hostVersionDAO.merge(hostVersionEntity);
            }
        }
        finally {
            lock.unlock();
        }
        return hostVersionEntity;
    }

    @Override
    public HostComponentDesiredStateEntity getDesiredStateEntity() {
        return this.hostComponentDesiredStateDAO.findById(this.desiredStateEntityId);
    }

    private HostComponentStateEntity getStateEntity() {
        return this.hostComponentStateDAO.findById(this.hostComponentStateId);
    }

    @Override
    public ServiceComponent getServiceComponent() {
        return this.serviceComponent;
    }

    @Override
    public StackId getDesiredStackId() {
        return this.serviceComponent.getDesiredStackId();
    }

    static class ServiceComponentHostOpStartedTransition
    implements SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent> {
        ServiceComponentHostOpStartedTransition() {
        }

        @Override
        public void transition(ServiceComponentHostImpl impl, ServiceComponentHostEvent event) {
            impl.updateLastOpInfo((ServiceComponentHostEventType)((Object)event.getType()), event.getOpTimestamp());
            if (event.getType() == ServiceComponentHostEventType.HOST_SVCCOMP_INSTALL) {
                ServiceComponentHostInstallEvent e = (ServiceComponentHostInstallEvent)event;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating live stack version during INSTALL event, new stack version={}", (Object)e.getStackId());
                }
            }
        }
    }

    static class ServiceComponentHostOpCompletedTransition
    implements SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent> {
        ServiceComponentHostOpCompletedTransition() {
        }

        @Override
        public void transition(ServiceComponentHostImpl impl, ServiceComponentHostEvent event) {
            impl.updateLastOpInfo((ServiceComponentHostEventType)((Object)event.getType()), event.getOpTimestamp());
        }
    }

    static class AlertDefinitionCommandTransition
    implements SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent> {
        AlertDefinitionCommandTransition() {
        }

        @Override
        public void transition(ServiceComponentHostImpl impl, ServiceComponentHostEvent event) {
            if (event.getType() != ServiceComponentHostEventType.HOST_SVCCOMP_OP_SUCCEEDED) {
                return;
            }
            String hostName = impl.getHostName();
            impl.alertDefinitionHash.invalidate(impl.getClusterName(), hostName);
            AlertHashInvalidationEvent hashInvalidationEvent = new AlertHashInvalidationEvent(impl.getClusterId(), Collections.singletonList(hostName));
            impl.eventPublisher.publish(hashInvalidationEvent);
            impl.updateLastOpInfo((ServiceComponentHostEventType)((Object)event.getType()), event.getOpTimestamp());
        }
    }

    static class ServiceComponentHostOpInProgressTransition
    implements SingleArcTransition<ServiceComponentHostImpl, ServiceComponentHostEvent> {
        ServiceComponentHostOpInProgressTransition() {
        }

        @Override
        public void transition(ServiceComponentHostImpl impl, ServiceComponentHostEvent event) {
            impl.updateLastOpInfo((ServiceComponentHostEventType)((Object)event.getType()), event.getOpTimestamp());
        }
    }
}

