/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.stack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.MultiValueMap;
import org.slf4j.Logger;

public class StackRoleCommandOrder {
    private static final String GENERAL_DEPS_KEY = "general_deps";
    private static final String GLUSTERFS_DEPS_KEY = "optional_glusterfs";
    private static final String NO_GLUSTERFS_DEPS_KEY = "optional_no_glusterfs";
    private static final String NAMENODE_HA_DEPS_KEY = "namenode_optional_ha";
    private static final String RESOURCEMANAGER_HA_DEPS_KEY = "resourcemanager_optional_ha";
    private static final String HOST_ORDERED_UPGRADES_DEPS_KEY = "host_ordered_upgrade";
    private HashMap<String, Object> content;

    public StackRoleCommandOrder() {
    }

    public StackRoleCommandOrder(HashMap<String, Object> content) {
        this.content = content;
    }

    public HashMap<String, Object> getContent() {
        return this.content;
    }

    public void setContent(HashMap<String, Object> content) {
        this.content = content;
    }

    public void merge(StackRoleCommandOrder parent) {
        this.merge(parent, false);
    }

    public void merge(StackRoleCommandOrder parent, boolean mergeProperties) {
        HashMap<String, Object> mergedRoleCommandOrders = new HashMap<String, Object>();
        HashMap<String, Object> parentData = parent.getContent();
        List<String> keys = Arrays.asList(GENERAL_DEPS_KEY, GLUSTERFS_DEPS_KEY, NO_GLUSTERFS_DEPS_KEY, NAMENODE_HA_DEPS_KEY, RESOURCEMANAGER_HA_DEPS_KEY, HOST_ORDERED_UPGRADES_DEPS_KEY);
        for (String key : keys) {
            if (parentData.containsKey(key) && this.content.containsKey(key)) {
                HashMap result = new HashMap();
                Map parentProperties = (Map)parentData.get(key);
                Map childProperties = (Map)this.content.get(key);
                MultiValueMap childAndParentProperties = null;
                childAndParentProperties = new MultiValueMap();
                childAndParentProperties.putAll(childProperties);
                childAndParentProperties.putAll(parentProperties);
                for (Object property : childAndParentProperties.keySet()) {
                    List propertyValues = (List)childAndParentProperties.get(property);
                    Object values = propertyValues.get(0);
                    if (mergeProperties) {
                        ArrayList<String> valueList = new ArrayList<String>();
                        for (Object value : propertyValues) {
                            if (value instanceof List) {
                                valueList.addAll((List)value);
                                continue;
                            }
                            valueList.add(value.toString());
                        }
                        values = valueList;
                    }
                    result.put((String)property, values);
                }
                mergedRoleCommandOrders.put(key, result);
                continue;
            }
            if (this.content.containsKey(key)) {
                mergedRoleCommandOrders.put(key, this.content.get(key));
                continue;
            }
            if (!parentData.containsKey(key)) continue;
            mergedRoleCommandOrders.put(key, parentData.get(key));
        }
        this.content = mergedRoleCommandOrders;
    }

    public void printRoleCommandOrder(Logger LOG) {
        HashMap<String, Object> map = this.getContent();
        List<String> keys = Arrays.asList(GENERAL_DEPS_KEY, GLUSTERFS_DEPS_KEY, NO_GLUSTERFS_DEPS_KEY, NAMENODE_HA_DEPS_KEY, RESOURCEMANAGER_HA_DEPS_KEY);
        for (String key : keys) {
            LOG.debug(key);
            Object value = map.get(key);
            if (!(value instanceof Map)) continue;
            Map deps = (Map)map.get(key);
            for (String depKey : deps.keySet()) {
                Object depValue = deps.get(depKey);
                if (depValue instanceof Collection) {
                    StringBuilder buffer = new StringBuilder();
                    for (Object o : (Collection)depValue) {
                        if (buffer.length() > 0) {
                            buffer.append(",");
                        }
                        buffer.append(o);
                    }
                    depValue = buffer.toString();
                }
                LOG.debug("{} => {}", (Object)depKey, depValue);
            }
        }
    }
}

