/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.stack;

import com.google.common.base.Strings;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.stack.RepoTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="reposinfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RepositoryXml
implements Validable {
    private static final Pattern HTTP_URL_PROTOCOL_PATTERN = Pattern.compile("((http(s)*:\\/\\/))");
    @XmlElement(name="latest")
    private String latestUri;
    @XmlElement(name="os")
    private List<Os> oses = new ArrayList<Os>();
    @XmlTransient
    private boolean valid = true;
    @XmlTransient
    private Set<String> errorSet = new HashSet<String>();

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }

    public String getLatestURI() {
        return this.latestUri;
    }

    public List<Os> getOses() {
        return this.oses;
    }

    public List<RepositoryInfo> getRepositories() {
        return this.getRepositories(null);
    }

    public List<RepositoryInfo> getRepositories(String credentials) {
        ArrayList<RepositoryInfo> repos = new ArrayList<RepositoryInfo>();
        for (Os o : this.getOses()) {
            String osFamily = o.getFamily();
            for (String os : osFamily.split(",")) {
                for (Repo r : o.getRepos()) {
                    RepositoryInfo ri = new RepositoryInfo();
                    String baseUrl = r.getBaseUrl();
                    if (!Strings.isNullOrEmpty((String)credentials)) {
                        Matcher matcher = HTTP_URL_PROTOCOL_PATTERN.matcher(baseUrl);
                        baseUrl = matcher.replaceAll("$1" + credentials + "@");
                    }
                    ri.setBaseUrl(baseUrl);
                    ri.setDefaultBaseUrl(r.getBaseUrl());
                    ri.setMirrorsList(r.getMirrorsList());
                    ri.setOsType(os.trim());
                    ri.setRepoId(r.getRepoId());
                    ri.setRepoName(r.getRepoName());
                    ri.setDistribution(r.getDistribution());
                    ri.setComponents(r.getComponents());
                    ri.setUnique(r.isUnique());
                    ri.setTags(r.tags);
                    repos.add(ri);
                }
            }
        }
        return repos;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Os {
        @XmlAttribute(name="family")
        private String family;
        @XmlElement(name="package-version")
        private String packageVersion;
        @XmlElement(name="repo")
        private List<Repo> repos;

        private Os() {
        }

        public String getFamily() {
            return this.family;
        }

        public List<Repo> getRepos() {
            return this.repos;
        }

        public String getPackageVersion() {
            return this.packageVersion;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Repo {
        private String baseurl = null;
        private String mirrorslist = null;
        private String repoid = null;
        private String reponame = null;
        private String distribution = null;
        private String components = null;
        private boolean unique = false;
        @XmlElementWrapper(name="tags")
        @XmlElement(name="tag")
        private Set<RepoTag> tags = new HashSet<RepoTag>();

        private Repo() {
        }

        public String getBaseUrl() {
            return null == this.baseurl || this.baseurl.isEmpty() ? null : this.baseurl;
        }

        public String getMirrorsList() {
            return null == this.mirrorslist || this.mirrorslist.isEmpty() ? null : this.mirrorslist;
        }

        public String getRepoId() {
            return this.repoid;
        }

        public String getRepoName() {
            return this.reponame;
        }

        public String getDistribution() {
            return this.distribution;
        }

        public String getComponents() {
            return this.components;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public void setUnique(boolean unique) {
            this.unique = unique;
        }

        public Set<RepoTag> getTags() {
            return this.tags;
        }
    }
}

