/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.stack;

import id.onyx.obdp.server.stack.StackModule;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.state.stack.OsFamily;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoVdfCallable
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(RepoVdfCallable.class);
    private final StackInfo m_stack;
    private final OsFamily m_family;
    private final Map<String, URI> m_vdfMap;
    private String m_version;

    public RepoVdfCallable(StackModule stackModule, String version, Map<String, URI> vdfOsMap, OsFamily os_family) {
        this.m_stack = stackModule.getModuleInfo();
        this.m_family = os_family;
        this.m_version = version;
        this.m_vdfMap = vdfOsMap;
    }

    public RepoVdfCallable(StackModule stackModule, Map<String, URI> vdfOsMap, OsFamily os_family) {
        this.m_stack = stackModule.getModuleInfo();
        this.m_family = os_family;
        this.m_version = null;
        this.m_vdfMap = vdfOsMap;
    }

    @Override
    public Void call() throws Exception {
        if (MapUtils.isEmpty(this.m_vdfMap)) {
            return null;
        }
        boolean forLatest = null == this.m_version;
        StackId stackId = new StackId(this.m_stack);
        VersionDefinitionXml xml = this.mergeDefinitions(stackId, this.m_version, this.m_vdfMap);
        if (null == xml) {
            return null;
        }
        if (forLatest) {
            xml.setStackDefault(true);
            this.m_stack.setLatestVersionDefinition(xml);
        } else {
            this.m_stack.addVersionDefinition(this.m_version, xml);
        }
        return null;
    }

    private VersionDefinitionXml mergeDefinitions(StackId stackId, String version, Map<String, URI> osMap) throws Exception {
        HashSet<String> oses = new HashSet<String>();
        for (RepositoryInfo ri : this.m_stack.getRepositories()) {
            if (null == this.m_family.find(ri.getOsType())) continue;
            oses.add(this.m_family.find(ri.getOsType()));
        }
        VersionDefinitionXml.Merger merger = new VersionDefinitionXml.Merger();
        for (Map.Entry<String, URI> versionEntry : osMap.entrySet()) {
            String alias;
            String osFamily = this.m_family.find(versionEntry.getKey());
            URI uri = versionEntry.getValue();
            if (null == osFamily && null != (alias = this.m_family.getAliases().get(versionEntry.getKey()))) {
                osFamily = this.m_family.find(alias);
            }
            if (null == osFamily || !oses.contains(osFamily)) {
                LOG.info("Stack {} cannot resolve OS {} to the supported ones: {}. Family: {}", new Object[]{stackId, versionEntry.getKey(), StringUtils.join(oses, (char)','), osFamily});
                continue;
            }
            try {
                VersionDefinitionXml xml = this.timedVDFLoad(uri);
                version = null == version ? xml.release.version : version;
                merger.add(version, xml);
            }
            catch (Exception e) {
                LOG.warn("Could not load version definition for {} identified by {}. {}", new Object[]{stackId, uri.toString(), e.getMessage(), e});
            }
        }
        return merger.merge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionDefinitionXml timedVDFLoad(URI uri) throws Exception {
        long time = System.currentTimeMillis();
        try {
            VersionDefinitionXml versionDefinitionXml = VersionDefinitionXml.load(uri.toURL());
            return versionDefinitionXml;
        }
        finally {
            LOG.debug("Loaded VDF {} in {}ms", (Object)uri, (Object)(System.currentTimeMillis() - time));
        }
    }
}

