/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.stack;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.stack.StackModule;
import id.onyx.obdp.server.state.StackId;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoUrlInfoCallable
implements Callable<Map<StackModule, RepoUrlInfoResult>> {
    private static final int LOOKUP_CONNECTION_TIMEOUT = 2000;
    private static final int LOOKUP_READ_TIMEOUT = 3000;
    private static final Logger LOG = LoggerFactory.getLogger(RepoUrlInfoCallable.class);
    private URI m_uri = null;
    private Set<StackModule> m_stacks = new HashSet<StackModule>();

    public RepoUrlInfoCallable(URI uri) {
        this.m_uri = uri;
    }

    public void addStack(StackModule stackModule) {
        this.m_stacks.add(stackModule);
    }

    @Override
    public Map<StackModule, RepoUrlInfoResult> call() throws Exception {
        Type type = new TypeToken<Map<String, Map<String, Object>>>(){}.getType();
        Gson gson = new Gson();
        Map latestUrlMap = null;
        HashSet ids = new HashSet();
        ids.addAll(Collections2.transform(this.m_stacks, (Function)new Function<StackModule, String>(){

            public String apply(StackModule input) {
                return new StackId(input.getModuleInfo()).toString();
            }
        }));
        String stackIds = StringUtils.join(ids, (char)',');
        Long time = System.nanoTime();
        try {
            if (this.m_uri.getScheme().startsWith("http")) {
                URLStreamProvider streamProvider = new URLStreamProvider(2000, 3000, null, null, null);
                LOG.info("Loading latest URL info from {} for stacks {}", (Object)this.m_uri, (Object)stackIds);
                latestUrlMap = (Map)gson.fromJson((Reader)new InputStreamReader(streamProvider.readFrom(this.m_uri.toString())), type);
            } else {
                File jsonFile = new File(this.m_uri);
                if (jsonFile.exists()) {
                    LOG.info("Loading latest URL info from file {} for stacks {}", (Object)this.m_uri, (Object)stackIds);
                    latestUrlMap = (Map)gson.fromJson((Reader)new FileReader(jsonFile), type);
                }
            }
        }
        catch (Exception e) {
            try {
                LOG.info("Could not load the URI from {}, stack defaults will be used", (Object)this.m_uri);
                throw e;
            }
            catch (Throwable throwable) {
                LOG.info("Loaded URI {} for stacks {} in {}ms", new Object[]{this.m_uri, stackIds, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time)});
                throw throwable;
            }
        }
        LOG.info("Loaded URI {} for stacks {} in {}ms", new Object[]{this.m_uri, stackIds, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time)});
        HashMap<StackModule, RepoUrlInfoResult> result = new HashMap<StackModule, RepoUrlInfoResult>();
        if (null == latestUrlMap) {
            LOG.error("Could not load latest data for URI {} and stacks {}", (Object)this.m_uri, (Object)stackIds);
            return result;
        }
        for (StackModule stackModule : this.m_stacks) {
            StackId stackId = new StackId(stackModule.getModuleInfo());
            Map map = (Map)latestUrlMap.get(stackId.toString());
            if (null == map) continue;
            RepoUrlInfoResult res = new RepoUrlInfoResult();
            if (map.containsKey("manifests")) {
                Map versionMap = (Map)map.get("manifests");
                for (Map.Entry versionEntry : versionMap.entrySet()) {
                    String version = (String)versionEntry.getKey();
                    Map<String, URI> resolvedOsMap = this.resolveOsMap(stackModule, (Map)versionEntry.getValue());
                    res.addVersion(version, resolvedOsMap);
                }
            }
            if (map.containsKey("latest-vdf")) {
                Map osMap = (Map)map.get("latest-vdf");
                Map<String, URI> resolvedOsMap = this.resolveOsMap(stackModule, osMap);
                res.setLatest(resolvedOsMap);
            }
            result.put(stackModule, res);
        }
        return result;
    }

    private Map<String, URI> resolveOsMap(StackModule stackModule, Map<String, String> osMap) {
        HashMap<String, URI> resolved = new HashMap<String, URI>();
        for (Map.Entry<String, String> osEntry : osMap.entrySet()) {
            String uriString = osEntry.getValue();
            URI uri = StackModule.getURI(stackModule, uriString);
            if (null == uri) {
                LOG.warn("Could not resolve URI {}", (Object)uriString);
                continue;
            }
            resolved.put(osEntry.getKey(), uri);
        }
        return resolved;
    }

    public static class RepoUrlInfoResult {
        private Map<String, Map<String, URI>> versions = new HashMap<String, Map<String, URI>>();
        private Map<String, URI> latestVdf = new HashMap<String, URI>();

        private void addVersion(String version, Map<String, URI> vdfMap) {
            this.versions.put(version, vdfMap);
        }

        private void setLatest(Map<String, URI> latestMap) {
            this.latestVdf = latestMap;
        }

        public Map<String, Map<String, URI>> getManifest() {
            return this.versions;
        }

        public Map<String, URI> getLatestVdf() {
            return this.latestVdf;
        }
    }
}

