/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.stack;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.state.stack.JsonOsFamilyEntry;
import id.onyx.obdp.server.state.stack.JsonOsFamilyRoot;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OsFamily {
    private static final String OS_FAMILY_UBUNTU = "ubuntu";
    private static final String OS_FAMILY_SUSE = "suse";
    private static final String OS_FAMILY_REDHAT = "redhat";
    private final String os_pattern = "([\\D]+|(?:[\\D]+[\\d]+[\\D]+))([\\d]*)";
    private final String OS_DISTRO = "distro";
    private final String OS_VERSION = "versions";
    private final String LOAD_CONFIG_MSG = "Could not load OS family definition from %s file";
    private final String FILE_NAME = "os_family.json";
    private static final Logger LOG = LoggerFactory.getLogger(OsFamily.class);
    private Map<String, JsonOsFamilyEntry> osMap = null;
    private JsonOsFamilyRoot jsonOsFamily = null;

    public OsFamily(Configuration conf) {
        this.init(conf.getSharedResourcesDirPath());
    }

    public OsFamily(Properties properties) {
        this.init(properties.getProperty(Configuration.SHARED_RESOURCES_DIR.getKey()));
    }

    private void init(String SharedResourcesPath) {
        FileInputStream inputStream = null;
        try {
            File f = new File(SharedResourcesPath, "os_family.json");
            if (!f.exists()) {
                throw new Exception();
            }
            inputStream = new FileInputStream(f);
            Type type = new TypeToken<JsonOsFamilyRoot>(){}.getType();
            Gson gson = new Gson();
            this.jsonOsFamily = (JsonOsFamilyRoot)gson.fromJson((Reader)new InputStreamReader(inputStream), type);
            this.osMap = this.jsonOsFamily.getMapping();
        }
        catch (Exception e) {
            try {
                LOG.error(String.format("Could not load OS family definition from %s file", new File(SharedResourcesPath, "os_family.json").toString()));
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    private Map<String, String> parse_os(String os) {
        HashMap<String, String> pos = new HashMap<String, String>();
        Pattern r = Pattern.compile("([\\D]+|(?:[\\D]+[\\d]+[\\D]+))([\\d]*)");
        Matcher m = r.matcher(os);
        if (m.matches()) {
            pos.put("distro", m.group(1));
            pos.put("versions", m.group(2));
        } else {
            pos.put("distro", os);
            pos.put("versions", "");
        }
        return pos;
    }

    public Set<String> findTypes(String os) {
        Map<String, String> pos = this.parse_os(os);
        for (String family : this.osMap.keySet()) {
            JsonOsFamilyEntry fam = this.osMap.get(family);
            if (!fam.getDistro().contains(pos.get("distro")) || !fam.getVersions().contains(pos.get("versions"))) continue;
            HashSet<CallSite> data = new HashSet<CallSite>();
            for (String item : fam.getDistro()) {
                data.add((CallSite)((Object)(item + pos.get("versions"))));
            }
            return Collections.unmodifiableSet(data);
        }
        return Collections.emptySet();
    }

    public String find(String os) {
        Map<String, String> pos = this.parse_os(os);
        for (String family : this.osMap.keySet()) {
            JsonOsFamilyEntry fam = this.osMap.get(family);
            if (!fam.getDistro().contains(pos.get("distro")) || !fam.getVersions().contains(pos.get("versions"))) continue;
            return family + pos.get("versions");
        }
        return null;
    }

    public String find_family(String os) {
        Map<String, String> pos = this.parse_os(os);
        for (String family : this.osMap.keySet()) {
            JsonOsFamilyEntry fam = this.osMap.get(family);
            if (!fam.getDistro().contains(pos.get("distro")) || !fam.getVersions().contains(pos.get("versions"))) continue;
            return family;
        }
        return null;
    }

    public Set<String> os_list() {
        HashSet<String> r = new HashSet<String>();
        for (String family : this.osMap.keySet()) {
            JsonOsFamilyEntry fam = this.osMap.get(family);
            for (String version : fam.getVersions()) {
                HashSet<CallSite> data = new HashSet<CallSite>();
                for (String item : fam.getDistro()) {
                    data.add((CallSite)((Object)(item + version)));
                }
                r.addAll(data);
            }
        }
        return r;
    }

    public boolean isUbuntuFamily(String osType) {
        return this.isOsInFamily(osType, OS_FAMILY_UBUNTU);
    }

    public boolean isSuseFamily(String osType) {
        return this.isOsInFamily(osType, OS_FAMILY_SUSE);
    }

    public boolean isRedhatFamily(String osType) {
        return this.isOsInFamily(osType, OS_FAMILY_REDHAT);
    }

    public boolean isOsInFamily(String osType, String osFamily) {
        String familyOfOsType = this.find_family(osType);
        return familyOfOsType != null && this.isFamilyExtendedByFamily(familyOfOsType, osFamily);
    }

    private boolean isFamilyExtendedByFamily(String currentFamily, String family) {
        return currentFamily.equals(family) || this.getOsFamilyParent(currentFamily) != null && this.isFamilyExtendedByFamily(this.getOsFamilyParent(currentFamily), family);
    }

    public boolean isVersionedOsFamilyExtendedByVersionedFamily(String currentVersionedFamily, String versionedFamily) {
        Map<String, String> pos = this.parse_os(currentVersionedFamily);
        String currentFamily = pos.get("distro");
        String currentFamilyVersion = pos.get("versions");
        pos = this.parse_os(versionedFamily);
        String family = pos.get("distro");
        String familyVersion = pos.get("versions");
        return currentFamilyVersion.equals(familyVersion) && this.isFamilyExtendedByFamily(currentFamily, family);
    }

    private String getOsFamilyParent(String osFamily) {
        return this.osMap.get(osFamily).getExtendsFamily();
    }

    public Map<String, String> getAliases() {
        return null == this.jsonOsFamily || null == this.jsonOsFamily.getAliases() ? Collections.emptyMap() : this.jsonOsFamily.getAliases();
    }
}

