/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.stack;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.state.UriInfo;
import id.onyx.obdp.server.state.stack.Metric;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MetricDefinition {
    private static final String OVERRIDDEN_HOST_PROP = "overridden_host";
    private String type = null;
    private Map<String, String> properties = null;
    private Map<String, Map<String, Metric>> metrics = null;
    @SerializedName(value="jmx_source_uri")
    private UriInfo jmxSourceUri;

    public MetricDefinition(String type, Map<String, String> properties, Map<String, Map<String, Metric>> metrics) {
        this.type = type;
        this.properties = properties;
        this.metrics = metrics;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="metrics")
    public Map<String, Map<String, Metric>> getMetricsByCategory() {
        return this.metrics;
    }

    @JsonIgnore
    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metricMap = new HashMap<String, Metric>();
        for (Map.Entry<String, Map<String, Metric>> metricMapEntry : this.metrics.entrySet()) {
            metricMap.putAll(metricMapEntry.getValue());
        }
        return metricMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{type=").append(this.type);
        sb.append(";properties=").append(this.properties);
        sb.append(";metric_count=").append(this.getMetrics().size());
        sb.append('}');
        return sb.toString();
    }

    public Optional<String> getOverriddenHosts() {
        return this.properties == null ? Optional.empty() : Optional.ofNullable(this.properties.get(OVERRIDDEN_HOST_PROP));
    }

    public Optional<UriInfo> getJmxSourceUri() {
        return !"jmx".equalsIgnoreCase(this.type) ? Optional.empty() : Optional.ofNullable(this.jmxSourceUri);
    }
}

