/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.stack;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.state.stack.OsFamily;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatestRepoCallable
implements Callable<Void> {
    private static final int LOOKUP_CONNECTION_TIMEOUT = 2000;
    private static final int LOOKUP_READ_TIMEOUT = 3000;
    private static final Logger LOG = LoggerFactory.getLogger(LatestRepoCallable.class);
    private String sourceUri = null;
    private File stackRepoFolder = null;
    private StackInfo stack = null;
    private OsFamily os_family;

    public LatestRepoCallable(String latestSourceUri, File stackRepoFolder, StackInfo stack, OsFamily os_family) {
        this.sourceUri = latestSourceUri;
        this.stackRepoFolder = stackRepoFolder;
        this.stack = stack;
        this.os_family = os_family;
    }

    @Override
    public Void call() throws Exception {
        Type type = new TypeToken<Map<String, Map<String, Object>>>(){}.getType();
        Gson gson = new Gson();
        Map latestUrlMap = null;
        Long time = System.currentTimeMillis();
        try {
            if (this.sourceUri.startsWith("http")) {
                URLStreamProvider streamProvider = new URLStreamProvider(2000, 3000, null, null, null);
                LOG.info("Loading latest URL info for stack {}-{} from {}", new Object[]{this.stack.getName(), this.stack.getVersion(), this.sourceUri});
                latestUrlMap = (Map)gson.fromJson((Reader)new InputStreamReader(streamProvider.readFrom(this.sourceUri)), type);
            } else {
                File jsonFile = null;
                jsonFile = this.sourceUri.charAt(0) == '.' ? new File(this.stackRepoFolder, this.sourceUri) : new File(this.sourceUri);
                if (jsonFile.exists()) {
                    LOG.info("Loading latest URL info for stack {}-{} from {}", new Object[]{this.stack.getName(), this.stack.getVersion(), jsonFile});
                    latestUrlMap = (Map)gson.fromJson((Reader)new FileReader(jsonFile), type);
                }
            }
        }
        catch (Exception e) {
            LOG.info("Could not load the URI for stack {}-{} from {}, ({}).  Using default repository values", new Object[]{this.stack.getName(), this.stack.getVersion(), this.sourceUri, e.getMessage()});
            throw e;
        }
        finally {
            LOG.info("Loaded uri {} in {}ms", (Object)this.sourceUri, (Object)(System.currentTimeMillis() - time));
        }
        StackId stackId = new StackId(this.stack);
        if (latestUrlMap == null || !latestUrlMap.containsKey(stackId.toString())) {
            return null;
        }
        Map map = (Map)latestUrlMap.get(stackId.toString());
        if (null == map) {
            return null;
        }
        HashMap<URI, VersionDefinitionXml> parsedMap = new HashMap<URI, VersionDefinitionXml>();
        if (map.containsKey("manifests")) {
            Map versionMap = (Map)map.get("manifests");
            for (Map.Entry entry : versionMap.entrySet()) {
                Map osMap;
                String version = (String)entry.getKey();
                VersionDefinitionXml xml = this.mergeDefinitions(stackId, version, osMap = (Map)entry.getValue(), parsedMap);
                if (null == xml) continue;
                this.stack.addVersionDefinition(version, xml);
            }
        }
        if (map.containsKey("latest-vdf")) {
            Map osMap = (Map)map.get("latest-vdf");
            VersionDefinitionXml xml = this.mergeDefinitions(stackId, null, osMap, parsedMap);
            xml.setStackDefault(true);
            this.stack.setLatestVersionDefinition(xml);
        }
        return null;
    }

    private VersionDefinitionXml mergeDefinitions(StackId stackId, String version, Map<String, String> osMap, Map<URI, VersionDefinitionXml> parsedMap) throws Exception {
        HashSet<String> oses = new HashSet<String>();
        for (RepositoryInfo ri : this.stack.getRepositories()) {
            if (null == this.os_family.find(ri.getOsType())) continue;
            oses.add(this.os_family.find(ri.getOsType()));
        }
        VersionDefinitionXml.Merger merger = new VersionDefinitionXml.Merger();
        for (Map.Entry<String, String> versionEntry : osMap.entrySet()) {
            String alias;
            String osFamily = this.os_family.find(versionEntry.getKey());
            if (null == osFamily && null != (alias = this.os_family.getAliases().get(versionEntry.getKey()))) {
                osFamily = this.os_family.find(alias);
            }
            if (null == osFamily || !oses.contains(osFamily)) {
                LOG.info("Stack {} cannot resolve OS {} to the supported ones: {}. Family: {}", new Object[]{stackId, versionEntry.getKey(), StringUtils.join(oses, (char)','), osFamily});
                continue;
            }
            String uriString = versionEntry.getValue();
            if ('.' == uriString.charAt(0)) {
                uriString = new File(this.stackRepoFolder, uriString).toURI().toString();
            }
            try {
                URI uri = new URI(uriString);
                VersionDefinitionXml xml = parsedMap.containsKey(uri) ? parsedMap.get(uri) : this.timedVDFLoad(uri);
                version = null == version ? xml.release.version : version;
                merger.add(version, xml);
                if (parsedMap.containsKey(uri)) continue;
                parsedMap.put(uri, xml);
            }
            catch (Exception e) {
                LOG.warn("Could not load version definition for {} identified by {}. {}", new Object[]{stackId, uriString, e.getMessage(), e});
            }
        }
        return merger.merge();
    }

    private String resolveOsUrl(String os, Map<String, String> osMap) {
        if (osMap.containsKey(os)) {
            return osMap.get(os);
        }
        Set<String> possibleTypes = this.os_family.findTypes(os);
        for (String type : possibleTypes) {
            if (!osMap.containsKey(type)) continue;
            return osMap.get(type);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionDefinitionXml timedVDFLoad(URI uri) throws Exception {
        long time = System.currentTimeMillis();
        try {
            VersionDefinitionXml versionDefinitionXml = VersionDefinitionXml.load(uri.toURL());
            return versionDefinitionXml;
        }
        finally {
            LOG.info("Loaded VDF {} in {}ms", (Object)uri, (Object)(System.currentTimeMillis() - time));
        }
    }
}

