/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.services;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPService;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OBDPService
public class RetryUpgradeActionService
extends AbstractScheduledService {
    private static final Logger LOG = LoggerFactory.getLogger(RetryUpgradeActionService.class);
    @Inject
    private Injector m_injector;
    @Inject
    private Provider<Clusters> m_clustersProvider;
    @Inject
    private Configuration m_configuration;
    @Inject
    private HostRoleCommandDAO m_hostRoleCommandDAO;
    private final List<HostRoleStatus> HOLDING_STATUSES = Arrays.asList(HostRoleStatus.HOLDING_FAILED, HostRoleStatus.HOLDING_TIMEDOUT);
    private List<String> CUSTOM_COMMAND_NAMES_TO_IGNORE;
    private List<String> COMMAND_DETAILS_TO_IGNORE;
    private int MAX_TIMEOUT_MINS;
    private Long MAX_TIMEOUT_MS;
    private DateFormat m_fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat m_deltaDateFormat;

    public RetryUpgradeActionService() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        this.m_deltaDateFormat = new SimpleDateFormat("HH:mm:ss");
        this.m_deltaDateFormat.setTimeZone(tz);
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        int secs = this.m_configuration.getStackUpgradeAutoRetryCheckIntervalSecs();
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)secs, (TimeUnit)TimeUnit.SECONDS);
    }

    protected void startUp() throws Exception {
        this.MAX_TIMEOUT_MINS = this.m_configuration.getStackUpgradeAutoRetryTimeoutMins();
        this.MAX_TIMEOUT_MS = (long)this.MAX_TIMEOUT_MINS * 60000L;
        if (this.MAX_TIMEOUT_MINS < 1) {
            LOG.info("Will not start service {} used to auto-retry failed actions during Stack Upgrade since since the property {} is either invalid/missing or set to {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Configuration.STACK_UPGRADE_AUTO_RETRY_TIMEOUT_MINS.getKey(), this.MAX_TIMEOUT_MINS});
            this.stopAsync();
        }
        this.CUSTOM_COMMAND_NAMES_TO_IGNORE = this.m_configuration.getStackUpgradeAutoRetryCustomCommandNamesToIgnore();
        this.COMMAND_DETAILS_TO_IGNORE = this.m_configuration.getStackUpgradeAutoRetryCommandDetailsToIgnore();
    }

    public void setMaxTimeout(int mins) {
        this.MAX_TIMEOUT_MINS = mins;
        this.MAX_TIMEOUT_MS = (long)this.MAX_TIMEOUT_MINS * 60000L;
    }

    protected void runOneIteration() throws Exception {
        Map<String, Cluster> clusterMap = ((Clusters)this.m_clustersProvider.get()).getClusters();
        for (Cluster cluster : clusterMap.values()) {
            try {
                LOG.debug("Analyzing tasks for cluster {} that can be retried during Stack Upgrade.", (Object)cluster.getClusterName());
                Long effectiveRequestId = this.getActiveUpgradeRequestId(cluster);
                if (effectiveRequestId == null) continue;
                LOG.debug("Upgrade is in-progress with request id {}.", (Object)effectiveRequestId);
                this.retryHoldingCommandsInRequest(effectiveRequestId);
            }
            catch (Exception e) {
                LOG.error("Unable to analyze commands that may be retried for cluster with id {}. Exception: {}", (Object)cluster.getClusterId(), (Object)e.getMessage());
            }
        }
    }

    private Long getActiveUpgradeRequestId(Cluster cluster) {
        UpgradeEntity currentUpgrade = cluster.getUpgradeInProgress();
        if (currentUpgrade == null) {
            LOG.debug("There is no active upgrade in progress. Skip retrying failed tasks.");
            return null;
        }
        Direction direction = currentUpgrade.getDirection();
        RepositoryVersionEntity repositoryVersion = currentUpgrade.getRepositoryVersion();
        LOG.debug("Found an active upgrade with id: {}, direction: {}, {} {}", new Object[]{currentUpgrade.getId(), direction, currentUpgrade.getUpgradeType(), direction.getPreposition(), repositoryVersion.getVersion()});
        return currentUpgrade.getRequestId();
    }

    @Transactional
    public void retryHoldingCommandsInRequest(Long requestId) {
        if (requestId == null) {
            return;
        }
        long now = System.currentTimeMillis();
        List<HostRoleCommandEntity> holdingCommands = this.m_hostRoleCommandDAO.findByRequestIdAndStatuses(requestId, this.HOLDING_STATUSES);
        if (holdingCommands.size() > 0) {
            for (HostRoleCommandEntity hrc : holdingCommands) {
                Long retryTimeWindow;
                Long deltaMS;
                LOG.debug("Comparing taskId: {}, attempt count: {}, original start time: {}, now: {}", new Object[]{hrc.getTaskId(), hrc.getAttemptCount(), hrc.getOriginalStartTime(), now});
                if (!this.canRetryCommand(hrc)) continue;
                boolean allowRetry = false;
                if (hrc.getOriginalStartTime() != null && hrc.getOriginalStartTime() > 0L && hrc.getOriginalStartTime() < now && (deltaMS = Long.valueOf((retryTimeWindow = Long.valueOf(hrc.getOriginalStartTime() + this.MAX_TIMEOUT_MS)) - now)) > 0L) {
                    String originalStartTimeString = this.m_fullDateFormat.format(new Date(hrc.getOriginalStartTime()));
                    String deltaString = this.m_deltaDateFormat.format(new Date(deltaMS));
                    LOG.info("Retrying task with id: {}, attempts: {}, original start time: {}, time til timeout: {}", new Object[]{hrc.getTaskId(), hrc.getAttemptCount(), originalStartTimeString, deltaString});
                    allowRetry = true;
                }
                if (!(hrc.getOriginalStartTime() != null && hrc.getOriginalStartTime() != -1L || hrc.getStartTime() != null && hrc.getStartTime() != -1L || hrc.getAttemptCount() != 0)) {
                    LOG.info("Re-scheduling task with id: {} since it has 0 attempts, and null start_time and original_start_time, which likely means the host was not heartbeating when the command was supposed to be scheduled.", (Object)hrc.getTaskId());
                    allowRetry = true;
                }
                if (!allowRetry) continue;
                this.retryHostRoleCommand(hrc);
            }
        }
    }

    private boolean canRetryCommand(HostRoleCommandEntity hrc) {
        if (hrc.isRetryAllowed() && !hrc.isFailureAutoSkipped()) {
            if (null != hrc.getCustomCommandName()) {
                for (String s : this.CUSTOM_COMMAND_NAMES_TO_IGNORE) {
                    if (!hrc.getCustomCommandName().toLowerCase().contains(s)) continue;
                    return false;
                }
            }
            if (null != hrc.getCommandDetail()) {
                for (String s : this.COMMAND_DETAILS_TO_IGNORE) {
                    if (!hrc.getCommandDetail().toLowerCase().contains(s)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void retryHostRoleCommand(HostRoleCommandEntity hrc) {
        try {
            hrc.setStatus(HostRoleStatus.PENDING);
            hrc.setStartTime(-1L);
            hrc.setEndTime(-1L);
            hrc.setLastAttemptTime(-1L);
            this.m_hostRoleCommandDAO.merge(hrc);
        }
        catch (Exception e) {
            LOG.error("Error while updating hostRoleCommand. Entity: {}", (Object)hrc, (Object)e);
            throw e;
        }
    }
}

