/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.services;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import id.onyx.obdp.server.OBDPService;
import id.onyx.obdp.server.alerts.AlertRunnable;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import id.onyx.obdp.server.state.alert.ServerSource;
import id.onyx.obdp.server.state.alert.SourceType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OBDPService
public class OBDPServerAlertService
extends AbstractScheduledService {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPServerAlertService.class);
    @Inject
    private Injector m_injector;
    @Inject
    private AlertDefinitionDAO m_dao;
    @Inject
    private Provider<Clusters> m_clustersProvider;
    @Inject
    private AlertDefinitionFactory m_alertDefinitionFactory;
    private ScheduledExecutorService m_scheduledExecutorService;
    private final Map<String, ScheduledAlert> m_futureMap = new ConcurrentHashMap<String, ScheduledAlert>();

    @Inject
    public void initExecutor(@Named(value="alertServiceCorePoolSize") int alertServiceCorePoolSize) {
        this.m_scheduledExecutorService = Executors.newScheduledThreadPool(alertServiceCorePoolSize);
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)1L, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    protected void startUp() throws Exception {
        Map<String, Cluster> clusterMap = ((Clusters)this.m_clustersProvider.get()).getClusters();
        for (Cluster cluster : clusterMap.values()) {
            for (AlertDefinitionEntity entity : this.m_dao.findBySourceType(cluster.getClusterId(), SourceType.SERVER)) {
                if (!entity.getEnabled()) continue;
                this.scheduleRunnable(entity);
            }
        }
    }

    protected void runOneIteration() throws Exception {
        Map<String, Cluster> clusterMap = ((Clusters)this.m_clustersProvider.get()).getClusters();
        for (Cluster cluster : clusterMap.values()) {
            List<AlertDefinitionEntity> entities = this.m_dao.findBySourceType(cluster.getClusterId(), SourceType.SERVER);
            for (AlertDefinitionEntity entity : entities) {
                String definitionName = entity.getDefinitionName();
                ScheduledAlert scheduledAlert = this.m_futureMap.get(definitionName);
                ScheduledFuture<?> scheduledFuture = null;
                if (null != scheduledAlert) {
                    scheduledFuture = scheduledAlert.getScheduledFuture();
                }
                if (!entity.getEnabled()) {
                    if (null == scheduledFuture) continue;
                    this.unschedule(definitionName, scheduledFuture);
                    continue;
                }
                if (null == scheduledAlert || null == scheduledFuture) {
                    this.scheduleRunnable(entity);
                    continue;
                }
                int scheduledInterval = scheduledAlert.getInterval();
                if (scheduledInterval == entity.getScheduleInterval()) continue;
                this.unschedule(definitionName, scheduledFuture);
                this.scheduleRunnable(entity);
            }
        }
    }

    private void unschedule(String definitionName, ScheduledFuture<?> scheduledFuture) {
        this.m_futureMap.remove(definitionName);
        if (null != scheduledFuture) {
            scheduledFuture.cancel(true);
            LOG.info("Unscheduled server alert {}", (Object)definitionName);
        }
    }

    private void scheduleRunnable(AlertDefinitionEntity entity) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (!entity.getEnabled()) {
            return;
        }
        AlertDefinition definition = this.m_alertDefinitionFactory.coerce(entity);
        ServerSource serverSource = (ServerSource)definition.getSource();
        String sourceClass = serverSource.getSourceClass();
        int interval = definition.getInterval();
        try {
            Class<?> clazz = Class.forName(sourceClass);
            if (!AlertRunnable.class.isAssignableFrom(clazz)) {
                LOG.warn("Unable to schedule a server side alert for {} because it is not an {}", (Object)sourceClass, AlertRunnable.class);
                return;
            }
            Constructor<AlertRunnable> constructor = clazz.asSubclass(AlertRunnable.class).getConstructor(String.class);
            AlertRunnable alertRunnable = constructor.newInstance(entity.getDefinitionName());
            this.m_injector.injectMembers((Object)alertRunnable);
            ScheduledFuture<?> scheduledFuture = this.m_scheduledExecutorService.scheduleWithFixedDelay(alertRunnable, interval, interval, TimeUnit.MINUTES);
            String definitionName = entity.getDefinitionName();
            ScheduledAlert scheduledAlert = new ScheduledAlert(scheduledFuture, interval);
            this.m_futureMap.put(definitionName, scheduledAlert);
            LOG.info("Scheduled server alert {} to run every {} minutes", (Object)definitionName, (Object)interval);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("Unable to schedule a server side alert for {} because it could not be found in the classpath", (Object)sourceClass);
        }
        catch (NoSuchMethodException nsme) {
            LOG.error("Unable to schedule a server side alert for {} because it does not have a constructor which takes the proper arguments.", (Object)sourceClass);
        }
        catch (InvocationTargetException ite) {
            LOG.error("Unable to schedule a server side alert for {} because an exception occurred while constructing the instance.", (Object)sourceClass, (Object)ite);
        }
    }

    private static final class ScheduledAlert {
        private final ScheduledFuture<?> m_scheduledFuture;
        private final int m_interval;

        private ScheduledAlert(ScheduledFuture<?> scheduledFuture, int interval) {
            this.m_scheduledFuture = scheduledFuture;
            this.m_interval = interval;
        }

        private ScheduledFuture<?> getScheduledFuture() {
            return this.m_scheduledFuture;
        }

        private int getInterval() {
            return this.m_interval;
        }
    }
}

