/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.services;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPService;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OBDPService
public class CachedAlertFlushService
extends AbstractScheduledService {
    private static final Logger LOG = LoggerFactory.getLogger(CachedAlertFlushService.class);
    @Inject
    private Configuration m_configuration;
    @Inject
    private AlertsDAO m_alertsDAO;

    protected AbstractScheduledService.Scheduler scheduler() {
        int flushIntervalInMinutes = this.m_configuration.getAlertCacheFlushInterval();
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)flushIntervalInMinutes, (long)flushIntervalInMinutes, (TimeUnit)TimeUnit.MINUTES);
    }

    protected void startUp() throws Exception {
        boolean enabled = this.m_configuration.isAlertCacheEnabled();
        if (!enabled) {
            this.stopAsync();
        }
    }

    protected void runOneIteration() throws Exception {
        try {
            LOG.info("Flushing cached alerts to the database");
            this.m_alertsDAO.flushCachedEntitiesToJPA();
        }
        catch (Exception exception) {
            LOG.error("Unable to flush cached alerts to the database", (Throwable)exception);
        }
    }
}

