/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.services;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPService;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.notifications.DispatchCallback;
import id.onyx.obdp.server.notifications.DispatchCredentials;
import id.onyx.obdp.server.notifications.DispatchFactory;
import id.onyx.obdp.server.notifications.DispatchRunnable;
import id.onyx.obdp.server.notifications.NotificationDispatcher;
import id.onyx.obdp.server.notifications.Recipient;
import id.onyx.obdp.server.orm.dao.AlertDispatchDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.orm.entities.AlertNoticeEntity;
import id.onyx.obdp.server.orm.entities.AlertTargetEntity;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.NotificationState;
import id.onyx.obdp.server.state.alert.AlertNotification;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OBDPService
public class AlertNoticeDispatchService
extends AbstractScheduledService {
    private static final Logger LOG = LoggerFactory.getLogger(AlertNoticeDispatchService.class);
    private static final String VELOCITY_LOG_TAG = "ambari-alerts";
    private static final String AMBARI_ALERT_TEMPLATES = "alert-templates.xml";
    public static final String AMBARI_DISPATCH_CREDENTIAL_USERNAME = "ambari.dispatch.credential.username";
    public static final String AMBARI_DISPATCH_CREDENTIAL_PASSWORD = "ambari.dispatch.credential.password";
    public static final String AMBARI_DISPATCH_RECIPIENTS = "ambari.dispatch.recipients";
    private static final String VELOCITY_AMBARI_KEY = "ambari";
    private static final String VELOCITY_SUMMARY_KEY = "summary";
    private static final String VELOCITY_ALERT_KEY = "alert";
    private static final String VELOCITY_DISPATCH_KEY = "dispatch";
    private final Gson m_gson;
    @Inject
    private AlertDispatchDAO m_dao;
    @Inject
    private DispatchFactory m_dispatchFactory;
    private AlertTemplates m_alertTemplates;
    @Inject
    private Configuration m_configuration;
    @Inject
    private Provider<OBDPMetaInfo> m_metaInfo;
    private Executor m_executor = new ThreadPoolExecutor(0, 2, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new AlertDispatchThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public AlertNoticeDispatchService() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(AlertTargetProperties.class, (Object)new AlertTargetPropertyDeserializer());
        this.m_gson = gsonBuilder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void startUp() throws Exception {
        void var1_5;
        void var1_3;
        super.startUp();
        Object var1_1 = null;
        String alertTemplatesFile = null;
        try {
            alertTemplatesFile = this.m_configuration.getAlertTemplateFile();
            if (null != alertTemplatesFile) {
                File file = new File(alertTemplatesFile);
                FileInputStream fileInputStream = new FileInputStream(file);
            }
        }
        catch (Exception exception) {
            LOG.warn("Unable to load alert template file {}", (Object)alertTemplatesFile, (Object)exception);
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AlertTemplates.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (null == var1_3) {
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(AMBARI_ALERT_TEMPLATES);
            }
            this.m_alertTemplates = (AlertTemplates)unmarshaller.unmarshal((InputStream)var1_5);
            if (null == var1_5) return;
        }
        catch (Exception exception) {
            LOG.error("Unable to load alert template file {}, outbound notifications will not be formatted", (Object)AMBARI_ALERT_TEMPLATES, (Object)exception);
            return;
        }
        finally {
            if (null != var1_3) {
                IOUtils.closeQuietly((InputStream)var1_3);
            }
        }
        IOUtils.closeQuietly((InputStream)var1_5);
        return;
    }

    protected void setExecutor(Executor executor) {
        this.m_executor = executor;
    }

    protected void runOneIteration() throws Exception {
        Map<AlertTargetEntity, List<AlertNoticeEntity>> aggregateMap;
        try {
            aggregateMap = this.getGroupedNotices();
        }
        catch (Exception e) {
            LOG.error("Caught exception during alert notices preparing.", (Throwable)e);
            return;
        }
        Set<AlertTargetEntity> targets = aggregateMap.keySet();
        for (AlertTargetEntity target : targets) {
            List<AlertNoticeEntity> notices = aggregateMap.get(target);
            if (null == notices || notices.size() == 0) continue;
            try {
                String targetType = target.getNotificationType();
                NotificationDispatcher dispatcher = this.m_dispatchFactory.getDispatcher(targetType);
                if (dispatcher.isDigestSupported()) {
                    this.createSingleNotice(dispatcher, target, notices);
                    continue;
                }
                this.createSeparateNotices(dispatcher, target, notices);
            }
            catch (Exception e) {
                LOG.error("Caught exception during Alert Notice dispatching.", (Throwable)e);
            }
        }
    }

    private Map<AlertTargetEntity, List<AlertNoticeEntity>> getGroupedNotices() {
        List<AlertNoticeEntity> pending = this.m_dao.findPendingNotices();
        if (pending.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        LOG.info("There are {} pending alert notices about to be dispatched...", (Object)pending.size());
        HashMap<AlertTargetEntity, List<AlertNoticeEntity>> aggregateMap = new HashMap<AlertTargetEntity, List<AlertNoticeEntity>>(pending.size());
        for (AlertNoticeEntity notice : pending) {
            AlertTargetEntity target = notice.getAlertTarget();
            ArrayList<AlertNoticeEntity> notices = (ArrayList<AlertNoticeEntity>)aggregateMap.get(target);
            if (null == notices) {
                notices = new ArrayList<AlertNoticeEntity>();
                aggregateMap.put(target, notices);
            }
            notice.setNotifyState(NotificationState.DISPATCHED);
            notice = this.m_dao.merge(notice);
            notices.add(notice);
        }
        return aggregateMap;
    }

    private void createSingleNotice(NotificationDispatcher dispatcher, AlertTargetEntity target, List<AlertNoticeEntity> notices) {
        AlertNotification notification = this.buildNotificationFromTarget(target);
        notification.CallbackIds = new ArrayList(notices.size());
        ArrayList<AlertHistoryEntity> histories = new ArrayList<AlertHistoryEntity>(notices.size());
        for (AlertNoticeEntity notice : notices) {
            AlertHistoryEntity history = notice.getAlertHistory();
            histories.add(history);
            notification.CallbackIds.add(notice.getUuid());
        }
        try {
            this.renderDigestNotificationContent(dispatcher, notification, histories, target);
            DispatchRunnable runnable = new DispatchRunnable(dispatcher, notification);
            this.m_executor.execute(runnable);
        }
        catch (Exception exception) {
            LOG.error("Unable to create notification for alerts", (Throwable)exception);
            notification.Callback.onFailure(notification.CallbackIds);
        }
    }

    private void createSeparateNotices(NotificationDispatcher dispatcher, AlertTargetEntity target, List<AlertNoticeEntity> notices) {
        for (AlertNoticeEntity notice : notices) {
            AlertNotification notification = this.buildNotificationFromTarget(target);
            AlertHistoryEntity history = notice.getAlertHistory();
            notification.CallbackIds = Collections.singletonList(notice.getUuid());
            try {
                this.renderNotificationContent(dispatcher, notification, history, target);
                DispatchRunnable runnable = new DispatchRunnable(dispatcher, notification);
                this.m_executor.execute(runnable);
            }
            catch (Exception exception) {
                LOG.error("Unable to create notification for alert", (Throwable)exception);
                notification.Callback.onFailure(notification.CallbackIds);
            }
        }
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)2L, (long)2L, (TimeUnit)TimeUnit.MINUTES);
    }

    private AlertNotification buildNotificationFromTarget(AlertTargetEntity target) {
        String propertiesJson = target.getProperties();
        AlertTargetProperties targetProperties = (AlertTargetProperties)this.m_gson.fromJson(propertiesJson, AlertTargetProperties.class);
        Map<String, String> properties = targetProperties.Properties;
        AlertNotification notification = new AlertNotification();
        notification.Callback = new AlertNoticeDispatchCallback();
        notification.DispatchProperties = properties;
        if (properties.containsKey(AMBARI_DISPATCH_CREDENTIAL_USERNAME) && properties.containsKey(AMBARI_DISPATCH_CREDENTIAL_PASSWORD)) {
            DispatchCredentials credentials = new DispatchCredentials();
            credentials.UserName = properties.get(AMBARI_DISPATCH_CREDENTIAL_USERNAME);
            credentials.Password = properties.get(AMBARI_DISPATCH_CREDENTIAL_PASSWORD);
            notification.Credentials = credentials;
        }
        if (null != targetProperties.Recipients) {
            ArrayList<Recipient> recipients = new ArrayList<Recipient>(targetProperties.Recipients.size());
            for (String stringRecipient : targetProperties.Recipients) {
                Recipient recipient = new Recipient();
                recipient.Identifier = stringRecipient;
                recipients.add(recipient);
            }
            notification.Recipients = recipients;
        }
        return notification;
    }

    private void renderDigestNotificationContent(NotificationDispatcher dispatcher, AlertNotification notification, List<AlertHistoryEntity> histories, AlertTargetEntity target) throws IOException {
        String targetType = target.getNotificationType();
        AmbariInfo ambari = new AmbariInfo((OBDPMetaInfo)this.m_metaInfo.get(), this.m_configuration);
        AlertSummaryInfo summary = new AlertSummaryInfo(histories);
        DispatchInfo dispatch = new DispatchInfo(target);
        StringWriter subjectWriter = new StringWriter();
        StringWriter bodyWriter = new StringWriter();
        AlertTemplate template = this.m_alertTemplates.getTemplate(targetType);
        if (dispatcher.isNotificationContentGenerationRequired()) {
            if (null != template) {
                VelocityContext velocityContext = new VelocityContext();
                velocityContext.put(VELOCITY_AMBARI_KEY, (Object)ambari);
                velocityContext.put(VELOCITY_SUMMARY_KEY, (Object)summary);
                velocityContext.put(VELOCITY_DISPATCH_KEY, (Object)dispatch);
                String subjectTemplate = template.getSubject();
                String bodyTemplate = template.getBody();
                Velocity.evaluate((Context)velocityContext, (Writer)subjectWriter, (String)VELOCITY_LOG_TAG, (String)subjectTemplate);
                Velocity.evaluate((Context)velocityContext, (Writer)bodyWriter, (String)VELOCITY_LOG_TAG, (String)bodyTemplate);
            } else {
                for (AlertHistoryEntity alert : histories) {
                    ((Writer)subjectWriter).write("Apache Ambari Alert Summary");
                    ((Writer)bodyWriter).write(alert.getAlertState().name());
                    ((Writer)bodyWriter).write(" ");
                    ((Writer)bodyWriter).write(alert.getAlertDefinition().getLabel());
                    ((Writer)bodyWriter).write(" ");
                    ((Writer)bodyWriter).write(alert.getAlertText());
                    ((Writer)bodyWriter).write("\n");
                }
            }
        }
        notification.Subject = ((Object)subjectWriter).toString();
        notification.Body = ((Object)bodyWriter).toString();
    }

    private void renderNotificationContent(NotificationDispatcher dispatcher, AlertNotification notification, AlertHistoryEntity history, AlertTargetEntity target) throws IOException {
        String targetType = target.getNotificationType();
        AmbariInfo ambari = new AmbariInfo((OBDPMetaInfo)this.m_metaInfo.get(), this.m_configuration);
        AlertInfo alert = new AlertInfo(history);
        DispatchInfo dispatch = new DispatchInfo(target);
        notification.setAlertInfo(alert);
        StringWriter subjectWriter = new StringWriter();
        StringWriter bodyWriter = new StringWriter();
        AlertTemplate template = this.m_alertTemplates.getTemplate(targetType);
        if (dispatcher.isNotificationContentGenerationRequired()) {
            if (null != template) {
                VelocityContext velocityContext = new VelocityContext();
                velocityContext.put(VELOCITY_AMBARI_KEY, (Object)ambari);
                velocityContext.put(VELOCITY_ALERT_KEY, (Object)alert);
                velocityContext.put(VELOCITY_DISPATCH_KEY, (Object)dispatch);
                String subjectTemplate = template.getSubject();
                String bodyTemplate = template.getBody();
                Velocity.evaluate((Context)velocityContext, (Writer)subjectWriter, (String)VELOCITY_LOG_TAG, (String)subjectTemplate);
                Velocity.evaluate((Context)velocityContext, (Writer)bodyWriter, (String)VELOCITY_LOG_TAG, (String)bodyTemplate);
            } else {
                ((Writer)subjectWriter).write(alert.getAlertState().name());
                ((Writer)subjectWriter).write(" ");
                ((Writer)subjectWriter).write(alert.getAlertName());
                ((Writer)bodyWriter).write(alert.getAlertState().name());
                ((Writer)bodyWriter).write(" ");
                ((Writer)bodyWriter).write(alert.getAlertName());
                ((Writer)bodyWriter).write(" ");
                ((Writer)bodyWriter).write(alert.getAlertText());
                if (alert.hasHostName()) {
                    ((Writer)bodyWriter).write(" ");
                    ((Writer)bodyWriter).append(alert.getHostName());
                }
                ((Writer)bodyWriter).write("\n");
            }
        }
        notification.Subject = ((Object)subjectWriter).toString();
        notification.Body = ((Object)bodyWriter).toString();
    }

    private static final class AlertDispatchThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger s_threadIdPool = new AtomicInteger(1);

        private AlertDispatchThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "alert-dispatch-" + s_threadIdPool.getAndIncrement());
            thread.setDaemon(false);
            thread.setPriority(4);
            return thread;
        }
    }

    private static final class AlertTargetProperties {
        public Map<String, String> Properties;
        public List<String> Recipients;

        private AlertTargetProperties() {
        }
    }

    private static final class AlertTargetPropertyDeserializer
    implements JsonDeserializer<AlertTargetProperties> {
        private AlertTargetPropertyDeserializer() {
        }

        public AlertTargetProperties deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            AlertTargetProperties properties = new AlertTargetProperties();
            properties.Properties = new HashMap<String, String>();
            JsonObject jsonObject = json.getAsJsonObject();
            Set entrySet = jsonObject.entrySet();
            for (Map.Entry entry : entrySet) {
                String entryKey = (String)entry.getKey();
                JsonElement entryValue = (JsonElement)entry.getValue();
                if (entryKey.equals(AlertNoticeDispatchService.AMBARI_DISPATCH_RECIPIENTS)) {
                    Type listType = new TypeToken<List<String>>(){}.getType();
                    JsonArray jsonArray = entryValue.getAsJsonArray();
                    properties.Recipients = (List)context.deserialize((JsonElement)jsonArray, listType);
                    continue;
                }
                properties.Properties.put(entryKey, entryValue.getAsString());
            }
            return properties;
        }
    }

    @XmlRootElement(name="alert-templates")
    private static final class AlertTemplates {
        @XmlElement(name="alert-template", required=true)
        private List<AlertTemplate> m_templates;

        private AlertTemplates() {
        }

        public AlertTemplate getTemplate(String type) {
            for (AlertTemplate template : this.m_templates) {
                if (!type.equals(template.getType())) continue;
                return template;
            }
            return null;
        }
    }

    private final class AlertNoticeDispatchCallback
    implements DispatchCallback {
        private AlertNoticeDispatchCallback() {
        }

        @Override
        public void onSuccess(List<String> callbackIds) {
            for (String callbackId : callbackIds) {
                this.updateAlertNotice(callbackId, NotificationState.DELIVERED);
            }
        }

        @Override
        public void onFailure(List<String> callbackIds) {
            for (String callbackId : callbackIds) {
                this.updateAlertNotice(callbackId, NotificationState.FAILED);
            }
        }

        private void updateAlertNotice(String uuid, NotificationState state) {
            try {
                AlertNoticeEntity entity = AlertNoticeDispatchService.this.m_dao.findNoticeByUuid(uuid);
                if (null == entity) {
                    LOG.warn("Unable to find an alert notice with UUID {}", (Object)uuid);
                    return;
                }
                entity.setNotifyState(state);
                AlertNoticeDispatchService.this.m_dao.merge(entity);
            }
            catch (Exception exception) {
                LOG.error("Unable to update the alert notice with UUID {} to {}, notifications will continue to be sent", new Object[]{uuid, state, exception});
            }
        }
    }

    public static final class AmbariInfo {
        private String m_hostName = null;
        private String m_url = null;
        private String m_version = null;

        protected AmbariInfo(OBDPMetaInfo metaInfo, Configuration m_configuration) {
            this.m_url = m_configuration.getAmbariDisplayUrl();
            this.m_version = metaInfo.getServerVersion();
        }

        public String getHostName() {
            return this.m_hostName;
        }

        public boolean hasUrl() {
            return this.m_url != null;
        }

        public String getUrl() {
            return this.m_url;
        }

        public String getServerVersion() {
            return this.m_version;
        }
    }

    public static final class AlertSummaryInfo {
        private int m_okCount = 0;
        private int m_warningCount = 0;
        private int m_criticalCount = 0;
        private int m_unknownCount = 0;
        private final Set<String> m_hosts = new HashSet<String>();
        private final Set<String> m_services = new HashSet<String>();
        private final List<AlertHistoryEntity> m_alerts;
        private final Map<String, Map<AlertState, List<AlertHistoryEntity>>> m_alertsByServiceAndState = new HashMap<String, Map<AlertState, List<AlertHistoryEntity>>>();
        private final Map<String, Set<String>> m_servicesByState = new HashMap<String, Set<String>>();
        private final Map<String, List<AlertHistoryEntity>> m_alertsByService = new HashMap<String, List<AlertHistoryEntity>>();

        protected AlertSummaryInfo(List<AlertHistoryEntity> histories) {
            this.m_alerts = histories;
            block6: for (AlertHistoryEntity history : this.m_alerts) {
                List<AlertHistoryEntity> alertList;
                Map<AlertState, List<AlertHistoryEntity>> service;
                AlertState alertState = history.getAlertState();
                String serviceName = history.getServiceName();
                String hostName = history.getHostName();
                if (null != hostName) {
                    this.m_hosts.add(hostName);
                }
                if (null != serviceName) {
                    this.m_services.add(serviceName);
                }
                if (null == (service = this.m_alertsByServiceAndState.get(serviceName))) {
                    service = new HashMap<AlertState, List<AlertHistoryEntity>>();
                    this.m_alertsByServiceAndState.put(serviceName, service);
                }
                if (null == (alertList = service.get((Object)alertState))) {
                    alertList = new ArrayList<AlertHistoryEntity>();
                    service.put(alertState, alertList);
                }
                alertList.add(history);
                Set<String> services = this.m_servicesByState.get(alertState.name());
                if (null == services) {
                    services = new HashSet<String>();
                    this.m_servicesByState.put(alertState.name(), services);
                }
                services.add(serviceName);
                List<AlertHistoryEntity> alertsByService = this.m_alertsByService.get(serviceName);
                if (null == alertsByService) {
                    alertsByService = new ArrayList<AlertHistoryEntity>();
                    this.m_alertsByService.put(serviceName, alertsByService);
                }
                alertsByService.add(history);
                switch (alertState) {
                    case CRITICAL: {
                        ++this.m_criticalCount;
                        continue block6;
                    }
                    case OK: {
                        ++this.m_okCount;
                        continue block6;
                    }
                    case UNKNOWN: {
                        ++this.m_unknownCount;
                        continue block6;
                    }
                    case WARNING: {
                        ++this.m_warningCount;
                        continue block6;
                    }
                }
                ++this.m_unknownCount;
            }
        }

        public int getOkCount() {
            return this.m_okCount;
        }

        public int getWarningCount() {
            return this.m_warningCount;
        }

        public int getCriticalCount() {
            return this.m_criticalCount;
        }

        public int getUnknownCount() {
            return this.m_unknownCount;
        }

        public int getTotalCount() {
            return this.m_okCount + this.m_warningCount + this.m_criticalCount + this.m_unknownCount;
        }

        public Set<String> getServices() {
            return this.m_services;
        }

        public List<AlertHistoryEntity> getAlerts() {
            return this.m_alerts;
        }

        public List<AlertHistoryEntity> getAlerts(String serviceName) {
            return this.m_alertsByService.get(serviceName);
        }

        public List<AlertHistoryEntity> getAlerts(String serviceName, String alertState) {
            Map<AlertState, List<AlertHistoryEntity>> serviceAlerts = this.m_alertsByServiceAndState.get(serviceName);
            if (null == serviceAlerts) {
                return null;
            }
            AlertState state = AlertState.valueOf(alertState);
            return serviceAlerts.get((Object)state);
        }

        public Set<String> getServicesByAlertState(String alertState) {
            return this.m_servicesByState.get(alertState);
        }
    }

    public static final class DispatchInfo {
        private String m_targetName;
        private String m_targetDescription;

        protected DispatchInfo(AlertTargetEntity target) {
            this.m_targetName = target.getTargetName();
            this.m_targetDescription = target.getDescription();
        }

        public String getTargetName() {
            return this.m_targetName;
        }

        public String getTargetDescription() {
            return this.m_targetDescription;
        }
    }

    private static final class AlertTemplate {
        @XmlAttribute(name="type", required=true)
        private String m_type;
        @XmlElement(name="subject", required=true)
        private String m_subject;
        @XmlElement(name="body", required=true)
        private String m_body;

        private AlertTemplate() {
        }

        public String getType() {
            return this.m_type;
        }

        public String getSubject() {
            return this.m_subject;
        }

        public String getBody() {
            return this.m_body;
        }
    }

    public static final class AlertInfo {
        private final AlertHistoryEntity m_history;

        public AlertInfo(AlertHistoryEntity history) {
            this.m_history = history;
        }

        public String getHostName() {
            return this.m_history.getHostName();
        }

        public boolean hasHostName() {
            return this.m_history.getHostName() != null;
        }

        public String getServiceName() {
            return this.m_history.getServiceName();
        }

        public String getComponentName() {
            return this.m_history.getComponentName();
        }

        public boolean hasComponentName() {
            return this.m_history.getComponentName() != null;
        }

        public long getAlertTimestamp() {
            return this.m_history.getAlertTimestamp();
        }

        public AlertState getAlertState() {
            return this.m_history.getAlertState();
        }

        public Long getAlertDefinitionId() {
            return this.m_history.getAlertDefinitionId();
        }

        public int getAlertDefinitionHash() {
            return this.m_history.getAlertDefinitionHash();
        }

        public String getAlertName() {
            return this.m_history.getAlertDefinition().getLabel();
        }

        public AlertDefinitionEntity getAlertDefinition() {
            return this.m_history.getAlertDefinition();
        }

        public String getAlertText() {
            return this.m_history.getAlertText();
        }
    }
}

