/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.scheduler;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.controller.RequestScheduleResponse;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.RequestScheduleBatchRequestDAO;
import id.onyx.obdp.server.orm.dao.RequestScheduleDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.RequestScheduleBatchRequestEntity;
import id.onyx.obdp.server.orm.entities.RequestScheduleEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.scheduler.Batch;
import id.onyx.obdp.server.state.scheduler.BatchRequest;
import id.onyx.obdp.server.state.scheduler.BatchRequestResponse;
import id.onyx.obdp.server.state.scheduler.BatchSettings;
import id.onyx.obdp.server.state.scheduler.RequestExecution;
import id.onyx.obdp.server.state.scheduler.Schedule;
import id.onyx.obdp.server.utils.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutionImpl
implements RequestExecution {
    private Cluster cluster;
    private Batch batch;
    private Schedule schedule;
    private RequestScheduleEntity requestScheduleEntity;
    private volatile boolean isPersisted = false;
    @Inject
    private Gson gson;
    @Inject
    private Clusters clusters;
    @Inject
    private RequestScheduleDAO requestScheduleDAO;
    @Inject
    private RequestScheduleBatchRequestDAO batchRequestDAO;
    @Inject
    private ClusterDAO clusterDAO;
    @Inject
    private HostDAO hostDAO;
    private static final Logger LOG = LoggerFactory.getLogger(RequestExecutionImpl.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    @AssistedInject
    public RequestExecutionImpl(@Assisted(value="cluster") Cluster cluster, @Assisted(value="batch") Batch batch, @Assisted(value="schedule") @Nullable Schedule schedule, Injector injector) {
        this.cluster = cluster;
        this.batch = batch;
        this.schedule = schedule;
        injector.injectMembers((Object)this);
        this.requestScheduleEntity = new RequestScheduleEntity();
        this.requestScheduleEntity.setClusterId(cluster.getClusterId());
        this.updateBatchSettings();
        this.updateSchedule();
    }

    @AssistedInject
    public RequestExecutionImpl(@Assisted Cluster cluster, @Assisted RequestScheduleEntity requestScheduleEntity, Injector injector) {
        this.cluster = cluster;
        injector.injectMembers((Object)this);
        this.requestScheduleEntity = requestScheduleEntity;
        this.batch = new Batch();
        this.schedule = new Schedule();
        BatchSettings batchSettings = new BatchSettings();
        batchSettings.setBatchSeparationInSeconds(requestScheduleEntity.getBatchSeparationInSeconds());
        batchSettings.setTaskFailureToleranceLimit(requestScheduleEntity.getBatchTolerationLimit());
        batchSettings.setTaskFailureToleranceLimitPerBatch(requestScheduleEntity.getBatchTolerationLimitPerBatch());
        batchSettings.setPauseAfterFirstBatch(requestScheduleEntity.isPauseAfterFirstBatch());
        this.batch.setBatchSettings(batchSettings);
        Collection<RequestScheduleBatchRequestEntity> batchRequestEntities = requestScheduleEntity.getRequestScheduleBatchRequestEntities();
        if (batchRequestEntities != null) {
            for (RequestScheduleBatchRequestEntity batchRequestEntity : batchRequestEntities) {
                BatchRequest batchRequest = new BatchRequest();
                batchRequest.setOrderId(batchRequestEntity.getBatchId());
                batchRequest.setRequestId(batchRequestEntity.getRequestId());
                if (batchRequestEntity.getRequestBody() != null) {
                    batchRequest.setBody(new String(batchRequestEntity.getRequestBody()));
                }
                batchRequest.setType(BatchRequest.Type.valueOf(batchRequestEntity.getRequestType()));
                batchRequest.setUri(batchRequestEntity.getRequestUri());
                batchRequest.setStatus(batchRequestEntity.getRequestStatus());
                batchRequest.setReturnCode(batchRequestEntity.getReturnCode());
                batchRequest.setResponseMsg(batchRequestEntity.getReturnMessage());
                this.batch.getBatchRequests().add(batchRequest);
            }
        }
        this.schedule.setDayOfWeek(requestScheduleEntity.getDayOfWeek());
        this.schedule.setDaysOfMonth(requestScheduleEntity.getDaysOfMonth());
        this.schedule.setMinutes(requestScheduleEntity.getMinutes());
        this.schedule.setHours(requestScheduleEntity.getHours());
        this.schedule.setMonth(requestScheduleEntity.getMonth());
        this.schedule.setYear(requestScheduleEntity.getYear());
        this.schedule.setStartTime(requestScheduleEntity.getStartTime());
        this.schedule.setEndTime(requestScheduleEntity.getEndTime());
        if (this.schedule.getDayOfWeek() == null && this.schedule.getDaysOfMonth() == null && this.schedule.getMinutes() == null && this.schedule.getHours() == null && this.schedule.getMonth() == null && this.schedule.getYear() == null && this.schedule.getStartTime() == null && this.schedule.getEndTime() == null) {
            this.schedule = null;
        }
        this.isPersisted = true;
    }

    @Override
    public Long getId() {
        return this.requestScheduleEntity.getScheduleId();
    }

    @Override
    public String getClusterName() {
        return this.cluster.getClusterName();
    }

    @Override
    public Batch getBatch() {
        return this.batch;
    }

    @Override
    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    @Override
    public Schedule getSchedule() {
        return this.schedule;
    }

    @Override
    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    @Override
    public RequestScheduleResponse convertToResponse() {
        this.readWriteLock.readLock().lock();
        try {
            RequestScheduleResponse response;
            RequestScheduleResponse requestScheduleResponse = response = new RequestScheduleResponse(this.getId(), this.getClusterName(), this.getDescription(), this.getStatus(), this.getLastExecutionStatus(), this.getBatch(), this.getSchedule(), this.requestScheduleEntity.getCreateUser(), DateUtils.convertToReadableTime(this.requestScheduleEntity.getCreateTimestamp()), this.requestScheduleEntity.getUpdateUser(), DateUtils.convertToReadableTime(this.requestScheduleEntity.getUpdateTimestamp()), this.requestScheduleEntity.getAuthenticatedUserId());
            return requestScheduleResponse;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public void persist() {
        this.readWriteLock.writeLock().lock();
        try {
            if (!this.isPersisted) {
                this.persistEntities();
                this.refresh();
                this.cluster.refresh();
                this.isPersisted = true;
            } else {
                this.saveIfPersisted();
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void refresh() {
        this.readWriteLock.writeLock().lock();
        try {
            if (this.isPersisted) {
                RequestScheduleEntity scheduleEntity = this.requestScheduleDAO.findById(this.requestScheduleEntity.getScheduleId());
                this.requestScheduleDAO.refresh(scheduleEntity);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void delete() {
        this.readWriteLock.writeLock().lock();
        try {
            if (this.isPersisted) {
                this.batchRequestDAO.removeByScheduleId(this.requestScheduleEntity.getScheduleId());
                this.requestScheduleDAO.remove(this.requestScheduleEntity);
                this.cluster.refresh();
                this.isPersisted = false;
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public String getStatus() {
        return this.requestScheduleEntity.getStatus();
    }

    @Override
    public void setDescription(String description) {
        this.requestScheduleEntity.setDescription(description);
    }

    @Override
    public String getDescription() {
        return this.requestScheduleEntity.getDescription();
    }

    @Transactional
    void persistEntities() {
        ClusterEntity clusterEntity = this.clusterDAO.findById(this.cluster.getClusterId());
        this.requestScheduleEntity.setClusterEntity(clusterEntity);
        this.requestScheduleEntity.setCreateTimestamp(System.currentTimeMillis());
        this.requestScheduleEntity.setUpdateTimestamp(System.currentTimeMillis());
        this.requestScheduleDAO.create(this.requestScheduleEntity);
        this.persistRequestMapping();
    }

    @Transactional
    void persistRequestMapping() {
        List<BatchRequest> batchRequests;
        if (this.isPersisted) {
            this.batchRequestDAO.removeByScheduleId(this.requestScheduleEntity.getScheduleId());
            this.requestScheduleEntity.getRequestScheduleBatchRequestEntities().clear();
        }
        if (this.batch != null && (batchRequests = this.batch.getBatchRequests()) != null) {
            Collections.sort(batchRequests);
            for (BatchRequest batchRequest : batchRequests) {
                RequestScheduleBatchRequestEntity batchRequestEntity = new RequestScheduleBatchRequestEntity();
                batchRequestEntity.setBatchId(batchRequest.getOrderId());
                batchRequestEntity.setRequestId(batchRequest.getRequestId());
                batchRequestEntity.setScheduleId(this.requestScheduleEntity.getScheduleId());
                batchRequestEntity.setRequestScheduleEntity(this.requestScheduleEntity);
                batchRequestEntity.setRequestType(batchRequest.getType());
                batchRequestEntity.setRequestUri(batchRequest.getUri());
                batchRequestEntity.setRequestBody(batchRequest.getBody());
                batchRequestEntity.setReturnCode(batchRequest.getReturnCode());
                batchRequestEntity.setReturnMessage(batchRequest.getResponseMsg());
                batchRequestEntity.setRequestStatus(batchRequest.getStatus());
                this.batchRequestDAO.create(batchRequestEntity);
                this.requestScheduleEntity.getRequestScheduleBatchRequestEntities().add(batchRequestEntity);
                this.requestScheduleDAO.merge(this.requestScheduleEntity);
            }
        }
    }

    @Transactional
    void saveIfPersisted() {
        if (this.isPersisted) {
            this.requestScheduleEntity.setUpdateTimestamp(System.currentTimeMillis());
            this.updateBatchSettings();
            this.updateSchedule();
            this.requestScheduleDAO.merge(this.requestScheduleEntity);
            this.persistRequestMapping();
        }
    }

    private void updateBatchSettings() {
        BatchSettings settings;
        if (this.batch != null && (settings = this.batch.getBatchSettings()) != null) {
            this.requestScheduleEntity.setBatchSeparationInSeconds(settings.getBatchSeparationInSeconds());
            this.requestScheduleEntity.setBatchTolerationLimit(settings.getTaskFailureToleranceLimit());
            this.requestScheduleEntity.setBatchTolerationLimitPerBatch(settings.getTaskFailureToleranceLimitPerBatch());
            this.requestScheduleEntity.setPauseAfterFirstBatch(settings.isPauseAfterFirstBatch());
        }
    }

    private void updateSchedule() {
        if (this.schedule != null) {
            this.requestScheduleEntity.setMinutes(this.schedule.getMinutes());
            this.requestScheduleEntity.setHours(this.schedule.getHours());
            this.requestScheduleEntity.setDaysOfMonth(this.schedule.getDaysOfMonth());
            this.requestScheduleEntity.setDayOfWeek(this.schedule.getDayOfWeek());
            this.requestScheduleEntity.setMonth(this.schedule.getMonth());
            this.requestScheduleEntity.setYear(this.schedule.getYear());
            this.requestScheduleEntity.setStartTime(this.schedule.getStartTime());
            this.requestScheduleEntity.setEndTime(this.schedule.getEndTime());
        }
    }

    @Override
    public void setStatus(RequestExecution.Status status) {
        this.requestScheduleEntity.setStatus(status.name());
    }

    @Override
    public void setLastExecutionStatus(String status) {
        this.requestScheduleEntity.setLastExecutionStatus(status);
    }

    @Override
    public void setAuthenticatedUserId(Integer username) {
        this.requestScheduleEntity.setAuthenticatedUserId(username);
    }

    @Override
    public void setCreateUser(String username) {
        this.requestScheduleEntity.setCreateUser(username);
    }

    @Override
    public void setUpdateUser(String username) {
        this.requestScheduleEntity.setUpdateUser(username);
    }

    @Override
    public String getCreateTime() {
        return DateUtils.convertToReadableTime(this.requestScheduleEntity.getCreateTimestamp());
    }

    @Override
    public String getUpdateTime() {
        return DateUtils.convertToReadableTime(this.requestScheduleEntity.getUpdateTimestamp());
    }

    @Override
    public Integer getAuthenticatedUserId() {
        return this.requestScheduleEntity.getAuthenticatedUserId();
    }

    @Override
    public String getCreateUser() {
        return this.requestScheduleEntity.getCreateUser();
    }

    @Override
    public String getUpdateUser() {
        return this.requestScheduleEntity.getUpdateUser();
    }

    @Override
    public String getLastExecutionStatus() {
        return this.requestScheduleEntity.getLastExecutionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestScheduleResponse convertToResponseWithBody() {
        this.readWriteLock.readLock().lock();
        try {
            List<BatchRequest> batchRequests;
            RequestScheduleResponse response = this.convertToResponse();
            Batch batch = response.getBatch();
            if (batch != null && (batchRequests = batch.getBatchRequests()) != null) {
                for (BatchRequest batchRequest : batchRequests) {
                    batchRequest.setBody(this.getRequestBody(batchRequest.getOrderId()));
                }
            }
            RequestScheduleResponse requestScheduleResponse = response;
            return requestScheduleResponse;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public String getRequestBody(Long batchId) {
        Collection<RequestScheduleBatchRequestEntity> requestEntities;
        String body = null;
        if (this.requestScheduleEntity != null && (requestEntities = this.requestScheduleEntity.getRequestScheduleBatchRequestEntities()) != null) {
            for (RequestScheduleBatchRequestEntity requestEntity : requestEntities) {
                if (!requestEntity.getBatchId().equals(batchId)) continue;
                body = requestEntity.getRequestBodyAsString();
            }
        }
        return body;
    }

    @Override
    public Collection<Long> getBatchRequestRequestsIDs(long batchId) {
        Collection<RequestScheduleBatchRequestEntity> requestEntities;
        ArrayList<Long> requestIDs = new ArrayList<Long>();
        if (this.requestScheduleEntity != null && (requestEntities = this.requestScheduleEntity.getRequestScheduleBatchRequestEntities()) != null) {
            requestIDs.addAll(requestEntities.stream().filter(requestEntity -> requestEntity.getBatchId().equals(batchId)).map(RequestScheduleBatchRequestEntity::getRequestId).collect(Collectors.toList()));
        }
        return requestIDs;
    }

    @Override
    public BatchRequest getBatchRequest(long batchId) {
        for (BatchRequest batchRequest : this.batch.getBatchRequests()) {
            if (batchId != batchRequest.getOrderId()) continue;
            return batchRequest;
        }
        return null;
    }

    @Override
    public void updateBatchRequest(long batchId, BatchRequestResponse batchRequestResponse, boolean statusOnly) {
        RequestScheduleBatchRequestEntity batchRequestEntity = null;
        for (RequestScheduleBatchRequestEntity entity : this.requestScheduleEntity.getRequestScheduleBatchRequestEntities()) {
            if (entity.getBatchId() != batchId || entity.getScheduleId().longValue() != this.requestScheduleEntity.getScheduleId()) continue;
            batchRequestEntity = entity;
        }
        if (RequestExecution.Status.PAUSED.name().equals(this.getStatus()) && HostRoleStatus.COMPLETED.name().equals(batchRequestResponse.getStatus())) {
            batchRequestResponse.setStatus(HostRoleStatus.ABORTED.name());
        }
        if (batchRequestEntity != null) {
            batchRequestEntity.setRequestStatus(batchRequestResponse.getStatus());
            if (!statusOnly) {
                batchRequestEntity.setReturnCode(batchRequestResponse.getReturnCode());
                batchRequestEntity.setRequestId(batchRequestResponse.getRequestId());
                batchRequestEntity.setReturnMessage(batchRequestResponse.getReturnMessage());
            }
            this.batchRequestDAO.merge(batchRequestEntity);
        }
        BatchRequest batchRequest = this.getBatchRequest(batchId);
        batchRequest.setStatus(batchRequestResponse.getStatus());
        if (!statusOnly) {
            batchRequest.setReturnCode(batchRequestResponse.getReturnCode());
            batchRequest.setResponseMsg(batchRequestResponse.getReturnMessage());
        }
        this.setLastExecutionStatus(batchRequestResponse.getStatus());
        this.requestScheduleDAO.merge(this.requestScheduleEntity);
    }

    @Override
    @Transactional
    public void updateStatus(RequestExecution.Status status) {
        this.setStatus(status);
        if (this.isPersisted) {
            this.requestScheduleEntity.setUpdateTimestamp(System.currentTimeMillis());
            this.requestScheduleDAO.merge(this.requestScheduleEntity);
        } else {
            LOG.warn("Updated status in memory, since Request Schedule is not persisted.");
        }
    }
}

