/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.repository;

import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.repository.AvailableService;
import id.onyx.obdp.server.state.repository.AvailableServiceReference;
import id.onyx.obdp.server.state.repository.AvailableVersion;
import id.onyx.obdp.server.state.repository.ClusterVersionSummary;
import id.onyx.obdp.server.state.repository.ManifestService;
import id.onyx.obdp.server.state.repository.ManifestServiceInfo;
import id.onyx.obdp.server.state.repository.Release;
import id.onyx.obdp.server.state.repository.ServiceVersionSummary;
import id.onyx.obdp.server.state.repository.StackPackage;
import id.onyx.obdp.server.state.stack.RepositoryXml;
import id.onyx.obdp.spi.RepositoryType;
import id.onyx.obdp.spi.stack.StackReleaseInfo;
import id.onyx.obdp.spi.stack.StackReleaseVersion;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="repository-version")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class VersionDefinitionXml {
    private static final Logger LOG = LoggerFactory.getLogger(VersionDefinitionXml.class);
    public static final String SCHEMA_LOCATION = "version_definition.xsd";
    @XmlElement(name="release")
    public Release release;
    @XmlElementWrapper(name="manifest")
    @XmlElement(name="service")
    List<ManifestService> manifestServices = new ArrayList<ManifestService>();
    @XmlElementWrapper(name="available-services")
    @XmlElement(name="service")
    List<AvailableServiceReference> availableServices = new ArrayList<AvailableServiceReference>();
    @XmlElement(name="repository-info")
    public RepositoryXml repositoryInfo;
    @XmlTransient
    public String xsdLocation;
    @XmlTransient
    private Map<String, AvailableService> m_availableMap;
    @XmlTransient
    private List<ManifestServiceInfo> m_manifest = null;
    @XmlTransient
    private boolean m_stackDefault = false;
    @XmlTransient
    private Map<String, String> m_packageVersions = null;

    public synchronized Collection<AvailableService> getAvailableServices(StackInfo stack) {
        block4: {
            if (null != this.m_availableMap) break block4;
            Map<String, ManifestService> manifests = this.buildManifest();
            this.m_availableMap = new HashMap<String, AvailableService>();
            if (this.availableServices.isEmpty()) {
                for (ManifestService ms : manifests.values()) {
                    this.addToAvailable(ms, stack, Collections.emptySet());
                }
            } else {
                for (AvailableServiceReference ref : this.availableServices) {
                    ManifestService ms = manifests.get(ref.serviceIdReference);
                    this.addToAvailable(ms, stack, ref.components);
                }
            }
        }
        return this.m_availableMap.values();
    }

    private Set<String> getAvailableServiceNames() {
        if (this.availableServices.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> serviceNames = new HashSet<String>();
        Map<String, ManifestService> manifest = this.buildManifest();
        for (AvailableServiceReference ref : this.availableServices) {
            ManifestService ms = manifest.get(ref.serviceIdReference);
            serviceNames.add(ms.serviceName);
        }
        return serviceNames;
    }

    public void setStackDefault(boolean stackDefault) {
        this.m_stackDefault = stackDefault;
    }

    public boolean isStackDefault() {
        return this.m_stackDefault;
    }

    public synchronized List<ManifestServiceInfo> getStackServices(StackInfo stack) {
        if (null != this.m_manifest) {
            return this.m_manifest;
        }
        HashMap manifestVersions = new HashMap();
        for (ManifestService manifest : this.manifestServices) {
            String name = manifest.serviceName;
            if (!manifestVersions.containsKey(name)) {
                manifestVersions.put(manifest.serviceName, new TreeSet());
            }
            ((Set)manifestVersions.get(manifest.serviceName)).add(manifest.version);
        }
        this.m_manifest = new ArrayList<ManifestServiceInfo>();
        for (ServiceInfo si : stack.getServices()) {
            Set<String> versions = manifestVersions.containsKey(si.getName()) ? (Set<String>)manifestVersions.get(si.getName()) : Collections.singleton(null == si.getVersion() ? "" : si.getVersion());
            this.m_manifest.add(new ManifestServiceInfo(si.getName(), si.getDisplayName(), si.getComment(), versions));
        }
        return this.m_manifest;
    }

    public String getPackageVersion(String osFamily) {
        if (null == this.m_packageVersions) {
            this.m_packageVersions = new HashMap<String, String>();
            for (RepositoryXml.Os os : this.repositoryInfo.getOses()) {
                this.m_packageVersions.put(os.getFamily(), os.getPackageVersion());
            }
        }
        return this.m_packageVersions.get(osFamily);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXml() throws Exception {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{VersionDefinitionXml.class});
        Marshaller marshaller = ctx.createMarshaller();
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream xsdStream = VersionDefinitionXml.class.getClassLoader().getResourceAsStream(this.xsdLocation);
        if (null == xsdStream) {
            throw new Exception(String.format("Could not load XSD identified by '%s'", this.xsdLocation));
        }
        try {
            Schema schema = factory.newSchema(new StreamSource(xsdStream));
            marshaller.setSchema(schema);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)this.xsdLocation);
            StringWriter w = new StringWriter();
            marshaller.marshal((Object)this, (Writer)w);
            String string = w.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)xsdStream);
        }
    }

    public ClusterVersionSummary getClusterSummary(Cluster cluster, OBDPMetaInfo metaInfo) throws OBDPException {
        Map<String, ManifestService> manifests = this.buildManifestByService();
        Set<String> available = this.getAvailableServiceNames();
        available = available.isEmpty() ? manifests.keySet() : available;
        HashMap<String, ServiceVersionSummary> summaries = new HashMap<String, ServiceVersionSummary>();
        for (String serviceName : available) {
            String summaryReleaseVersion;
            StackReleaseInfo versionToCompare;
            Service service = cluster.getServices().get(serviceName);
            if (null == service) continue;
            ServiceVersionSummary summary = new ServiceVersionSummary();
            summaries.put(service.getName(), summary);
            StackId stackId = service.getDesiredRepositoryVersion().getStackId();
            StackInfo stack = metaInfo.getStack(stackId);
            StackReleaseVersion stackReleaseVersion = stack.getReleaseVersion();
            StackReleaseInfo serviceVersion = stackReleaseVersion.parse(service.getDesiredRepositoryVersion().getVersion());
            ManifestService manifest = manifests.get(serviceName);
            if (StringUtils.isEmpty((String)manifest.releaseVersion)) {
                versionToCompare = this.release.getReleaseInfo();
                summaryReleaseVersion = this.release.version;
            } else {
                versionToCompare = stackReleaseVersion.parse(manifest.releaseVersion);
                summaryReleaseVersion = manifest.releaseVersion;
            }
            summary.setVersions(manifest.version, summaryReleaseVersion);
            if (RepositoryType.STANDARD == this.release.repositoryType) {
                summary.setUpgrade(true);
                continue;
            }
            Comparator comparator = stackReleaseVersion.getComparator();
            if (comparator.compare(versionToCompare, serviceVersion) <= 0) continue;
            summary.setUpgrade(true);
        }
        return new ClusterVersionSummary(summaries);
    }

    public Set<String> getMissingDependencies(Cluster cluster, OBDPMetaInfo metaInfo) throws OBDPException {
        Map stackPackages;
        Set<Object> missingDependencies = Sets.newTreeSet();
        String stackPackagesJson = cluster.getClusterProperty("stack_packages", null);
        if (StringUtils.isEmpty((String)stackPackagesJson)) {
            return missingDependencies;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(StackPackage.UpgradeDependencies.class, (Object)new StackPackage.UpgradeDependencyDeserializer());
        Gson gson = gsonBuilder.create();
        Type type = new TypeToken<Map<String, StackPackage>>(){}.getType();
        try {
            stackPackages = (Map)gson.fromJson(stackPackagesJson, type);
        }
        catch (Exception exception) {
            LOG.warn("Unable to deserialize the stack packages JSON, assuming no service dependencies", (Throwable)exception);
            return missingDependencies;
        }
        StackId stackId = new StackId(this.release.stackId);
        StackPackage stackPackage = (StackPackage)stackPackages.get(stackId.getStackName());
        if (null == stackPackage || null == stackPackage.upgradeDependencies) {
            return missingDependencies;
        }
        Map<String, List<String>> dependencies = stackPackage.upgradeDependencies.dependencies;
        if (null == dependencies || dependencies.isEmpty()) {
            return missingDependencies;
        }
        Map<String, Service> installedServices = cluster.getServices();
        ClusterVersionSummary clusterVersionSummary = this.getClusterSummary(cluster, metaInfo);
        Set<String> servicesInUpgrade = clusterVersionSummary.getAvailableServiceNames();
        Set<String> servicesInRepository = this.getAvailableServiceNames();
        for (String serviceInUpgrade : servicesInUpgrade) {
            List<String> servicesRequired = dependencies.get(serviceInUpgrade);
            if (null == servicesRequired) continue;
            for (String serviceRequired : servicesRequired) {
                if (servicesInRepository.contains(serviceRequired) || !installedServices.containsKey(serviceRequired)) continue;
                missingDependencies.add(serviceRequired);
            }
        }
        missingDependencies = this.getRecursiveDependencies((Set<String>)missingDependencies, dependencies, servicesInUpgrade, installedServices.keySet());
        return missingDependencies;
    }

    Set<String> getRecursiveDependencies(Set<String> missingDependencies, Map<String, List<String>> dependencies, Set<String> servicesInUpgrade, Set<String> installedServices) {
        HashSet results = Sets.newHashSet();
        results.addAll(missingDependencies);
        for (String missingDependency : missingDependencies) {
            if (!dependencies.containsKey(missingDependency)) continue;
            List<String> subDependencies = dependencies.get(missingDependency);
            for (String subDependency : subDependencies) {
                if (missingDependencies.contains(subDependency) || !installedServices.contains(subDependency) || servicesInUpgrade.contains(subDependency)) continue;
                results.add(subDependency);
                results.addAll(this.getRecursiveDependencies(results, dependencies, servicesInUpgrade, installedServices));
            }
        }
        return results;
    }

    private Map<String, ManifestService> buildManifestByService() {
        HashMap<String, ManifestService> manifests = new HashMap<String, ManifestService>();
        for (ManifestService manifest : this.manifestServices) {
            if (manifests.containsKey(manifest.serviceName)) continue;
            manifests.put(manifest.serviceName, manifest);
        }
        return manifests;
    }

    private void addToAvailable(ManifestService manifestService, StackInfo stack, Set<String> components) {
        ServiceInfo service = stack.getService(manifestService.serviceName);
        if (!this.m_availableMap.containsKey(manifestService.serviceName)) {
            String display = null == service ? manifestService.serviceName : service.getDisplayName();
            AvailableService available = new AvailableService(manifestService.serviceName, display);
            this.m_availableMap.put(manifestService.serviceName, available);
        }
        AvailableService as = this.m_availableMap.get(manifestService.serviceName);
        as.getVersions().add(new AvailableVersion(manifestService.version, manifestService.versionId, manifestService.releaseVersion, this.buildComponents(service, components)));
    }

    private Map<String, ManifestService> buildManifest() {
        HashMap<String, ManifestService> normalized = new HashMap<String, ManifestService>();
        for (ManifestService ms : this.manifestServices) {
            normalized.put(ms.serviceId, ms);
        }
        return normalized;
    }

    private Set<AvailableVersion.Component> buildComponents(ServiceInfo service, Set<String> components) {
        HashSet<AvailableVersion.Component> set = new HashSet<AvailableVersion.Component>();
        for (String component : components) {
            ComponentInfo ci = service.getComponentByName(component);
            String display = null == ci ? component : ci.getDisplayName();
            set.add(new AvailableVersion.Component(component, display));
        }
        return set;
    }

    public static VersionDefinitionXml load(URL url) throws Exception {
        InputStream stream = null;
        try {
            stream = url.openStream();
            VersionDefinitionXml versionDefinitionXml = VersionDefinitionXml.load(stream);
            return versionDefinitionXml;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public static VersionDefinitionXml load(String xml) throws Exception {
        return VersionDefinitionXml.load(new ByteArrayInputStream(xml.getBytes("UTF-8")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VersionDefinitionXml load(InputStream stream) throws Exception {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlReader = xmlFactory.createXMLStreamReader(stream);
        xmlReader.nextTag();
        String xsdName = xmlReader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
        if (null == xsdName) {
            throw new IllegalArgumentException("Provided XML does not have a Schema defined using 'noNamespaceSchemaLocation'");
        }
        InputStream xsdStream = VersionDefinitionXml.class.getClassLoader().getResourceAsStream(xsdName);
        if (null == xsdStream) {
            throw new Exception(String.format("Could not load XSD identified by '%s'", xsdName));
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{VersionDefinitionXml.class});
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new StreamSource(xsdStream));
        unmarshaller.setSchema(schema);
        try {
            VersionDefinitionXml xml = (VersionDefinitionXml)unmarshaller.unmarshal(xmlReader);
            xml.xsdLocation = xsdName;
            VersionDefinitionXml versionDefinitionXml = xml;
            return versionDefinitionXml;
        }
        finally {
            IOUtils.closeQuietly((InputStream)xsdStream);
        }
    }

    public static VersionDefinitionXml build(StackInfo stackInfo) {
        VersionDefinitionXml xml = new VersionDefinitionXml();
        xml.m_stackDefault = true;
        xml.release = new Release();
        xml.repositoryInfo = new RepositoryXml();
        xml.xsdLocation = SCHEMA_LOCATION;
        StackId stackId = new StackId(stackInfo.getName(), stackInfo.getVersion());
        xml.release.repositoryType = RepositoryType.STANDARD;
        xml.release.stackId = stackId.toString();
        xml.release.version = stackInfo.getVersion();
        xml.release.releaseNotes = "NONE";
        xml.release.display = stackId.toString();
        for (ServiceInfo si : stackInfo.getServices()) {
            if (!si.isVersionAdvertised()) continue;
            ManifestService ms = new ManifestService();
            ms.serviceName = si.getName();
            ms.version = StringUtils.trimToEmpty((String)si.getVersion());
            ms.serviceId = ms.serviceName + "-" + ms.version.replace(".", "");
            xml.manifestServices.add(ms);
        }
        if (null != stackInfo.getRepositoryXml()) {
            xml.repositoryInfo.getOses().addAll(stackInfo.getRepositoryXml().getOses());
        }
        try {
            xml.toXml();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return xml;
    }

    public static class Merger {
        private VersionDefinitionXml m_xml = new VersionDefinitionXml();
        private boolean m_seeded = false;

        public Merger() {
            this.m_xml.release = new Release();
            this.m_xml.repositoryInfo = new RepositoryXml();
        }

        public void add(String version, VersionDefinitionXml xml) {
            if (!this.m_seeded) {
                this.m_xml.xsdLocation = xml.xsdLocation;
                StackId stackId = new StackId(xml.release.stackId);
                this.m_xml.release.build = null;
                this.m_xml.release.compatibleWith = xml.release.compatibleWith;
                this.m_xml.release.display = stackId.getStackName() + "-" + xml.release.version;
                this.m_xml.release.repositoryType = RepositoryType.STANDARD;
                this.m_xml.release.releaseNotes = xml.release.releaseNotes;
                this.m_xml.release.stackId = xml.release.stackId;
                this.m_xml.release.version = version;
                this.m_xml.manifestServices.addAll(xml.manifestServices);
                this.m_seeded = true;
            }
            this.m_xml.repositoryInfo.getOses().addAll(xml.repositoryInfo.getOses());
        }

        public VersionDefinitionXml merge() {
            return this.m_seeded ? this.m_xml : null;
        }
    }
}

