/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.repository;

import id.onyx.obdp.server.utils.VersionUtils;
import id.onyx.obdp.spi.stack.StackReleaseInfo;
import id.onyx.obdp.spi.stack.StackReleaseVersion;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class DefaultStackVersion
implements StackReleaseVersion {
    public String getFullVersion(StackReleaseInfo info) {
        StringBuilder sb = new StringBuilder(info.getVersion());
        if (StringUtils.isNotBlank((String)info.getBuild())) {
            sb.append('-').append(StringUtils.trim((String)info.getBuild()));
        }
        return sb.toString();
    }

    public Comparator<StackReleaseInfo> getComparator() {
        return new Comparator<StackReleaseInfo>(){

            @Override
            public int compare(StackReleaseInfo o1, StackReleaseInfo o2) {
                return VersionUtils.compareVersionsWithBuild((String)DefaultStackVersion.this.getFullVersion(o1), (String)DefaultStackVersion.this.getFullVersion(o2), (int)4);
            }
        };
    }

    public StackReleaseInfo parse(String versionString) {
        String version = "0";
        String build = "0";
        String[] parts = StringUtils.split((String)versionString, (char)'-');
        if (1 == parts.length) {
            version = parts[0];
        } else if (parts.length > 1) {
            version = parts[0];
            build = parts[1];
        }
        return new StackReleaseInfo(version, "0", build);
    }
}

