/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.quicklinksprofile;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.io.Resources;
import id.onyx.obdp.server.state.quicklinksprofile.Filter;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksFilterDeserializer;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfile;
import java.io.IOException;
import java.net.URL;

public class QuickLinksProfileParser {
    private final ObjectMapper mapper = new ObjectMapper();

    public QuickLinksProfileParser() {
        SimpleModule module = new SimpleModule("Quick Links Parser", new Version(1, 0, 0, null, null, null));
        module.addDeserializer(Filter.class, (JsonDeserializer)new QuickLinksFilterDeserializer());
        this.mapper.registerModule((Module)module);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public QuickLinksProfile parse(byte[] input) throws IOException {
        return (QuickLinksProfile)this.mapper.readValue(input, QuickLinksProfile.class);
    }

    public QuickLinksProfile parse(URL url) throws IOException {
        return this.parse(Resources.toByteArray((URL)url));
    }

    public String encode(QuickLinksProfile profile) throws IOException {
        return this.mapper.writeValueAsString((Object)profile);
    }
}

