/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.quicklinksprofile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.state.quicklinksprofile.Component;
import id.onyx.obdp.server.state.quicklinksprofile.DefaultQuickLinkVisibilityController;
import id.onyx.obdp.server.state.quicklinksprofile.Filter;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfile;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfileEvaluationException;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfileParser;
import id.onyx.obdp.server.state.quicklinksprofile.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class QuickLinksProfileBuilder {
    public static final String NAME = "name";
    public static final String COMPONENTS = "components";
    public static final String FILTERS = "filters";
    public static final Set<String> ALLOWED_FILTER_ATTRIBUTES = ImmutableSet.of((Object)"visible", (Object)"link_name", (Object)"link_url", (Object)"link_attribute");

    public String buildQuickLinksProfile(@Nullable Object globalFiltersRaw, @Nullable Object serviceFiltersRaw) throws QuickLinksProfileEvaluationException {
        try {
            List<Filter> globalFilters = this.buildQuickLinkFilters(globalFiltersRaw);
            List<Service> services = this.buildServices(serviceFiltersRaw);
            QuickLinksProfile profile = QuickLinksProfile.create(globalFilters, services);
            new DefaultQuickLinkVisibilityController(profile);
            return new QuickLinksProfileParser().encode(profile);
        }
        catch (QuickLinksProfileEvaluationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new QuickLinksProfileEvaluationException("Error interpreting quicklinks profile data", ex);
        }
    }

    List<Service> buildServices(@Nullable Object servicesRaw) {
        if (null == servicesRaw) {
            return ImmutableList.of();
        }
        ArrayList<Service> services = new ArrayList<Service>();
        for (Map serviceAsMap : (Collection)servicesRaw) {
            String serviceName = (String)serviceAsMap.get(NAME);
            Object componentsRaw = serviceAsMap.get(COMPONENTS);
            Object filtersRaw = serviceAsMap.get(FILTERS);
            services.add(Service.create(serviceName, this.buildQuickLinkFilters(filtersRaw), this.buildComponents(componentsRaw)));
        }
        return services;
    }

    List<Component> buildComponents(@Nullable Object componentsRaw) {
        if (null == componentsRaw) {
            return ImmutableList.of();
        }
        ArrayList<Component> components = new ArrayList<Component>();
        for (Map componentAsMap : (Collection)componentsRaw) {
            String componentName = (String)componentAsMap.get(NAME);
            Object filtersRaw = componentAsMap.get(FILTERS);
            components.add(Component.create(componentName, this.buildQuickLinkFilters(filtersRaw)));
        }
        return components;
    }

    List<Filter> buildQuickLinkFilters(@Nullable Object filtersRaw) throws ClassCastException, IllegalArgumentException {
        if (null == filtersRaw) {
            return ImmutableList.of();
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Map filterAsMap : (Collection)filtersRaw) {
            Sets.SetView invalidAttributes = Sets.difference(filterAsMap.keySet(), ALLOWED_FILTER_ATTRIBUTES);
            Preconditions.checkArgument((boolean)invalidAttributes.isEmpty(), (String)"%s%s", (Object)"Invalid attribute(s) in filter declaration: ", (Object)invalidAttributes);
            String linkName = (String)filterAsMap.get("link_name");
            String linkUrl = (String)filterAsMap.get("link_url");
            String attributeName = (String)filterAsMap.get("link_attribute");
            boolean visible = Boolean.parseBoolean((String)filterAsMap.get("visible"));
            Preconditions.checkArgument((null == linkName || null == attributeName ? 1 : 0) != 0, (String)"%s link_name: %s, link_attribute: %s", (Object)"A filter is not allowed to declare both link_name and link_attribute at the same time.", (Object)linkName, (Object)attributeName);
            Preconditions.checkArgument((null == linkUrl || null != linkName ? 1 : 0) != 0, (String)"Invalid filter. Link url can only be applied to link name filters. link_url: %s", (Object)linkUrl);
            if (null != linkName) {
                filters.add(Filter.linkNameFilter(linkName, linkUrl, visible));
                continue;
            }
            if (null != attributeName) {
                filters.add(Filter.linkAttributeFilter(attributeName, visible));
                continue;
            }
            filters.add(Filter.acceptAllFilter(visible));
        }
        return filters;
    }
}

