/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.quicklinksprofile;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import id.onyx.obdp.server.state.quicklinksprofile.AcceptAllFilter;
import id.onyx.obdp.server.state.quicklinksprofile.Filter;
import id.onyx.obdp.server.state.quicklinksprofile.LinkAttributeFilter;
import id.onyx.obdp.server.state.quicklinksprofile.LinkNameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

class QuickLinksFilterDeserializer
extends StdDeserializer<Filter> {
    static final String PARSE_ERROR_MESSAGE_AMBIGUOUS_FILTER = "A filter is not allowed to declare both link_name and link_attribute at the same time.";
    static final String PARSE_ERROR_MESSAGE_INVALID_JSON_TAG = "Invalid attribute(s) in filter declaration: ";

    QuickLinksFilterDeserializer() {
        super(Filter.class);
    }

    public Filter deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        ObjectNode root = (ObjectNode)mapper.readTree(parser);
        Class filterClass = null;
        ArrayList<String> invalidAttributes = new ArrayList<String>();
        UnmodifiableIterator unmodifiableIterator = ImmutableList.copyOf((Iterator)root.fieldNames()).iterator();
        block11: while (unmodifiableIterator.hasNext()) {
            String fieldName;
            switch (fieldName = (String)unmodifiableIterator.next()) {
                case "link_attribute": {
                    if (null != filterClass) {
                        throw new JsonParseException(parser, PARSE_ERROR_MESSAGE_AMBIGUOUS_FILTER, parser.getCurrentLocation());
                    }
                    filterClass = LinkAttributeFilter.class;
                    continue block11;
                }
                case "link_name": 
                case "link_url": {
                    if (null != filterClass && !filterClass.equals(LinkNameFilter.class)) {
                        throw new JsonParseException(parser, PARSE_ERROR_MESSAGE_AMBIGUOUS_FILTER, parser.getCurrentLocation());
                    }
                    filterClass = LinkNameFilter.class;
                    continue block11;
                }
                case "visible": {
                    continue block11;
                }
            }
            invalidAttributes.add(fieldName);
        }
        if (!invalidAttributes.isEmpty()) {
            throw new JsonParseException(parser, PARSE_ERROR_MESSAGE_INVALID_JSON_TAG + invalidAttributes, parser.getCurrentLocation());
        }
        if (null == filterClass) {
            filterClass = AcceptAllFilter.class;
        }
        return (Filter)mapper.readValue(root.traverse(), filterClass);
    }
}

