/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.quicklinksprofile;

import id.onyx.obdp.server.state.quicklinksprofile.DefaultQuickLinkVisibilityController;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinkVisibilityController;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfile;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfileEvaluationException;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfileParser;
import id.onyx.obdp.server.state.quicklinksprofile.ShowAllLinksVisibilityController;
import java.io.IOException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickLinkVisibilityControllerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(QuickLinkVisibilityControllerFactory.class);

    public static QuickLinkVisibilityController get(@Nullable String quickLinkProfileJson) {
        if (null == quickLinkProfileJson) {
            LOG.info("No quick link profile is set, will display all quicklinks.");
            return new ShowAllLinksVisibilityController();
        }
        try {
            QuickLinksProfile profile = new QuickLinksProfileParser().parse(quickLinkProfileJson.getBytes());
            return new DefaultQuickLinkVisibilityController(profile);
        }
        catch (QuickLinksProfileEvaluationException | IOException ex) {
            LOG.error("Unable to parse quick link profile json: " + quickLinkProfileJson, (Throwable)ex);
            return new ShowAllLinksVisibilityController();
        }
    }
}

