/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.quicklinksprofile;

import id.onyx.obdp.server.state.quicklinks.Link;
import id.onyx.obdp.server.state.quicklinksprofile.DefaultQuickLinkVisibilityController;
import id.onyx.obdp.server.state.quicklinksprofile.Filter;
import id.onyx.obdp.server.state.quicklinksprofile.LinkAttributeFilter;
import id.onyx.obdp.server.state.quicklinksprofile.LinkNameFilter;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfileEvaluationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class FilterEvaluator {
    private final Map<String, Boolean> linkNameFilters = new HashMap<String, Boolean>();
    private final Set<String> showAttributes = new HashSet<String>();
    private final Set<String> hideAttributes = new HashSet<String>();
    private Optional<Boolean> acceptAllFilter = Optional.empty();

    FilterEvaluator(List<Filter> filters) throws QuickLinksProfileEvaluationException {
        for (Filter filter : DefaultQuickLinkVisibilityController.nullToEmptyList(filters)) {
            if (filter instanceof LinkNameFilter) {
                String linkName = ((LinkNameFilter)filter).getLinkName();
                if (this.linkNameFilters.containsKey(linkName) && this.linkNameFilters.get(linkName).booleanValue() != filter.isVisible()) {
                    throw new QuickLinksProfileEvaluationException("Contradicting filters for link name [" + linkName + "]");
                }
                this.linkNameFilters.put(linkName, filter.isVisible());
                continue;
            }
            if (filter instanceof LinkAttributeFilter) {
                String linkAttribute = ((LinkAttributeFilter)filter).getLinkAttribute();
                if (filter.isVisible()) {
                    this.showAttributes.add(linkAttribute);
                } else {
                    this.hideAttributes.add(linkAttribute);
                }
                if (!this.showAttributes.contains(linkAttribute) || !this.hideAttributes.contains(linkAttribute)) continue;
                throw new QuickLinksProfileEvaluationException("Contradicting filters for link attribute [" + linkAttribute + "]");
            }
            if (this.acceptAllFilter.isPresent() && !this.acceptAllFilter.get().equals(filter.isVisible())) {
                throw new QuickLinksProfileEvaluationException("Contradicting accept-all filters.");
            }
            this.acceptAllFilter = Optional.of(filter.isVisible());
        }
    }

    Optional<Boolean> isVisible(Link quickLink) {
        if (this.linkNameFilters.containsKey(quickLink.getName())) {
            return Optional.of(this.linkNameFilters.get(quickLink.getName()));
        }
        for (String attribute : DefaultQuickLinkVisibilityController.nullToEmptyList(quickLink.getAttributes())) {
            if (!this.hideAttributes.contains(attribute)) continue;
            return Optional.of(false);
        }
        for (String attribute : DefaultQuickLinkVisibilityController.nullToEmptyList(quickLink.getAttributes())) {
            if (!this.showAttributes.contains(attribute)) continue;
            return Optional.of(true);
        }
        return this.acceptAllFilter;
    }
}

