/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.quicklinksprofile;

import com.google.common.collect.Sets;
import id.onyx.obdp.server.state.quicklinks.Link;
import id.onyx.obdp.server.state.quicklinksprofile.Component;
import id.onyx.obdp.server.state.quicklinksprofile.Filter;
import id.onyx.obdp.server.state.quicklinksprofile.FilterEvaluator;
import id.onyx.obdp.server.state.quicklinksprofile.LinkNameFilter;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinkVisibilityController;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfile;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfileEvaluationException;
import id.onyx.obdp.server.state.quicklinksprofile.Service;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQuickLinkVisibilityController
implements QuickLinkVisibilityController {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultQuickLinkVisibilityController.class);
    private final FilterEvaluator globalRules;
    private final Map<String, FilterEvaluator> serviceRules = new HashMap<String, FilterEvaluator>();
    private final Map<Pair<String, String>, FilterEvaluator> componentRules = new HashMap<Pair<String, String>, FilterEvaluator>();
    private final Map<Pair<String, String>, String> urlOverrides = new HashMap<Pair<String, String>, String>();

    public DefaultQuickLinkVisibilityController(QuickLinksProfile profile) throws QuickLinksProfileEvaluationException {
        int filterCount = this.size(profile.getFilters());
        this.globalRules = new FilterEvaluator(profile.getFilters());
        for (Service service : profile.getServices()) {
            filterCount += this.size(service.getFilters());
            this.serviceRules.put(service.getName(), new FilterEvaluator(service.getFilters()));
            for (Component component : service.getComponents()) {
                filterCount += this.size(component.getFilters());
                this.componentRules.put((Pair<String, String>)Pair.of((Object)service.getName(), (Object)component.getName()), new FilterEvaluator(component.getFilters()));
            }
        }
        if (filterCount == 0) {
            throw new QuickLinksProfileEvaluationException("At least one filter must be defined.");
        }
        String globalOverrides = LinkNameFilter.getLinkNameFilters(profile.getFilters().stream()).filter(f -> f.getLinkUrl() != null).map(f -> f.getLinkName() + " -> " + f.getLinkUrl()).collect(Collectors.joining(", "));
        if (!globalOverrides.isEmpty()) {
            LOG.warn("Link url overrides only work on service and component levels. The following global overrides will be ignored: {}", (Object)globalOverrides);
        }
        for (Service service : profile.getServices()) {
            this.urlOverrides.putAll(this.getUrlOverrides(service.getName(), service.getFilters()));
            for (Component component : service.getComponents()) {
                Map<Pair<String, String>, String> componentUrlOverrides = this.getUrlOverrides(service.getName(), component.getFilters());
                Sets.SetView duplicateOverrides = Sets.intersection(this.urlOverrides.keySet(), componentUrlOverrides.keySet());
                if (!duplicateOverrides.isEmpty()) {
                    LOG.warn("Duplicate url overrides in quick links profile: {}", (Object)duplicateOverrides);
                }
                this.urlOverrides.putAll(componentUrlOverrides);
            }
        }
    }

    private Map<Pair<String, String>, String> getUrlOverrides(String serviceName, Collection<Filter> filters) {
        return filters.stream().filter(f -> f instanceof LinkNameFilter && null != ((LinkNameFilter)f).getLinkUrl()).map(f -> {
            LinkNameFilter lnf = (LinkNameFilter)f;
            return Pair.of((Object)Pair.of((Object)serviceName, (Object)lnf.getLinkName()), (Object)lnf.getLinkUrl());
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    @Override
    public Optional<String> getUrlOverride(@Nonnull String service, @Nonnull Link quickLink) {
        return Optional.ofNullable(this.urlOverrides.get(Pair.of((Object)service, (Object)quickLink.getName())));
    }

    @Override
    public boolean isVisible(@Nonnull String service, @Nonnull Link quickLink) {
        Optional<Boolean> componentResult = this.evaluateComponentRules(service, quickLink);
        if (componentResult.isPresent()) {
            return componentResult.get();
        }
        Optional<Boolean> serviceResult = this.evaluateServiceRules(service, quickLink);
        if (serviceResult.isPresent()) {
            return serviceResult.get();
        }
        return this.globalRules.isVisible(quickLink).orElse(false);
    }

    private int size(@Nullable Collection<?> collection) {
        return null == collection ? 0 : collection.size();
    }

    private Optional<Boolean> evaluateComponentRules(@Nonnull String service, @Nonnull Link quickLink) {
        if (null == quickLink.getComponentName()) {
            return Optional.empty();
        }
        FilterEvaluator componentEvaluator = this.componentRules.get(Pair.of((Object)service, (Object)quickLink.getComponentName()));
        return componentEvaluator != null ? componentEvaluator.isVisible(quickLink) : Optional.empty();
    }

    private Optional<Boolean> evaluateServiceRules(@Nonnull String service, @Nonnull Link quickLink) {
        return this.serviceRules.containsKey(service) ? this.serviceRules.get(service).isVisible(quickLink) : Optional.empty();
    }

    static <T> List<T> nullToEmptyList(@Nullable List<T> items) {
        return items != null ? items : Collections.emptyList();
    }
}

