/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.quicklinks;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.state.quicklinks.Link;
import id.onyx.obdp.server.state.quicklinks.Protocol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class QuickLinksConfiguration {
    @JsonProperty(value="protocol")
    private Protocol protocol;
    @JsonProperty(value="links")
    private List<Link> links;

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void mergeWithParent(QuickLinksConfiguration parent) {
        if (parent == null) {
            return;
        }
        if (this.protocol == null) {
            this.protocol = parent.getProtocol();
        }
        if (this.links == null) {
            this.links = parent.getLinks();
        } else if (parent.getLinks() != null) {
            this.links = this.mergeLinks(parent.getLinks(), this.links);
        }
    }

    private List<Link> mergeLinks(List<Link> parentLinks, List<Link> childLinks) {
        HashMap<String, Link> mergedLinks = new HashMap<String, Link>();
        for (Link parentLink : parentLinks) {
            mergedLinks.put(parentLink.getName(), parentLink);
        }
        for (Link childLink : childLinks) {
            if (childLink.getName() == null) continue;
            if (childLink.isRemoved()) {
                mergedLinks.remove(childLink.getName());
                continue;
            }
            Link parentLink = (Link)mergedLinks.get(childLink.getName());
            childLink.mergeWithParent(parentLink);
            mergedLinks.put(childLink.getName(), childLink);
        }
        return new ArrayList<Link>(mergedLinks.values());
    }
}

