/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VariableReplacementHelper {
    private static final Logger LOG = LoggerFactory.getLogger(VariableReplacementHelper.class);
    private static final Pattern PATTERN_VARIABLE = Pattern.compile("\\$\\{(?:([\\w\\-\\.]+)/)?([\\w\\-\\./]+)(?:\\s*\\|\\s*(.+?))?\\}");
    private static final Pattern PATTERN_FUNCTION = Pattern.compile("(\\w+)\\((.*?)\\)");
    private static final Map<String, Function> FUNCTIONS = new HashMap<String, Function>(){
        {
            this.put("each", new EachFunction());
            this.put("toLower", new ToLowerFunction());
            this.put("replace", new ReplaceValue());
            this.put("append", new AppendFunction());
            this.put("principalPrimary", new PrincipalPrimary());
            this.put("stripPort", new StripPort());
        }
    };

    public String replaceVariables(String value, Map<String, Map<String, String>> replacementsMap) throws OBDPRuntimeException {
        if (value != null && replacementsMap != null && !replacementsMap.isEmpty()) {
            boolean replacementPerformed;
            int count = 0;
            do {
                if (++count > 1000) {
                    throw new OBDPRuntimeException(String.format("Circular reference found while replacing variables in %s", value));
                }
                Matcher matcher = PATTERN_VARIABLE.matcher(value);
                StringBuffer sb = new StringBuffer();
                replacementPerformed = false;
                while (matcher.find()) {
                    Map<String, String> replacements;
                    String type = matcher.group(1);
                    String name = matcher.group(2);
                    String function = matcher.group(3);
                    if (name == null || name.isEmpty() || (replacements = type == null ? replacementsMap.get("") : replacementsMap.get(type)) == null || replacements.get(name) == null) continue;
                    String replacement = replacements.get(name);
                    if (function != null) {
                        replacement = this.applyReplacementFunction(function, replacement, replacementsMap);
                    }
                    matcher.appendReplacement(sb, replacement.replace("\\", "\\\\").replace("$", "\\$"));
                    replacementPerformed = true;
                }
                matcher.appendTail(sb);
                value = sb.toString();
            } while (replacementPerformed);
        }
        return value;
    }

    private String applyReplacementFunction(String function, String replacement, Map<String, Map<String, String>> replacementsMap) {
        Function f;
        String name;
        Matcher matcher;
        if (function != null && (matcher = PATTERN_FUNCTION.matcher(function)).matches() && (name = matcher.group(1)) != null && (f = FUNCTIONS.get(name)) != null) {
            String args = matcher.group(2);
            String[] argsList = args.split("(?<!\\\\),");
            for (int i = 0; i < argsList.length; ++i) {
                argsList[i] = argsList[i].trim().replace("\\,", ",");
            }
            return f.perform(argsList, replacement, replacementsMap);
        }
        return replacement;
    }

    private static interface Function {
        public String perform(String[] var1, String var2, Map<String, Map<String, String>> var3);
    }

    private static class StripPort
    implements Function {
        private StripPort() {
        }

        @Override
        public String perform(String[] args, String data, Map<String, Map<String, String>> replacementsMap) {
            if (data == null) {
                return null;
            }
            int semicolonIndex = data.indexOf(":");
            return semicolonIndex == -1 ? data : data.substring(0, semicolonIndex);
        }
    }

    private static class PrincipalPrimary
    implements Function {
        private PrincipalPrimary() {
        }

        @Override
        public String perform(String[] args, String data, Map<String, Map<String, String>> replacementsMap) {
            if (data == null) {
                return null;
            }
            if (data.contains("/")) {
                return data.split("/")[0];
            }
            if (data.contains("@")) {
                return data.split("@")[0];
            }
            return data;
        }
    }

    private static class AppendFunction
    implements Function {
        private AppendFunction() {
        }

        @Override
        public String perform(String[] args, String data, Map<String, Map<String, String>> replacementsMap) {
            if (args == null || args.length != 3) {
                String message = "Invalid number of arguments encountered while processing the 'append' variable replacement function.  The following arguments are expected:\n\t- Configuration specification used to get the initial value\n\t- Delimiter used for parsing the initial value and appending new values\n\t- A flag to indicate whether values should be unique ('true') or not ('false')";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            String configurationSpec = args[0];
            String concatDelimiter = args[1];
            boolean uniqueOnly = Boolean.parseBoolean(args[2]);
            String sourceData = this.getSourceData(replacementsMap, configurationSpec);
            Collection<String> sourceItems = this.parseItems(sourceData, concatDelimiter);
            Collection<String> dataItems = this.parseItems(data, concatDelimiter);
            ArrayList<String> items = new ArrayList<String>();
            if (uniqueOnly) {
                for (String item : sourceItems) {
                    if (items.contains(item)) continue;
                    items.add(item);
                }
                for (String item : dataItems) {
                    if (items.contains(item)) continue;
                    items.add(item);
                }
            } else {
                items.addAll(sourceItems);
                items.addAll(dataItems);
            }
            return StringUtils.join(items, (String)concatDelimiter);
        }

        private Collection<String> parseItems(String delimitedString, String concatDelimiter) {
            ArrayList<String> items = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)delimitedString)) {
                for (String item : delimitedString.split(concatDelimiter)) {
                    if ((item = item.trim()).isEmpty()) continue;
                    items.add(item);
                }
            }
            return items;
        }

        private String getSourceData(Map<String, Map<String, String>> replacementsMap, String configurationSpec) {
            String sourceData = null;
            if (replacementsMap != null && !replacementsMap.isEmpty() && !StringUtils.isEmpty((String)configurationSpec)) {
                Map<String, String> replacements;
                String[] parts = configurationSpec.split("/");
                String type = null;
                String name = null;
                if (parts.length == 2) {
                    type = parts[0];
                    name = parts[1];
                } else if (parts.length == 1) {
                    name = parts[0];
                }
                if (!StringUtils.isEmpty(name) && (replacements = type == null ? replacementsMap.get("") : replacementsMap.get(type)) != null) {
                    sourceData = replacements.get(name);
                }
            }
            return sourceData;
        }
    }

    private static class ToLowerFunction
    implements Function {
        private ToLowerFunction() {
        }

        @Override
        public String perform(String[] args, String data, Map<String, Map<String, String>> replacementsMap) {
            if (data != null) {
                return data.toLowerCase();
            }
            return "";
        }
    }

    private static class ReplaceValue
    implements Function {
        private ReplaceValue() {
        }

        @Override
        public String perform(String[] args, String data, Map<String, Map<String, String>> replacementsMap) {
            if (args == null || args.length != 2) {
                throw new IllegalArgumentException("Invalid number of arguments encountered");
            }
            if (data != null) {
                StringBuffer builder = new StringBuffer();
                String regex = args[0];
                String replacement = args[1];
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(data);
                while (matcher.find()) {
                    matcher.appendReplacement(builder, replacement);
                }
                matcher.appendTail(builder);
                return builder.toString();
            }
            return "";
        }
    }

    private static class EachFunction
    implements Function {
        private EachFunction() {
        }

        @Override
        public String perform(String[] args, String data, Map<String, Map<String, String>> replacementsMap) {
            if (args == null || args.length != 3) {
                throw new IllegalArgumentException("Invalid number of arguments encountered");
            }
            if (data != null) {
                String[] items;
                StringBuilder builder = new StringBuilder();
                String pattern = args[0];
                String concatDelimiter = args[1];
                String dataDelimiter = args[2];
                for (String item : items = data.split(dataDelimiter)) {
                    if (builder.length() > 0) {
                        builder.append(concatDelimiter);
                    }
                    builder.append(String.format(pattern, item));
                }
                return builder.toString();
            }
            return "";
        }
    }
}

