/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

@Singleton
public class KerberosServiceDescriptorFactory
extends AbstractKerberosDescriptorFactory {
    public KerberosServiceDescriptor[] createInstances(File file) throws IOException {
        try {
            return this.createInstances(this.parseFile(file));
        }
        catch (OBDPException e) {
            throw new OBDPException(String.format("An error occurred processing the JSON-formatted file: %s", file.getAbsolutePath()), (Throwable)e);
        }
    }

    public KerberosServiceDescriptor[] createInstances(String json) throws OBDPException {
        try {
            return this.createInstances(this.parseJSON(json));
        }
        catch (OBDPException e) {
            throw new OBDPException("An error occurred processing the JSON-formatted string", (Throwable)e);
        }
    }

    public KerberosServiceDescriptor[] createInstances(Map<String, Object> map) throws OBDPException {
        ArrayList<KerberosServiceDescriptor> descriptors = new ArrayList<KerberosServiceDescriptor>();
        if (map != null) {
            Object servicesData = map.get("services");
            if (servicesData == null) {
                throw new OBDPException("Missing top-level \"services\" property in service-level Kerberos descriptor data");
            }
            if (servicesData instanceof Collection) {
                for (Object serviceData : (Collection)servicesData) {
                    if (!(serviceData instanceof Map)) continue;
                    descriptors.add(new KerberosServiceDescriptor((Map)serviceData));
                }
            } else {
                throw new OBDPException(String.format("Unexpected top-level \"services\" type in service-level Kerberos descriptor data: %s", servicesData.getClass().getName()));
            }
        }
        return descriptors.toArray(new KerberosServiceDescriptor[descriptors.size()]);
    }

    public KerberosServiceDescriptor createInstance(File file, String name) throws IOException {
        try {
            return this.createInstance(this.parseFile(file), name);
        }
        catch (OBDPException e) {
            throw new OBDPException(String.format("An error occurred processing the JSON-formatted file: %s", file.getAbsolutePath()), (Throwable)e);
        }
    }

    public KerberosServiceDescriptor createInstance(Map<String, Object> map, String name) throws OBDPException {
        KerberosServiceDescriptor descriptor = null;
        if (map != null && name != null) {
            Object servicesData = map.get("services");
            if (servicesData == null) {
                throw new OBDPException("Missing top-level \"services\" property in service-level Kerberos descriptor data");
            }
            if (servicesData instanceof Collection) {
                for (Object serviceData : (Collection)servicesData) {
                    Map serviceDataMap;
                    if (!(serviceData instanceof Map) || !name.equalsIgnoreCase((String)(serviceDataMap = (Map)serviceData).get("name"))) continue;
                    descriptor = new KerberosServiceDescriptor(serviceDataMap);
                    break;
                }
            } else {
                throw new OBDPException(String.format("Unexpected top-level \"services\" type in service-level Kerberos descriptor data: %s", servicesData.getClass().getName()));
            }
        }
        return descriptor;
    }

    public KerberosServiceDescriptor createInstance(String name, String json) throws OBDPException {
        return new KerberosServiceDescriptor(name, this.parseJSON(json));
    }

    public KerberosServiceDescriptor createInstance(String name, Map<?, ?> map) throws OBDPException {
        return new KerberosServiceDescriptor(name, map);
    }
}

