/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorContainer;
import id.onyx.obdp.server.state.kerberos.KerberosComponentDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class KerberosServiceDescriptor
extends AbstractKerberosDescriptorContainer {
    public static final String KEY_NAME = "name";
    static final String KEY_PRECONFIGURE = "preconfigure";
    static final String KEY_COMPONENTS = AbstractKerberosDescriptor.Type.COMPONENT.getDescriptorPluralName();
    private Map<String, KerberosComponentDescriptor> components;
    private Boolean preconfigure = null;

    KerberosServiceDescriptor(Map<?, ?> data) {
        this(KerberosServiceDescriptor.getStringValue(data, KEY_NAME), data);
    }

    @Override
    public Collection<? extends AbstractKerberosDescriptorContainer> getChildContainers() {
        return this.components == null ? null : Collections.unmodifiableCollection(this.components.values());
    }

    @Override
    public AbstractKerberosDescriptorContainer getChildContainer(String name) {
        return this.getComponent(name);
    }

    KerberosServiceDescriptor(String name, Map<?, ?> data) {
        super(data);
        this.setName(name);
        if (data != null) {
            Object list = data.get(KEY_COMPONENTS);
            if (list instanceof Collection) {
                for (Object item : (Collection)list) {
                    if (!(item instanceof Map)) continue;
                    this.putComponent(new KerberosComponentDescriptor((Map)item));
                }
            }
            this.setPreconfigure(KerberosServiceDescriptor.getBooleanValue(data, KEY_PRECONFIGURE));
        }
    }

    public Map<String, KerberosComponentDescriptor> getComponents() {
        return this.components;
    }

    public KerberosComponentDescriptor getComponent(String name) {
        return name == null || this.components == null ? null : this.components.get(name);
    }

    public void putComponent(KerberosComponentDescriptor component) {
        if (component != null) {
            String name = component.getName();
            if (name == null) {
                throw new IllegalArgumentException("The component name must not be null");
            }
            if (this.components == null) {
                this.components = new TreeMap<String, KerberosComponentDescriptor>();
            }
            this.components.put(name, component);
            component.setParent(this);
        }
    }

    public void update(KerberosServiceDescriptor updates) {
        Map<String, KerberosComponentDescriptor> updatedComponents;
        if (updates != null && (updatedComponents = updates.getComponents()) != null) {
            for (Map.Entry<String, KerberosComponentDescriptor> entry : updatedComponents.entrySet()) {
                KerberosComponentDescriptor existing = this.getComponent(entry.getKey());
                if (existing == null) {
                    this.putComponent(entry.getValue());
                    continue;
                }
                existing.update(entry.getValue());
            }
        }
        super.update(updates);
    }

    public boolean shouldPreconfigure() {
        return Boolean.TRUE.equals(this.preconfigure);
    }

    public void setPreconfigure(Boolean preconfigure) {
        this.preconfigure = preconfigure;
    }

    @Override
    protected AbstractKerberosDescriptor getDescriptor(AbstractKerberosDescriptor.Type type, String name) {
        if (AbstractKerberosDescriptor.Type.COMPONENT == type) {
            return this.getComponent(name);
        }
        return super.getDescriptor(type, name);
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (this.components != null) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (KerberosComponentDescriptor component : this.components.values()) {
                list.add(component.toMap());
            }
            map.put(KEY_COMPONENTS, list);
        }
        if (this.preconfigure != null) {
            map.put(KEY_PRECONFIGURE, this.preconfigure.toString());
        }
        return map;
    }

    public List<KerberosIdentityDescriptor> getComponentIdentities(String componentName) {
        return this.getComponent(componentName) != null ? KerberosServiceDescriptor.nullToEmpty(this.getComponent(componentName).getIdentities()) : Collections.emptyList();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.components).append((Object)this.preconfigure).toHashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KerberosServiceDescriptor)) {
            return false;
        }
        KerberosServiceDescriptor that = (KerberosServiceDescriptor)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append(this.components, this.components).append((Object)this.preconfigure, (Object)that.preconfigure).isEquals();
    }
}

