/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosPrincipalType;
import java.util.Map;
import java.util.TreeMap;

public class KerberosPrincipalDescriptor
extends AbstractKerberosDescriptor {
    static final String KEY_VALUE = "value";
    static final String KEY_TYPE = "type";
    static final String KEY_CONFIGURATION = "configuration";
    static final String KEY_LOCAL_USERNAME = "local_username";
    private KerberosPrincipalType type = null;
    private String configuration = null;
    private String localUsername = null;

    public KerberosPrincipalDescriptor(String principal, KerberosPrincipalType type, String configuration, String localUsername) {
        this.setName(principal);
        this.setType(type);
        this.setConfiguration(configuration);
        this.setLocalUsername(localUsername);
    }

    public KerberosPrincipalDescriptor(Map<?, ?> data) {
        this(KerberosPrincipalDescriptor.getStringValue(data, KEY_VALUE), KerberosPrincipalDescriptor.getKerberosPrincipalTypeValue(data, KEY_TYPE), KerberosPrincipalDescriptor.getStringValue(data, KEY_CONFIGURATION), KerberosPrincipalDescriptor.getStringValue(data, KEY_LOCAL_USERNAME));
    }

    public String getValue() {
        return this.getName();
    }

    public void setValue(String value) {
        this.setName(value);
    }

    public KerberosPrincipalType getType() {
        return this.type;
    }

    public void setType(KerberosPrincipalType type) {
        this.type = type;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getLocalUsername() {
        return this.localUsername;
    }

    public void setLocalUsername(String localUsername) {
        this.localUsername = localUsername;
    }

    public void update(KerberosPrincipalDescriptor updates) {
        if (updates != null) {
            KerberosPrincipalType updatedType;
            String updatedValue = updates.getValue();
            if (updatedValue != null) {
                this.setValue(updatedValue);
            }
            if ((updatedType = updates.getType()) != null) {
                this.setType(updatedType);
            }
            if ((updatedValue = updates.getConfiguration()) != null) {
                this.setConfiguration(updatedValue);
            }
            if ((updatedValue = updates.getLocalUsername()) != null) {
                this.setLocalUsername(updatedValue);
            }
        }
    }

    @Override
    public Map<String, Object> toMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put(KEY_VALUE, this.getValue());
        map.put(KEY_TYPE, KerberosPrincipalType.translate(this.getType()));
        map.put(KEY_CONFIGURATION, this.getConfiguration());
        map.put(KEY_LOCAL_USERNAME, this.getLocalUsername());
        return map;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode()) + (this.getType() == null ? 0 : this.getType().hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() == KerberosPrincipalDescriptor.class) {
            KerberosPrincipalDescriptor descriptor = (KerberosPrincipalDescriptor)object;
            return super.equals(object) && (this.getConfiguration() == null ? descriptor.getConfiguration() == null : this.getConfiguration().equals(descriptor.getConfiguration())) && (this.getType() == null ? descriptor.getType() == null : this.getType().equals((Object)descriptor.getType()));
        }
        return false;
    }

    private static KerberosPrincipalType getKerberosPrincipalTypeValue(Map<?, ?> map, String key) {
        String type = KerberosPrincipalDescriptor.getStringValue(map, key);
        if (type == null || type.isEmpty()) {
            return null;
        }
        return KerberosPrincipalType.valueOf(type.toUpperCase());
    }
}

