/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptor;
import java.util.Map;
import java.util.TreeMap;

public class KerberosKeytabDescriptor
extends AbstractKerberosDescriptor {
    static final String KEY_FILE = "file";
    static final String KEY_OWNER = "owner";
    static final String KEY_GROUP = "group";
    static final String KEY_CONFIGURATION = "configuration";
    static final String KEY_CACHABLE = "cachable";
    static final String KEY_ACL_NAME = "name";
    static final String KEY_ACL_ACCESS = "access";
    private String ownerName = null;
    private String ownerAccess = null;
    private String groupName = null;
    private String groupAccess = null;
    private String configuration = null;
    private boolean cachable = true;

    public KerberosKeytabDescriptor(String file, String ownerName, String ownerAccess, String groupName, String groupAccess, String configuration, boolean cachable) {
        this.setName(file);
        this.setOwnerName(ownerName);
        this.setOwnerAccess(ownerAccess);
        this.setGroupName(groupName);
        this.setGroupAccess(groupAccess);
        this.setConfiguration(configuration);
        this.setCachable(cachable);
    }

    public KerberosKeytabDescriptor(Map<?, ?> data) {
        this.setName(KerberosKeytabDescriptor.getStringValue(data, KEY_FILE));
        if (data != null) {
            Map map;
            Object object = data.get(KEY_OWNER);
            if (object instanceof Map) {
                map = (Map)object;
                this.setOwnerName(KerberosKeytabDescriptor.getStringValue(map, KEY_ACL_NAME));
                this.setOwnerAccess(KerberosKeytabDescriptor.getStringValue(map, KEY_ACL_ACCESS));
            }
            if ((object = data.get(KEY_GROUP)) instanceof Map) {
                map = (Map)object;
                this.setGroupName(KerberosKeytabDescriptor.getStringValue(map, KEY_ACL_NAME));
                this.setGroupAccess(KerberosKeytabDescriptor.getStringValue(map, KEY_ACL_ACCESS));
            }
            this.setConfiguration(KerberosKeytabDescriptor.getStringValue(data, KEY_CONFIGURATION));
            this.setCachable(!"false".equalsIgnoreCase(KerberosKeytabDescriptor.getStringValue(data, KEY_CACHABLE)));
        }
    }

    public String getFile() {
        return this.getName();
    }

    public void setFile(String file) {
        this.setName(file);
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public String getOwnerAccess() {
        return this.ownerAccess;
    }

    public void setOwnerAccess(String access) {
        this.ownerAccess = access;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String name) {
        this.groupName = name;
    }

    public String getGroupAccess() {
        return this.groupAccess;
    }

    public void setGroupAccess(String access) {
        this.groupAccess = access;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public boolean isCachable() {
        return this.cachable;
    }

    public void setCachable(boolean cachable) {
        this.cachable = cachable;
    }

    public void update(KerberosKeytabDescriptor updates) {
        if (updates != null) {
            String updatedValue = updates.getFile();
            if (updatedValue != null) {
                this.setFile(updatedValue);
            }
            if ((updatedValue = updates.getConfiguration()) != null) {
                this.setConfiguration(updatedValue);
            }
            if ((updatedValue = updates.getOwnerName()) != null) {
                this.setOwnerName(updatedValue);
            }
            if ((updatedValue = updates.getOwnerAccess()) != null) {
                this.setOwnerAccess(updatedValue);
            }
            if ((updatedValue = updates.getGroupName()) != null) {
                this.setGroupName(updatedValue);
            }
            if ((updatedValue = updates.getGroupAccess()) != null) {
                this.setGroupAccess(updatedValue);
            }
        }
    }

    @Override
    public Map<String, Object> toMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String data = this.getFile();
        map.put(KEY_FILE, data);
        TreeMap<String, String> owner = new TreeMap<String, String>();
        data = this.getOwnerName();
        if (data != null) {
            owner.put(KEY_ACL_NAME, data);
        }
        if ((data = this.getOwnerAccess()) != null) {
            owner.put(KEY_ACL_ACCESS, data);
        }
        if (!owner.isEmpty()) {
            map.put(KEY_OWNER, owner);
        }
        TreeMap<String, String> group = new TreeMap<String, String>();
        data = this.getGroupName();
        if (data != null) {
            group.put(KEY_ACL_NAME, data);
        }
        if ((data = this.getGroupAccess()) != null) {
            group.put(KEY_ACL_ACCESS, data);
        }
        if (!group.isEmpty()) {
            map.put(KEY_GROUP, group);
        }
        if ((data = this.getConfiguration()) != null) {
            map.put(KEY_CONFIGURATION, data);
        }
        return map;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode()) + (this.getOwnerName() == null ? 0 : this.getOwnerName().hashCode()) + (this.getOwnerAccess() == null ? 0 : this.getOwnerAccess().hashCode()) + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode()) + (this.getGroupAccess() == null ? 0 : this.getGroupAccess().hashCode()) + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() == KerberosKeytabDescriptor.class) {
            KerberosKeytabDescriptor descriptor = (KerberosKeytabDescriptor)object;
            return super.equals(object) && (this.getConfiguration() == null ? descriptor.getConfiguration() == null : this.getConfiguration().equals(descriptor.getConfiguration())) && (this.getOwnerName() == null ? descriptor.getOwnerName() == null : this.getOwnerName().equals(descriptor.getOwnerName())) && (this.getOwnerAccess() == null ? descriptor.getOwnerAccess() == null : this.getOwnerAccess().equals(descriptor.getOwnerAccess())) && (this.getGroupName() == null ? descriptor.getGroupName() == null : this.getGroupName().equals(descriptor.getGroupName())) && (this.getGroupAccess() == null ? descriptor.getGroupAccess() == null : this.getGroupAccess().equals(descriptor.getGroupAccess()));
        }
        return false;
    }
}

