/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import com.google.common.base.Optional;
import id.onyx.obdp.server.collections.Predicate;
import id.onyx.obdp.server.collections.PredicateUtils;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorContainer;
import id.onyx.obdp.server.state.kerberos.KerberosKeytabDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosPrincipalDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class KerberosIdentityDescriptor
extends AbstractKerberosDescriptor {
    static final String KEY_REFERENCE = "reference";
    static final String KEY_PRINCIPAL = AbstractKerberosDescriptor.Type.PRINCIPAL.getDescriptorName();
    static final String KEY_KEYTAB = AbstractKerberosDescriptor.Type.KEYTAB.getDescriptorName();
    static final String KEY_WHEN = "when";
    private String reference = null;
    private KerberosPrincipalDescriptor principal = null;
    private KerberosKeytabDescriptor keytab = null;
    private Predicate when = null;
    private String path = null;

    public KerberosIdentityDescriptor(String name, String reference, KerberosPrincipalDescriptor principal, KerberosKeytabDescriptor keytab, Predicate when) {
        this.setName(name);
        this.setReference(reference);
        this.setPrincipalDescriptor(principal);
        this.setKeytabDescriptor(keytab);
        this.setWhen(when);
    }

    public KerberosIdentityDescriptor(Map<?, ?> data) {
        this.setName(KerberosIdentityDescriptor.getStringValue(data, "name"));
        this.setReference(KerberosIdentityDescriptor.getStringValue(data, KEY_REFERENCE));
        if (data != null) {
            Object item = data.get(KEY_PRINCIPAL);
            if (item instanceof Map) {
                this.setPrincipalDescriptor(new KerberosPrincipalDescriptor((Map)item));
            }
            if ((item = data.get(KEY_KEYTAB)) instanceof Map) {
                this.setKeytabDescriptor(new KerberosKeytabDescriptor((Map)item));
            }
            if ((item = data.get(KEY_WHEN)) instanceof Map) {
                this.setWhen(PredicateUtils.fromMap((Map)item));
            }
        }
    }

    public String getReference() {
        return this.reference;
    }

    public String getReferenceAbsolutePath() {
        String absolutePath = StringUtils.isEmpty((String)this.reference) ? this.getName() : this.reference;
        if (!StringUtils.isEmpty((String)absolutePath) && !absolutePath.startsWith("/")) {
            AbstractKerberosDescriptor parent;
            String path = this.getPath();
            if (path == null) {
                path = "";
            }
            if (absolutePath.startsWith("..")) {
                AbstractKerberosDescriptor parent2 = this.getParent();
                if (parent2 != null && (parent2 = parent2.getParent()) != null) {
                    absolutePath = absolutePath.replace("..", parent2.getPath());
                }
            } else if (absolutePath.startsWith(".") && (parent = this.getParent()) != null) {
                absolutePath = absolutePath.replace(".", parent.getPath());
            }
        }
        return absolutePath;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public KerberosPrincipalDescriptor getPrincipalDescriptor() {
        return this.principal;
    }

    public void setPrincipalDescriptor(KerberosPrincipalDescriptor principal) {
        this.principal = principal;
        if (this.principal != null) {
            this.principal.setParent(this);
        }
    }

    public KerberosKeytabDescriptor getKeytabDescriptor() {
        return this.keytab;
    }

    public void setKeytabDescriptor(KerberosKeytabDescriptor keytab) {
        this.keytab = keytab;
        if (this.keytab != null) {
            this.keytab.setParent(this);
        }
    }

    public Predicate getWhen() {
        return this.when;
    }

    public void setWhen(Predicate when) {
        this.when = when;
    }

    public boolean shouldInclude(Map<String, Object> context) {
        return this.when == null || this.when.evaluate(context);
    }

    public void update(KerberosIdentityDescriptor updates) {
        if (updates != null) {
            this.setName(updates.getName());
            this.setReference(updates.getReference());
            KerberosPrincipalDescriptor existingPrincipal = this.getPrincipalDescriptor();
            if (existingPrincipal == null) {
                this.setPrincipalDescriptor(updates.getPrincipalDescriptor());
            } else {
                existingPrincipal.update(updates.getPrincipalDescriptor());
            }
            KerberosKeytabDescriptor existingKeytabDescriptor = this.getKeytabDescriptor();
            if (existingKeytabDescriptor == null) {
                this.setKeytabDescriptor(updates.getKeytabDescriptor());
            } else {
                existingKeytabDescriptor.update(updates.getKeytabDescriptor());
            }
            Predicate updatedWhen = updates.getWhen();
            if (updatedWhen != null) {
                this.setWhen(updatedWhen);
            }
        }
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> dataMap = super.toMap();
        if (this.reference != null) {
            dataMap.put(KEY_REFERENCE, this.reference);
        }
        if (this.principal != null) {
            dataMap.put(KEY_PRINCIPAL, this.principal.toMap());
        }
        if (this.keytab != null) {
            dataMap.put(KEY_KEYTAB, this.keytab.toMap());
        }
        if (this.when != null) {
            dataMap.put(KEY_WHEN, PredicateUtils.toMap(this.when));
        }
        return dataMap;
    }

    public Optional<String> getReferencedServiceName() {
        return this.parseServiceName(this.reference).or(this.parseServiceName(this.getName()));
    }

    private Optional<String> parseServiceName(String name) {
        if (name != null && name.startsWith("/") && name.split("/").length > 2) {
            return Optional.of((Object)name.split("/")[1]);
        }
        return Optional.absent();
    }

    public boolean isShared(KerberosIdentityDescriptor that) {
        return this.hasSamePrincipal(that) || this.hasSameKeytab(that);
    }

    private boolean hasSameKeytab(KerberosIdentityDescriptor that) {
        try {
            return this.getKeytabDescriptor().getFile().equals(that.getKeytabDescriptor().getFile());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private boolean hasSamePrincipal(KerberosIdentityDescriptor that) {
        try {
            return this.getPrincipalDescriptor().getValue().equals(that.getPrincipalDescriptor().getValue());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean isReference() {
        String name = this.getName();
        return !StringUtils.isEmpty((String)this.reference) || !StringUtils.isEmpty((String)name) && (name.startsWith("/") || name.startsWith("./"));
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = super.getPath();
        }
        return this.path;
    }

    void setPath(String path) {
        this.path = path;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.getReference() == null ? 0 : this.getReference().hashCode()) + (this.getPrincipalDescriptor() == null ? 0 : this.getPrincipalDescriptor().hashCode()) + (this.getKeytabDescriptor() == null ? 0 : this.getKeytabDescriptor().hashCode()) + (this.getWhen() == null ? 0 : this.getWhen().hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() == KerberosIdentityDescriptor.class) {
            KerberosIdentityDescriptor descriptor = (KerberosIdentityDescriptor)object;
            return super.equals(object) && (this.getReference() == null ? descriptor.getReference() == null : this.getReference().equals(descriptor.getReference())) && (this.getPrincipalDescriptor() == null ? descriptor.getPrincipalDescriptor() == null : this.getPrincipalDescriptor().equals(descriptor.getPrincipalDescriptor())) && (this.getKeytabDescriptor() == null ? descriptor.getKeytabDescriptor() == null : this.getKeytabDescriptor().equals(descriptor.getKeytabDescriptor())) && (this.getWhen() == null ? descriptor.getWhen() == null : this.getWhen().equals(descriptor.getWhen()));
        }
        return false;
    }

    public List<KerberosIdentityDescriptor> findReferences() {
        AbstractKerberosDescriptor root = this.getRoot();
        if (root instanceof AbstractKerberosDescriptorContainer) {
            return this.findIdentityReferences((AbstractKerberosDescriptorContainer)root, this.getPath());
        }
        return null;
    }

    private List<KerberosIdentityDescriptor> findIdentityReferences(AbstractKerberosDescriptorContainer root, String path) {
        Collection<? extends AbstractKerberosDescriptorContainer> children;
        if (root == null) {
            return null;
        }
        ArrayList<KerberosIdentityDescriptor> references = new ArrayList<KerberosIdentityDescriptor>();
        List<KerberosIdentityDescriptor> identityDescriptors = root.getIdentities();
        if (identityDescriptors != null) {
            for (KerberosIdentityDescriptor identityDescriptor : identityDescriptors) {
                String string;
                if (!identityDescriptor.isReference() || StringUtils.isEmpty((String)(string = identityDescriptor.getReferenceAbsolutePath())) || !path.equals(string)) continue;
                references.add(identityDescriptor);
            }
        }
        if (!CollectionUtils.isEmpty(children = root.getChildContainers())) {
            for (AbstractKerberosDescriptorContainer abstractKerberosDescriptorContainer : children) {
                List<KerberosIdentityDescriptor> childReferences = this.findIdentityReferences(abstractKerberosDescriptorContainer, path);
                if (CollectionUtils.isEmpty(childReferences)) continue;
                references.addAll(childReferences);
            }
        }
        return references;
    }
}

