/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import id.onyx.obdp.server.state.kerberos.KerberosComponentDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosConfigurationDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosKeytabDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosPrincipalDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosDescriptorUpdateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosDescriptorUpdateHelper.class);

    public static KerberosDescriptor updateUserKerberosDescriptor(KerberosDescriptor beginningStackKerberosDescriptor, KerberosDescriptor endingStackKerberosDescriptor, KerberosDescriptor userKerberosDescriptor) {
        KerberosDescriptor updated = new KerberosDescriptor(userKerberosDescriptor.toMap());
        updated.setProperties(KerberosDescriptorUpdateHelper.processProperties(beginningStackKerberosDescriptor.getProperties(), endingStackKerberosDescriptor.getProperties(), updated.getProperties()));
        updated.setConfigurations(KerberosDescriptorUpdateHelper.processConfigurations(beginningStackKerberosDescriptor.getConfigurations(), endingStackKerberosDescriptor.getConfigurations(), updated.getConfigurations()));
        updated.setIdentities(KerberosDescriptorUpdateHelper.processIdentities(beginningStackKerberosDescriptor.getIdentities(), endingStackKerberosDescriptor.getIdentities(), updated.getIdentities()));
        updated.setAuthToLocalProperties(KerberosDescriptorUpdateHelper.processAuthToLocalProperties(beginningStackKerberosDescriptor.getAuthToLocalProperties(), endingStackKerberosDescriptor.getAuthToLocalProperties(), updated.getAuthToLocalProperties()));
        updated.setServices(KerberosDescriptorUpdateHelper.processServices(beginningStackKerberosDescriptor.getServices(), endingStackKerberosDescriptor.getServices(), updated.getServices()));
        return updated;
    }

    private static Map<String, KerberosServiceDescriptor> processServices(Map<String, KerberosServiceDescriptor> previousStackServices, Map<String, KerberosServiceDescriptor> newStackServices, Map<String, KerberosServiceDescriptor> userServices) {
        if (userServices == null || userServices.isEmpty() || previousStackServices == null && newStackServices == null) {
            return userServices;
        }
        TreeMap<String, KerberosServiceDescriptor> updatedServices = new TreeMap<String, KerberosServiceDescriptor>();
        if (previousStackServices == null) {
            previousStackServices = Collections.emptyMap();
        }
        if (newStackServices == null) {
            newStackServices = Collections.emptyMap();
        }
        for (Map.Entry<String, KerberosServiceDescriptor> entry : userServices.entrySet()) {
            String name = entry.getKey();
            KerberosServiceDescriptor userValue = entry.getValue();
            if (userValue == null) continue;
            if (newStackServices.containsKey(name)) {
                KerberosServiceDescriptor oldValue = previousStackServices.get(name);
                KerberosServiceDescriptor newValue = newStackServices.get(name);
                LOG.debug("Processing service {} for modifications", (Object)name);
                updatedServices.put(name, KerberosDescriptorUpdateHelper.processService(oldValue, newValue, userValue));
                continue;
            }
            if (previousStackServices.containsKey(name)) {
                LOG.debug("Removing service {} from user-specified Kerberos Descriptor", (Object)name);
                continue;
            }
            LOG.debug("Leaving service {} in user-specified Kerberos Descriptor unchanged since it was user-defined.", (Object)name);
            updatedServices.put(name, userValue);
        }
        return updatedServices;
    }

    private static KerberosServiceDescriptor processService(KerberosServiceDescriptor previousStackService, KerberosServiceDescriptor newStackService, KerberosServiceDescriptor userService) {
        Map<String, KerberosComponentDescriptor> oldServiceComponents;
        KerberosServiceDescriptor updatedService = new KerberosServiceDescriptor(userService.toMap());
        updatedService.setAuthToLocalProperties(KerberosDescriptorUpdateHelper.processAuthToLocalProperties(previousStackService == null ? null : previousStackService.getAuthToLocalProperties(), newStackService == null ? null : newStackService.getAuthToLocalProperties(), updatedService.getAuthToLocalProperties()));
        updatedService.setConfigurations(KerberosDescriptorUpdateHelper.processConfigurations(previousStackService == null ? null : previousStackService.getConfigurations(), newStackService == null ? null : newStackService.getConfigurations(), updatedService.getConfigurations()));
        updatedService.setIdentities(KerberosDescriptorUpdateHelper.processIdentities(previousStackService == null ? null : previousStackService.getIdentities(), newStackService == null ? null : newStackService.getIdentities(), updatedService.getIdentities()));
        Map<String, KerberosComponentDescriptor> userServiceComponents = updatedService.getComponents();
        Map<String, KerberosComponentDescriptor> newServiceComponents = newStackService == null ? null : newStackService.getComponents();
        Map<String, KerberosComponentDescriptor> map = oldServiceComponents = previousStackService == null ? null : previousStackService.getComponents();
        if (newServiceComponents == null) {
            newServiceComponents = Collections.emptyMap();
        }
        if (oldServiceComponents == null) {
            oldServiceComponents = Collections.emptyMap();
        }
        if (userServiceComponents != null) {
            Iterator<Map.Entry<String, KerberosComponentDescriptor>> iterator = userServiceComponents.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, KerberosComponentDescriptor> entry = iterator.next();
                String name = entry.getKey();
                KerberosComponentDescriptor userValue = entry.getValue();
                if (userValue == null) {
                    iterator.remove();
                    continue;
                }
                if (newServiceComponents.containsKey(name)) {
                    KerberosComponentDescriptor oldValue = oldServiceComponents.get(name);
                    KerberosComponentDescriptor newValue = newServiceComponents.get(name);
                    LOG.debug("Processing component {}/{} for modifications", (Object)updatedService.getName(), (Object)name);
                    KerberosDescriptorUpdateHelper.processComponent(oldValue, newValue, userValue);
                    continue;
                }
                LOG.debug("Removing component {}/{} from user-specified Kerberos Descriptor", (Object)updatedService.getName(), (Object)name);
                iterator.remove();
            }
        }
        return updatedService;
    }

    private static KerberosComponentDescriptor processComponent(KerberosComponentDescriptor previousStackComponent, KerberosComponentDescriptor newStackComponent, KerberosComponentDescriptor userComponent) {
        userComponent.setAuthToLocalProperties(KerberosDescriptorUpdateHelper.processAuthToLocalProperties(previousStackComponent == null ? null : previousStackComponent.getAuthToLocalProperties(), newStackComponent == null ? null : newStackComponent.getAuthToLocalProperties(), userComponent.getAuthToLocalProperties()));
        userComponent.setConfigurations(KerberosDescriptorUpdateHelper.processConfigurations(previousStackComponent == null ? null : previousStackComponent.getConfigurations(), newStackComponent == null ? null : newStackComponent.getConfigurations(), userComponent.getConfigurations()));
        userComponent.setIdentities(KerberosDescriptorUpdateHelper.processIdentities(previousStackComponent == null ? null : previousStackComponent.getIdentities(), newStackComponent == null ? null : newStackComponent.getIdentities(), userComponent.getIdentities()));
        return userComponent;
    }

    private static Set<String> processAuthToLocalProperties(Set<String> previousStackAuthToLocalProperties, Set<String> newStackAuthToLocalProperties, Set<String> userAuthToLocalProperties) {
        if (userAuthToLocalProperties == null) {
            return null;
        }
        TreeSet<String> updatedAuthToLocalProperties = new TreeSet<String>(userAuthToLocalProperties);
        if (previousStackAuthToLocalProperties != null) {
            updatedAuthToLocalProperties.removeAll(previousStackAuthToLocalProperties);
        }
        if (newStackAuthToLocalProperties != null) {
            updatedAuthToLocalProperties.addAll(newStackAuthToLocalProperties);
        }
        return updatedAuthToLocalProperties;
    }

    private static List<KerberosIdentityDescriptor> processIdentities(List<KerberosIdentityDescriptor> previousStackIdentities, List<KerberosIdentityDescriptor> newStackIdentities, List<KerberosIdentityDescriptor> userIdentities) {
        if (userIdentities == null || userIdentities.isEmpty() || previousStackIdentities == null && newStackIdentities == null) {
            return userIdentities;
        }
        Map<String, KerberosIdentityDescriptor> previousStackIdentityMap = KerberosDescriptorUpdateHelper.toMap(previousStackIdentities);
        Map<String, KerberosIdentityDescriptor> newStackIdentityMap = KerberosDescriptorUpdateHelper.toMap(newStackIdentities);
        Map<String, KerberosIdentityDescriptor> userStackIdentityMap = KerberosDescriptorUpdateHelper.toMap(userIdentities);
        TreeMap<String, KerberosIdentityDescriptor> updatedIdentities = new TreeMap<String, KerberosIdentityDescriptor>();
        if (previousStackIdentityMap == null) {
            previousStackIdentityMap = Collections.emptyMap();
        }
        if (newStackIdentityMap == null) {
            newStackIdentityMap = Collections.emptyMap();
        }
        for (Map.Entry<String, KerberosIdentityDescriptor> entry : userStackIdentityMap.entrySet()) {
            String name = entry.getKey();
            KerberosIdentityDescriptor userValue = entry.getValue();
            if (userValue == null) continue;
            if (newStackIdentityMap.containsKey(name)) {
                KerberosIdentityDescriptor newValue = newStackIdentityMap.get(name);
                KerberosIdentityDescriptor previousValue = previousStackIdentityMap.get(name);
                updatedIdentities.put(name, KerberosDescriptorUpdateHelper.processIdentity(previousValue, newValue, userValue));
                continue;
            }
            if (previousStackIdentityMap.containsKey(name)) {
                LOG.debug("Removing identity named {} from user-specified Kerberos Descriptor", (Object)name);
                continue;
            }
            LOG.debug("Leaving identity named {} in user-specified Kerberos Descriptor unchanged since it was user-defined.", (Object)name);
            updatedIdentities.put(name, userValue);
        }
        return new ArrayList<KerberosIdentityDescriptor>(updatedIdentities.values());
    }

    private static KerberosIdentityDescriptor processIdentity(KerberosIdentityDescriptor previousStackIdentity, KerberosIdentityDescriptor newStackIdentity, KerberosIdentityDescriptor userIdentity) {
        KerberosIdentityDescriptor updatedValue = new KerberosIdentityDescriptor(newStackIdentity.toMap());
        KerberosPrincipalDescriptor updatedValuePrincipal = updatedValue.getPrincipalDescriptor();
        KerberosKeytabDescriptor updatedValueKeytab = updatedValue.getKeytabDescriptor();
        if (updatedValuePrincipal != null) {
            KerberosPrincipalDescriptor oldValuePrincipal = previousStackIdentity == null ? null : previousStackIdentity.getPrincipalDescriptor();
            String previousValuePrincipalValue = null;
            KerberosPrincipalDescriptor userValuePrincipal = userIdentity.getPrincipalDescriptor();
            String userValuePrincipalValue = null;
            if (oldValuePrincipal != null) {
                previousValuePrincipalValue = oldValuePrincipal.getValue();
            }
            if (userValuePrincipal != null) {
                userValuePrincipalValue = userValuePrincipal.getValue();
            }
            if (userValuePrincipalValue != null && !userValuePrincipalValue.equals(previousValuePrincipalValue)) {
                updatedValuePrincipal.setValue(userValuePrincipalValue);
            }
        }
        if (updatedValueKeytab != null) {
            KerberosKeytabDescriptor oldValueKeytab = previousStackIdentity == null ? null : previousStackIdentity.getKeytabDescriptor();
            String previousValueKeytabFile = null;
            KerberosKeytabDescriptor userValueKeytab = userIdentity.getKeytabDescriptor();
            String userValueKeytabFile = null;
            if (oldValueKeytab != null) {
                previousValueKeytabFile = oldValueKeytab.getFile();
            }
            if (userValueKeytab != null) {
                userValueKeytabFile = userValueKeytab.getFile();
            }
            if (userValueKeytabFile != null && !userValueKeytabFile.equals(previousValueKeytabFile)) {
                updatedValueKeytab.setFile(userValueKeytabFile);
            }
        }
        updatedValue.setWhen(null);
        return updatedValue;
    }

    private static Map<String, KerberosConfigurationDescriptor> processConfigurations(Map<String, KerberosConfigurationDescriptor> previousStackConfigurations, Map<String, KerberosConfigurationDescriptor> newStackConfigurations, Map<String, KerberosConfigurationDescriptor> userConfigurations) {
        if (userConfigurations == null || previousStackConfigurations == null && newStackConfigurations == null) {
            return userConfigurations;
        }
        TreeMap<String, KerberosConfigurationDescriptor> updatedConfigurations = new TreeMap<String, KerberosConfigurationDescriptor>();
        if (previousStackConfigurations == null) {
            previousStackConfigurations = Collections.emptyMap();
        }
        if (newStackConfigurations == null) {
            newStackConfigurations = Collections.emptyMap();
        }
        for (Map.Entry<String, KerberosConfigurationDescriptor> entry : userConfigurations.entrySet()) {
            String name = entry.getKey();
            KerberosConfigurationDescriptor userValue = entry.getValue();
            if (userValue == null) continue;
            if (newStackConfigurations.containsKey(name)) {
                KerberosConfigurationDescriptor oldValue = previousStackConfigurations.get(name);
                KerberosConfigurationDescriptor newValue = newStackConfigurations.get(name);
                LOG.debug("Processing configuration type {} for modifications", (Object)name);
                updatedConfigurations.put(name, KerberosDescriptorUpdateHelper.processConfiguration(oldValue, newValue, userValue));
                continue;
            }
            if (previousStackConfigurations.containsKey(name)) {
                LOG.debug("Removing configuration type {} from user-specified Kerberos Descriptor", (Object)name);
                continue;
            }
            LOG.debug("Leaving configuration type {} in user-specified Kerberos Descriptor unchanged since it was user-defined.", (Object)name);
            updatedConfigurations.put(name, userValue);
        }
        return updatedConfigurations;
    }

    private static KerberosConfigurationDescriptor processConfiguration(KerberosConfigurationDescriptor previousStackConfiguration, KerberosConfigurationDescriptor newStackConfiguration, KerberosConfigurationDescriptor userConfiguration) {
        KerberosConfigurationDescriptor updatedValue = new KerberosConfigurationDescriptor(userConfiguration == null ? null : userConfiguration.toMap());
        Map<String, String> previousValue = previousStackConfiguration == null ? null : previousStackConfiguration.getProperties();
        Map<String, String> newValue = newStackConfiguration == null ? null : newStackConfiguration.getProperties();
        Map<String, String> userValue = updatedValue.getProperties();
        updatedValue.setProperties(KerberosDescriptorUpdateHelper.processProperties(previousValue, newValue, userValue));
        return updatedValue;
    }

    private static Map<String, String> processProperties(Map<String, String> previousStackProperties, Map<String, String> newStackProperties, Map<String, String> userProperties) {
        String name;
        if (previousStackProperties == null && newStackProperties == null) {
            return userProperties;
        }
        TreeMap<String, String> updatedProperties = new TreeMap<String, String>();
        if (userProperties != null) {
            updatedProperties.putAll(userProperties);
        }
        if (previousStackProperties == null) {
            previousStackProperties = Collections.emptyMap();
        }
        if (newStackProperties == null) {
            newStackProperties = Collections.emptyMap();
        }
        for (Map.Entry<String, String> entry : previousStackProperties.entrySet()) {
            name = entry.getKey();
            if (newStackProperties.containsKey(name)) {
                String previousValue = entry.getValue();
                String newValue = newStackProperties.get(name);
                String userValue = (String)updatedProperties.get(name);
                if (!(previousValue == null ? newValue != null : !previousValue.equals(newValue)) || !(previousValue == null ? userValue == null : previousValue.equals(userValue))) continue;
                LOG.debug("Modifying property named {} from user-specified Kerberos Descriptor", (Object)name);
                updatedProperties.put(name, newValue);
                continue;
            }
            LOG.debug("Removing property named {} from user-specified Kerberos Descriptor", (Object)name);
            updatedProperties.remove(name);
        }
        for (Map.Entry<String, String> entry : newStackProperties.entrySet()) {
            name = entry.getKey();
            if (previousStackProperties.containsKey(name) || updatedProperties.containsKey(name)) continue;
            LOG.debug("Adding property named {} to user-specified Kerberos Descriptor", (Object)name);
            updatedProperties.put(name, entry.getValue());
        }
        return updatedProperties;
    }

    private static Map<String, KerberosIdentityDescriptor> toMap(List<KerberosIdentityDescriptor> identities) {
        if (identities == null) {
            return null;
        }
        TreeMap<String, KerberosIdentityDescriptor> map = new TreeMap<String, KerberosIdentityDescriptor>();
        for (KerberosIdentityDescriptor identity : identities) {
            map.put(identity.getName(), identity);
        }
        return map;
    }
}

