/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.Map;

@Singleton
public class KerberosDescriptorFactory
extends AbstractKerberosDescriptorFactory {
    public KerberosDescriptor createInstance(File file) throws IOException {
        try {
            return new KerberosDescriptor(this.parseFile(file));
        }
        catch (OBDPException e) {
            throw new OBDPException(String.format("An error occurred processing the JSON-formatted file: %s", file.getAbsolutePath()), (Throwable)e);
        }
    }

    public KerberosDescriptor createInstance(String json) throws OBDPException {
        try {
            return new KerberosDescriptor(this.parseJSON(json));
        }
        catch (OBDPException e) {
            throw new OBDPException("An error occurred processing the JSON-formatted string", (Throwable)e);
        }
    }

    public KerberosDescriptor createInstance(Map<?, ?> map) {
        return new KerberosDescriptor(map);
    }
}

