/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorContainer;
import id.onyx.obdp.server.state.kerberos.KerberosComponentDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class KerberosDescriptor
extends AbstractKerberosDescriptorContainer {
    public static final String KEY_PROPERTIES = "properties";
    public static final String KEY_SERVICES = AbstractKerberosDescriptor.Type.SERVICE.getDescriptorPluralName();
    private Map<String, String> properties = null;
    private Map<String, KerberosServiceDescriptor> services = null;

    public KerberosDescriptor() {
        this(null);
    }

    KerberosDescriptor(Map<?, ?> data) {
        super(data);
        if (data != null) {
            Object map;
            Object list = data.get(KEY_SERVICES);
            if (list instanceof Collection) {
                for (Object item : (Collection)list) {
                    if (!(item instanceof Map)) continue;
                    this.putService(new KerberosServiceDescriptor((Map)item));
                }
            }
            if ((map = data.get(KEY_PROPERTIES)) instanceof Map) {
                for (Map.Entry entry : ((Map)map).entrySet()) {
                    Object value = entry.getValue();
                    this.putProperty(entry.getKey().toString(), value == null ? null : value.toString());
                }
            }
        }
    }

    @Override
    public Collection<? extends AbstractKerberosDescriptorContainer> getChildContainers() {
        return this.services == null ? null : Collections.unmodifiableCollection(this.services.values());
    }

    @Override
    public AbstractKerberosDescriptorContainer getChildContainer(String name) {
        return this.getService(name);
    }

    public void setServices(Map<String, KerberosServiceDescriptor> services) {
        this.services = services == null ? null : new TreeMap<String, KerberosServiceDescriptor>(services);
    }

    public Map<String, KerberosServiceDescriptor> getServices() {
        return this.services;
    }

    public KerberosServiceDescriptor getService(String name) {
        return name == null || this.services == null ? null : this.services.get(name);
    }

    public void putService(KerberosServiceDescriptor service) {
        if (service != null) {
            KerberosServiceDescriptor existing;
            String name = service.getName();
            if (name == null) {
                throw new IllegalArgumentException("The service name must not be null");
            }
            if (this.services == null) {
                this.services = new TreeMap<String, KerberosServiceDescriptor>();
            }
            if ((existing = this.services.get(name)) == null) {
                this.services.put(name, service);
                service.setParent(this);
            } else {
                existing.update(service);
            }
        }
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties == null ? null : new TreeMap<String, String>(properties);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return name == null || this.properties == null ? null : this.properties.get(name);
    }

    public void putProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("The property name must not be null");
        }
        if (this.properties == null) {
            this.properties = new TreeMap<String, String>();
        }
        this.properties.put(name, value);
    }

    public KerberosDescriptor update(KerberosDescriptor updates) {
        if (updates != null) {
            Map<String, String> updatedProperties;
            Map<String, KerberosServiceDescriptor> updatedServiceDescriptors = updates.getServices();
            if (updatedServiceDescriptors != null) {
                for (Map.Entry<String, KerberosServiceDescriptor> entry : updatedServiceDescriptors.entrySet()) {
                    this.putService(entry.getValue());
                }
            }
            if ((updatedProperties = updates.getProperties()) != null) {
                for (Map.Entry<String, String> entry : updatedProperties.entrySet()) {
                    this.putProperty(entry.getKey(), entry.getValue());
                }
            }
        }
        super.update(updates);
        return this;
    }

    @Override
    protected AbstractKerberosDescriptor getDescriptor(AbstractKerberosDescriptor.Type type, String name) {
        if (AbstractKerberosDescriptor.Type.SERVICE == type) {
            return this.getService(name);
        }
        return super.getDescriptor(type, name);
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (this.services != null) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (KerberosServiceDescriptor service : this.services.values()) {
                list.add(service.toMap());
            }
            map.put(KEY_SERVICES, list);
        }
        if (this.properties != null) {
            map.put(KEY_PROPERTIES, new TreeMap<String, String>(this.properties));
        }
        return map;
    }

    @Override
    public void setParent(AbstractKerberosDescriptor parent) {
        throw new UnsupportedOperationException("This KerberosDescriptor may not have a parent assigned to it.");
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.getProperties() == null ? 0 : this.getProperties().hashCode()) + (this.getServices() == null ? 0 : this.getServices().hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() == KerberosDescriptor.class) {
            KerberosDescriptor descriptor = (KerberosDescriptor)object;
            return super.equals(object) && (this.getProperties() == null ? descriptor.getProperties() == null : this.getProperties().equals(descriptor.getProperties())) && (this.getServices() == null ? descriptor.getServices() == null : this.getServices().equals(descriptor.getServices()));
        }
        return false;
    }

    public Set<String> getAllAuthToLocalProperties() {
        HashSet<String> authToLocalProperties = new HashSet<String>();
        Set<String> set = this.getAuthToLocalProperties();
        if (set != null) {
            authToLocalProperties.addAll(set);
        }
        if (this.services != null) {
            for (KerberosServiceDescriptor service : this.services.values()) {
                Map<String, KerberosComponentDescriptor> components = service.getComponents();
                if (components != null) {
                    for (KerberosComponentDescriptor component : components.values()) {
                        set = component.getAuthToLocalProperties();
                        if (set == null) continue;
                        authToLocalProperties.addAll(set);
                    }
                }
                if ((set = service.getAuthToLocalProperties()) == null) continue;
                authToLocalProperties.addAll(set);
            }
        }
        return authToLocalProperties;
    }

    public Map<String, String> principals() throws OBDPException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (AbstractKerberosDescriptorContainer abstractKerberosDescriptorContainer : KerberosDescriptor.nullToEmpty(this.getChildContainers())) {
            if (!(abstractKerberosDescriptorContainer instanceof KerberosServiceDescriptor)) continue;
            KerberosDescriptor.collectFromComponents(abstractKerberosDescriptorContainer.getName(), KerberosDescriptor.nullToEmpty(((KerberosServiceDescriptor)abstractKerberosDescriptorContainer).getComponents()).values(), result);
            KerberosDescriptor.collectFromIdentities(abstractKerberosDescriptorContainer.getName(), "", KerberosDescriptor.nullToEmpty(abstractKerberosDescriptorContainer.getIdentities()), result);
        }
        return result;
    }

    private static void collectFromComponents(String service, Collection<KerberosComponentDescriptor> components, Map<String, String> result) {
        for (KerberosComponentDescriptor each : components) {
            KerberosDescriptor.collectFromIdentities(service, each.getName(), KerberosDescriptor.nullToEmpty(each.getIdentities()), result);
        }
    }

    private static void collectFromIdentities(String service, String component, Collection<KerberosIdentityDescriptor> identities, Map<String, String> result) {
        for (KerberosIdentityDescriptor each : identities) {
            if (each.getPrincipalDescriptor() == null || each.getReferencedServiceName().isPresent() || each.getName().startsWith("/")) continue;
            String path = StringUtils.isBlank((String)component) ? String.format("%s/%s", service, each.getName()) : String.format("%s/%s/%s", service, component, each.getName());
            result.put(path, each.getPrincipalDescriptor().getName());
        }
    }
}

