/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptor;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class KerberosConfigurationDescriptor
extends AbstractKerberosDescriptor {
    private Map<String, String> properties = null;

    public KerberosConfigurationDescriptor(Map<?, ?> data) {
        Object key;
        Set<?> keySet;
        if (data != null && !(keySet = data.keySet()).isEmpty() && (key = keySet.iterator().next()) != null) {
            Object object = data.get(key);
            this.setType(key.toString());
            if (object instanceof Map) {
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    Object value = entry.getValue();
                    this.putProperty(entry.getKey().toString(), value == null ? null : value.toString());
                }
            }
        }
    }

    public String getType() {
        return this.getName();
    }

    public void setType(String type) {
        this.setName(type);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties == null ? null : new TreeMap<String, String>(properties);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return name == null || this.properties == null ? null : this.properties.get(name);
    }

    public void putProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("The property name must not be null");
        }
        if (this.properties == null) {
            this.properties = new TreeMap<String, String>();
        }
        this.properties.put(name, value);
    }

    public void update(KerberosConfigurationDescriptor updates) {
        if (updates != null) {
            this.setType(updates.getType());
            Map<String, String> updatedProperties = updates.getProperties();
            if (updatedProperties != null) {
                for (Map.Entry<String, String> entry : updatedProperties.entrySet()) {
                    this.putProperty(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Override
    public Map<String, Object> toMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put(this.getName(), this.properties == null ? null : new TreeMap<String, String>(this.properties));
        return map;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() == KerberosConfigurationDescriptor.class) {
            KerberosConfigurationDescriptor descriptor = (KerberosConfigurationDescriptor)object;
            return super.equals(object) && (this.getProperties() == null ? descriptor.getProperties() == null : this.getProperties().equals(descriptor.getProperties()));
        }
        return false;
    }
}

