/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import id.onyx.obdp.server.OBDPException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;

abstract class AbstractKerberosDescriptorFactory {
    AbstractKerberosDescriptorFactory() {
    }

    protected Map<String, Object> parseFile(File file) throws IOException {
        if (file == null) {
            return Collections.emptyMap();
        }
        if (!file.isFile() || !file.canRead()) {
            throw new IOException(String.format("%s is not a readable file", file.getAbsolutePath()));
        }
        try {
            return (Map)new Gson().fromJson((Reader)new FileReader(file), new TypeToken<Map<String, Object>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            throw new OBDPException(String.format("Failed to parse JSON-formatted file: %s", file.getAbsolutePath()), (Throwable)e);
        }
    }

    protected Map<String, Object> parseJSON(String json) throws OBDPException {
        if (json == null || json.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return (Map)new Gson().fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            throw new OBDPException("Failed to parse JSON-formatted string", (Throwable)e);
        }
    }
}

