/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosConfigurationDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKerberosDescriptorContainer
extends AbstractKerberosDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKerberosDescriptorContainer.class);
    static final String KEY_IDENTITIES = AbstractKerberosDescriptor.Type.IDENTITY.getDescriptorPluralName();
    static final String KEY_CONFIGURATIONS = AbstractKerberosDescriptor.Type.CONFIGURATION.getDescriptorPluralName();
    static final String KEY_AUTH_TO_LOCAL_PROPERTIES = AbstractKerberosDescriptor.Type.AUTH_TO_LOCAL_PROPERTY.getDescriptorPluralName();
    public static final Pattern AUTH_TO_LOCAL_PROPERTY_SPECIFICATION_PATTERN = Pattern.compile("^(?:(.+?)/)?(.+?)(?:\\|(.+?))?$");
    private List<KerberosIdentityDescriptor> identities = null;
    private Map<String, KerberosConfigurationDescriptor> configurations = null;
    private Set<String> authToLocalProperties = null;

    protected AbstractKerberosDescriptorContainer(Map<?, ?> data) {
        if (data != null) {
            Object list = data.get(KEY_IDENTITIES);
            if (list instanceof Collection) {
                for (Object item : (Collection)list) {
                    if (!(item instanceof Map)) continue;
                    this.putIdentity(new KerberosIdentityDescriptor((Map)item));
                }
            }
            if ((list = data.get(KEY_CONFIGURATIONS)) instanceof Collection) {
                for (Object item : (Collection)list) {
                    if (!(item instanceof Map)) continue;
                    this.putConfiguration(new KerberosConfigurationDescriptor((Map)item));
                }
            }
            if ((list = data.get(KEY_AUTH_TO_LOCAL_PROPERTIES)) instanceof Collection) {
                for (Object item : (Collection)list) {
                    if (!(item instanceof String)) continue;
                    this.putAuthToLocalProperty((String)item);
                }
            }
        }
    }

    public abstract Collection<? extends AbstractKerberosDescriptorContainer> getChildContainers();

    public abstract AbstractKerberosDescriptorContainer getChildContainer(String var1);

    public List<KerberosIdentityDescriptor> getIdentities() {
        try {
            return this.getIdentities(false, null);
        }
        catch (OBDPException e) {
            return null;
        }
    }

    public void setIdentities(List<KerberosIdentityDescriptor> identities) {
        this.identities = identities == null ? null : new ArrayList<KerberosIdentityDescriptor>(identities);
    }

    public List<KerberosIdentityDescriptor> getIdentities(boolean resolveReferences, Map<String, Object> contextForFilter) throws OBDPException {
        if (this.identities == null) {
            return null;
        }
        ArrayList<KerberosIdentityDescriptor> list = new ArrayList<KerberosIdentityDescriptor>();
        for (KerberosIdentityDescriptor identity : this.identities) {
            KerberosIdentityDescriptor identityToAdd = resolveReferences ? this.dereferenceIdentity(identity) : identity;
            if (identityToAdd == null || contextForFilter != null && !identityToAdd.shouldInclude(contextForFilter)) continue;
            if (AbstractKerberosDescriptorContainer.isReferredServiceInstalled(identity, contextForFilter)) {
                list.add(identityToAdd);
                continue;
            }
            LOG.info("Skipping identity {} because referred service is not installed.", (Object)identityToAdd.getName());
        }
        return list;
    }

    private static boolean isReferredServiceInstalled(KerberosIdentityDescriptor identity, Map<String, Object> contextForFilter) {
        if (contextForFilter == null || !(contextForFilter.get("services") instanceof Collection)) {
            return true;
        }
        HashSet installedServices = Sets.newHashSet((Iterable)((Collection)contextForFilter.get("services")));
        return (Boolean)identity.getReferencedServiceName().transform(AbstractKerberosDescriptorContainer.contains(installedServices)).or((Object)true);
    }

    private static Function<String, Boolean> contains(Set<String> installed) {
        return Functions.forPredicate((Predicate)Predicates.in(installed));
    }

    public KerberosIdentityDescriptor getIdentity(String name) {
        KerberosIdentityDescriptor identity = null;
        if (name != null && this.identities != null) {
            for (KerberosIdentityDescriptor descriptor : this.identities) {
                if (!name.equals(descriptor.getName())) continue;
                identity = descriptor;
                break;
            }
        }
        return identity;
    }

    public void putIdentity(KerberosIdentityDescriptor identity) {
        if (identity != null) {
            String name = identity.getName();
            if (this.identities == null) {
                this.identities = new ArrayList<KerberosIdentityDescriptor>();
            }
            if (name != null && !name.isEmpty()) {
                this.removeIdentity(identity.getName());
            }
            this.identities.add(identity);
            identity.setParent(this);
        }
    }

    public void removeIdentity(String name) {
        if (name != null && this.identities != null) {
            Iterator<KerberosIdentityDescriptor> iterator = this.identities.iterator();
            while (iterator.hasNext()) {
                KerberosIdentityDescriptor identity = iterator.next();
                if (!name.equals(identity.getName())) continue;
                identity.setParent(null);
                iterator.remove();
            }
        }
    }

    public void setConfigurations(Map<String, KerberosConfigurationDescriptor> configurations) {
        this.configurations = configurations == null ? null : new TreeMap<String, KerberosConfigurationDescriptor>(configurations);
    }

    public Map<String, KerberosConfigurationDescriptor> getConfigurations() {
        return this.getConfigurations(false);
    }

    public Map<String, KerberosConfigurationDescriptor> getConfigurations(boolean includeInherited) {
        if (includeInherited) {
            TreeMap<String, KerberosConfigurationDescriptor> mergedConfigurations = new TreeMap<String, KerberosConfigurationDescriptor>();
            ArrayList<Map<String, KerberosConfigurationDescriptor>> configurationSets = new ArrayList<Map<String, KerberosConfigurationDescriptor>>();
            for (AbstractKerberosDescriptor currentDescriptor = this; currentDescriptor != null; currentDescriptor = currentDescriptor.getParent()) {
                Map<String, KerberosConfigurationDescriptor> configurations;
                if (!((AbstractKerberosDescriptor)currentDescriptor).isContainer() || (configurations = currentDescriptor.getConfigurations()) == null) continue;
                configurationSets.add(configurations);
            }
            Collections.reverse(configurationSets);
            for (Map map : configurationSets) {
                for (Map.Entry entry : map.entrySet()) {
                    String currentType = (String)entry.getKey();
                    KerberosConfigurationDescriptor currentConfiguration = (KerberosConfigurationDescriptor)entry.getValue();
                    if (currentConfiguration == null) continue;
                    KerberosConfigurationDescriptor detachedConfiguration = new KerberosConfigurationDescriptor(currentConfiguration.toMap());
                    KerberosConfigurationDescriptor mergedConfiguration = (KerberosConfigurationDescriptor)mergedConfigurations.get(entry.getKey());
                    if (mergedConfiguration == null) {
                        mergedConfigurations.put(currentType, detachedConfiguration);
                        continue;
                    }
                    mergedConfiguration.update(detachedConfiguration);
                }
            }
            return mergedConfigurations;
        }
        return this.configurations;
    }

    public void putConfiguration(KerberosConfigurationDescriptor configuration) {
        if (configuration != null) {
            String type = configuration.getType();
            if (type == null) {
                throw new IllegalArgumentException("The configuration type must not be null");
            }
            if (this.configurations == null) {
                this.configurations = new TreeMap<String, KerberosConfigurationDescriptor>();
            }
            this.configurations.put(type, configuration);
            configuration.setParent(this);
        }
    }

    public KerberosConfigurationDescriptor getConfiguration(String name) {
        return name == null || this.configurations == null ? null : this.configurations.get(name);
    }

    public void putAuthToLocalProperty(String authToLocalProperty) {
        if (authToLocalProperty != null) {
            if (this.authToLocalProperties == null) {
                this.authToLocalProperties = new TreeSet<String>();
            }
            this.authToLocalProperties.add(authToLocalProperty);
        }
    }

    public void setAuthToLocalProperties(Set<String> authToLocalProperties) {
        this.authToLocalProperties = authToLocalProperties == null ? null : new TreeSet<String>(authToLocalProperties);
    }

    public Set<String> getAuthToLocalProperties() {
        return this.authToLocalProperties;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public void update(AbstractKerberosDescriptorContainer updates) {
        if (updates != null) {
            Set<String> set;
            List<KerberosIdentityDescriptor> updatedIdentities;
            Map<String, KerberosConfigurationDescriptor> updatedConfigurations;
            String updatedName = updates.getName();
            if (updatedName != null) {
                this.setName(updatedName);
            }
            if ((updatedConfigurations = updates.getConfigurations()) != null) {
                for (Map.Entry<String, KerberosConfigurationDescriptor> entry : updatedConfigurations.entrySet()) {
                    KerberosConfigurationDescriptor existingConfiguration = this.getConfiguration(entry.getKey());
                    KerberosConfigurationDescriptor clone = new KerberosConfigurationDescriptor(entry.getValue().toMap());
                    if (existingConfiguration == null) {
                        this.putConfiguration(clone);
                        continue;
                    }
                    existingConfiguration.update(clone);
                }
            }
            if ((updatedIdentities = updates.getIdentities()) != null) {
                for (KerberosIdentityDescriptor updatedIdentity : updatedIdentities) {
                    KerberosIdentityDescriptor existing = this.getIdentity(updatedIdentity.getName());
                    KerberosIdentityDescriptor clone = new KerberosIdentityDescriptor(updatedIdentity.toMap());
                    if (existing == null) {
                        this.putIdentity(clone);
                        continue;
                    }
                    existing.update(clone);
                }
            }
            if ((set = updates.getAuthToLocalProperties()) != null) {
                for (String updatedAuthToLocalProperty : set) {
                    this.putAuthToLocalProperty(updatedAuthToLocalProperty);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public KerberosIdentityDescriptor getReferencedIdentityDescriptor(String path) throws OBDPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected AbstractKerberosDescriptor getDescriptor(AbstractKerberosDescriptor.Type type, String name) {
        if (AbstractKerberosDescriptor.Type.IDENTITY == type) {
            return this.getIdentity(name);
        }
        if (AbstractKerberosDescriptor.Type.CONFIGURATION == type) {
            return this.getConfiguration(name);
        }
        return null;
    }

    @Override
    public Map<String, Object> toMap() {
        TreeMap<String, Map<String, Object>> list;
        Map<String, Object> map = super.toMap();
        if (this.identities != null) {
            list = new TreeMap<String, Map<String, Object>>();
            for (KerberosIdentityDescriptor identity : this.identities) {
                list.put(identity.getName(), identity.toMap());
            }
            map.put(KEY_IDENTITIES, list.values());
        }
        if (this.configurations != null) {
            list = new TreeMap();
            for (KerberosConfigurationDescriptor configuration : this.configurations.values()) {
                list.put(configuration.getType(), configuration.toMap());
            }
            map.put(KEY_CONFIGURATIONS, list.values());
        }
        if (this.authToLocalProperties != null) {
            map.put(KEY_AUTH_TO_LOCAL_PROPERTIES, this.authToLocalProperties);
        }
        return map;
    }

    public List<KerberosIdentityDescriptor> getIdentitiesSkipReferences() {
        return AbstractKerberosDescriptorContainer.nullToEmpty(this.getIdentities()).stream().filter(identity -> !identity.getReferencedServiceName().isPresent() && !identity.isReference()).collect(Collectors.toList());
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.getIdentities() == null ? 0 : this.getIdentities().hashCode()) + (this.getAuthToLocalProperties() == null ? 0 : this.getAuthToLocalProperties().hashCode()) + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractKerberosDescriptorContainer) {
            AbstractKerberosDescriptorContainer descriptor = (AbstractKerberosDescriptorContainer)object;
            return super.equals(object) && (this.getIdentities() == null ? descriptor.getIdentities() == null : this.getIdentities().equals(descriptor.getIdentities())) && (this.getAuthToLocalProperties() == null ? descriptor.getAuthToLocalProperties() == null : this.getAuthToLocalProperties().equals(descriptor.getAuthToLocalProperties())) && (this.getConfigurations() == null ? descriptor.getConfigurations() == null : this.getConfigurations().equals(descriptor.getConfigurations()));
        }
        return false;
    }

    private KerberosIdentityDescriptor dereferenceIdentity(KerberosIdentityDescriptor identity) throws OBDPException {
        KerberosIdentityDescriptor dereferencedIdentity = null;
        if (identity != null) {
            KerberosIdentityDescriptor referencedIdentity;
            try {
                if (identity.getReference() != null) {
                    referencedIdentity = this.getReferencedIdentityDescriptor(identity.getReference());
                } else {
                    referencedIdentity = this.getReferencedIdentityDescriptor(identity.getName());
                    if (referencedIdentity != null) {
                        LOG.warn("Referenced identities should be declared using the identity's \"reference\" attribute, not the identity's \"name\" attribute. This is a deprecated feature. Problems may occur in the future unless this is corrected: {}:{}", (Object)identity.getPath(), (Object)identity.getName());
                    }
                }
            }
            catch (OBDPException e) {
                throw new OBDPException(String.format("Invalid Kerberos identity reference: %s", identity.getReference()), (Throwable)e);
            }
            if (referencedIdentity != null) {
                dereferencedIdentity = this.dereferenceIdentity(referencedIdentity);
                if (dereferencedIdentity != null) {
                    dereferencedIdentity.update(identity);
                } else {
                    dereferencedIdentity = new KerberosIdentityDescriptor(referencedIdentity.toMap());
                    dereferencedIdentity.update(identity);
                }
            } else {
                dereferencedIdentity = new KerberosIdentityDescriptor(identity.toMap());
            }
            dereferencedIdentity.setPath(identity.getPath());
        }
        return dereferencedIdentity;
    }
}

