/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.kerberos;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractKerberosDescriptor {
    static final String KEY_NAME = "name";
    private AbstractKerberosDescriptor parent = null;
    private String name = null;

    public Map<String, Object> toMap() {
        TreeMap<String, Object> dataMap = new TreeMap<String, Object>();
        String name = this.getName();
        if (name != null) {
            dataMap.put(KEY_NAME, name);
        }
        return dataMap;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractKerberosDescriptor getParent() {
        return this.parent;
    }

    public void setParent(AbstractKerberosDescriptor parent) {
        this.parent = parent;
    }

    public boolean isContainer() {
        return false;
    }

    protected static Object getValue(Map<?, ?> map, String key) {
        return map == null || key == null ? null : map.get(key);
    }

    protected static String getStringValue(Map<?, ?> map, String key) {
        Object value = AbstractKerberosDescriptor.getValue(map, key);
        return value == null ? null : value.toString();
    }

    protected static Boolean getBooleanValue(Map<?, ?> map, String key) {
        return AbstractKerberosDescriptor.getBooleanValue(map, key, null);
    }

    protected static Boolean getBooleanValue(Map<?, ?> map, String key, Boolean defaultValue) {
        String value = AbstractKerberosDescriptor.getStringValue(map, key);
        return StringUtils.isEmpty((String)value) ? defaultValue : Boolean.valueOf(value);
    }

    protected AbstractKerberosDescriptor getDescriptor(Type type, String name) {
        return null;
    }

    protected AbstractKerberosDescriptor getRoot() {
        AbstractKerberosDescriptor root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public static <T> Collection<T> nullToEmpty(Collection<T> collection) {
        return collection == null ? Collections.emptyList() : collection;
    }

    public static <T> List<T> nullToEmpty(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    public static <K, V> Map<K, V> nullToEmpty(Map<K, V> collection) {
        return collection == null ? Collections.emptyMap() : collection;
    }

    public int hashCode() {
        return 37 * (this.getName() == null ? 0 : this.getName().hashCode());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractKerberosDescriptor) {
            AbstractKerberosDescriptor descriptor = (AbstractKerberosDescriptor)object;
            return this.getName() == null ? descriptor.getName() == null : this.getName().equals(descriptor.getName());
        }
        return false;
    }

    public String getPath() {
        StringBuilder path = new StringBuilder();
        for (AbstractKerberosDescriptor current = this; current != null && current.getName() != null; current = current.getParent()) {
            path.insert(0, current.getName());
            path.insert(0, '/');
        }
        return path.toString();
    }

    public static enum Type {
        SERVICE("service", "services"),
        COMPONENT("component", "components"),
        IDENTITY("identity", "identities"),
        PRINCIPAL("principal", "principals"),
        KEYTAB("keytab", "keytabs"),
        CONFIGURATION("configuration", "configurations"),
        AUTH_TO_LOCAL_PROPERTY("auth_to_local_property", "auth_to_local_properties");

        private final String descriptorName;
        private final String descriptorPluralName;

        private Type(String descriptorName, String descriptorPluralName) {
            this.descriptorName = descriptorName;
            this.descriptorPluralName = descriptorPluralName;
        }

        public String getDescriptorName() {
            return this.descriptorName;
        }

        public String getDescriptorPluralName() {
            return this.descriptorPluralName;
        }
    }
}

