/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.host;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.HostNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.AgentEnv;
import id.onyx.obdp.server.agent.DiskInfo;
import id.onyx.obdp.server.agent.HostInfo;
import id.onyx.obdp.server.agent.RecoveryReport;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.HostResponse;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.events.HostStateUpdateEvent;
import id.onyx.obdp.server.events.HostStatusUpdateEvent;
import id.onyx.obdp.server.events.MaintenanceModeEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.cache.HostConfigMapping;
import id.onyx.obdp.server.orm.cache.HostConfigMappingImpl;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.HostConfigMappingDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.HostStateDAO;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.HostStateEntity;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.state.AgentVersion;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostConfig;
import id.onyx.obdp.server.state.HostEvent;
import id.onyx.obdp.server.state.HostEventType;
import id.onyx.obdp.server.state.HostHealthStatus;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.UpgradeState;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.state.fsm.SingleArcTransition;
import id.onyx.obdp.server.state.fsm.StateMachine;
import id.onyx.obdp.server.state.fsm.StateMachineFactory;
import id.onyx.obdp.server.state.host.HostHealthyHeartbeatEvent;
import id.onyx.obdp.server.state.host.HostHeartbeatLostEvent;
import id.onyx.obdp.server.state.host.HostRegistrationRequestEvent;
import id.onyx.obdp.server.state.host.HostStatusUpdatesReceivedEvent;
import id.onyx.obdp.server.state.host.HostUnhealthyHeartbeatEvent;
import id.onyx.obdp.server.topology.TopologyManager;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostImpl
implements Host {
    private static final Logger LOG = LoggerFactory.getLogger(HostImpl.class);
    private static final String HARDWAREISA = "hardware_isa";
    private static final String HARDWAREMODEL = "hardware_model";
    private static final String INTERFACES = "interfaces";
    private static final String KERNEL = "kernel";
    private static final String KERNELMAJOREVERSON = "kernel_majorversion";
    private static final String KERNELRELEASE = "kernel_release";
    private static final String KERNELVERSION = "kernel_version";
    private static final String MACADDRESS = "mac_address";
    private static final String NETMASK = "netmask";
    private static final String OSFAMILY = "os_family";
    private static final String PHYSICALPROCESSORCOUNT = "physicalprocessors_count";
    private static final String PROCESSORCOUNT = "processors_count";
    private static final String SELINUXENABLED = "selinux_enabled";
    private static final String SWAPSIZE = "swap_size";
    private static final String SWAPFREE = "swap_free";
    private static final String TIMEZONE = "timezone";
    private static final String OS_RELEASE_VERSION = "os_release_version";
    @Inject
    private final Gson gson;
    private static final Type hostAttributesType = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type maintMapType = new TypeToken<Map<Long, MaintenanceState>>(){}.getType();
    ReadWriteLock rwLock;
    private final Lock writeLock;
    @Inject
    private HostDAO hostDAO;
    @Inject
    private HostStateDAO hostStateDAO;
    @Inject
    private HostVersionDAO hostVersionDAO;
    @Inject
    private ClusterDAO clusterDAO;
    @Inject
    private Clusters clusters;
    @Inject
    private HostConfigMappingDAO hostConfigMappingDAO;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private OBDPEventPublisher ambariEventPublisher;
    @Inject
    private MaintenanceStateHelper maintenanceStateHelper;
    private final long hostId;
    private final String hostName;
    private long lastHeartbeatTime = 0L;
    private long lastAgentStartTime = 0L;
    private AgentEnv lastAgentEnv = null;
    private List<DiskInfo> disksInfo = new CopyOnWriteArrayList<DiskInfo>();
    private RecoveryReport recoveryReport = new RecoveryReport();
    private Integer currentPingPort = null;
    private final StateMachine<HostState, HostEventType, HostEvent> stateMachine;
    private final ConcurrentMap<Long, MaintenanceState> maintMap;
    private String status = HostHealthStatus.HealthStatus.UNKNOWN.name();
    private String prefix;
    @Inject
    private OBDPEventPublisher eventPublisher;
    @Inject
    private TopologyManager topologyManager;
    private static final StateMachineFactory<HostImpl, HostState, HostEventType, HostEvent> stateMachineFactory = new StateMachineFactory<HostImpl, HostState, HostEventType, HostEvent>(HostState.INIT).addTransition(HostState.INIT, HostState.WAITING_FOR_HOST_STATUS_UPDATES, HostEventType.HOST_REGISTRATION_REQUEST, new HostRegistrationReceived()).addTransition(HostState.INIT, HostState.HEARTBEAT_LOST, HostEventType.HOST_HEARTBEAT_LOST, (SingleArcTransition<HostImpl, HostEvent>)new HostHeartbeatLostTransition()).addTransition(HostState.WAITING_FOR_HOST_STATUS_UPDATES, HostState.HEALTHY, HostEventType.HOST_STATUS_UPDATES_RECEIVED, (SingleArcTransition<HostImpl, HostEvent>)new HostStatusUpdatesReceivedTransition()).addTransition(HostState.WAITING_FOR_HOST_STATUS_UPDATES, HostState.WAITING_FOR_HOST_STATUS_UPDATES, HostEventType.HOST_HEARTBEAT_HEALTHY).addTransition(HostState.WAITING_FOR_HOST_STATUS_UPDATES, HostState.WAITING_FOR_HOST_STATUS_UPDATES, HostEventType.HOST_HEARTBEAT_UNHEALTHY, (SingleArcTransition<HostImpl, HostEvent>)new HostBecameUnhealthyTransition()).addTransition(HostState.WAITING_FOR_HOST_STATUS_UPDATES, HostState.HEARTBEAT_LOST, HostEventType.HOST_HEARTBEAT_LOST, (SingleArcTransition<HostImpl, HostEvent>)new HostHeartbeatLostTransition()).addTransition(HostState.HEALTHY, HostState.HEALTHY, HostEventType.HOST_HEARTBEAT_HEALTHY, (SingleArcTransition<HostImpl, HostEvent>)new HostHeartbeatReceivedTransition()).addTransition(HostState.HEALTHY, HostState.HEARTBEAT_LOST, HostEventType.HOST_HEARTBEAT_LOST, (SingleArcTransition<HostImpl, HostEvent>)new HostHeartbeatLostTransition()).addTransition(HostState.HEALTHY, HostState.UNHEALTHY, HostEventType.HOST_HEARTBEAT_UNHEALTHY, (SingleArcTransition<HostImpl, HostEvent>)new HostBecameUnhealthyTransition()).addTransition(HostState.HEALTHY, HostState.WAITING_FOR_HOST_STATUS_UPDATES, HostEventType.HOST_REGISTRATION_REQUEST, (SingleArcTransition<HostImpl, HostEvent>)new HostRegistrationReceived()).addTransition(HostState.UNHEALTHY, HostState.HEALTHY, HostEventType.HOST_HEARTBEAT_HEALTHY, (SingleArcTransition<HostImpl, HostEvent>)new HostBecameHealthyTransition()).addTransition(HostState.UNHEALTHY, HostState.UNHEALTHY, HostEventType.HOST_HEARTBEAT_UNHEALTHY, (SingleArcTransition<HostImpl, HostEvent>)new HostHeartbeatReceivedTransition()).addTransition(HostState.UNHEALTHY, HostState.HEARTBEAT_LOST, HostEventType.HOST_HEARTBEAT_LOST, (SingleArcTransition<HostImpl, HostEvent>)new HostHeartbeatLostTransition()).addTransition(HostState.UNHEALTHY, HostState.WAITING_FOR_HOST_STATUS_UPDATES, HostEventType.HOST_REGISTRATION_REQUEST, (SingleArcTransition<HostImpl, HostEvent>)new HostRegistrationReceived()).addTransition(HostState.HEARTBEAT_LOST, HostState.HEARTBEAT_LOST, HostEventType.HOST_HEARTBEAT_LOST).addTransition(HostState.HEARTBEAT_LOST, HostState.WAITING_FOR_HOST_STATUS_UPDATES, HostEventType.HOST_REGISTRATION_REQUEST, (SingleArcTransition<HostImpl, HostEvent>)new HostRegistrationReceived()).installTopology();

    @Inject
    public HostImpl(@Assisted HostEntity hostEntity, Gson gson, HostDAO hostDAO, HostStateDAO hostStateDAO) {
        this.gson = gson;
        this.hostDAO = hostDAO;
        this.hostStateDAO = hostStateDAO;
        this.stateMachine = stateMachineFactory.make(this);
        this.rwLock = new ReentrantReadWriteLock();
        this.writeLock = this.rwLock.writeLock();
        HostStateEntity hostStateEntity = hostEntity.getHostStateEntity();
        if (hostStateEntity == null) {
            hostStateEntity = new HostStateEntity();
            hostStateEntity.setHostEntity(hostEntity);
            hostEntity.setHostStateEntity(hostStateEntity);
            hostStateEntity.setHealthStatus(gson.toJson((Object)new HostHealthStatus(HostHealthStatus.HealthStatus.UNKNOWN, "")));
        } else {
            this.stateMachine.setCurrentState(hostStateEntity.getCurrentState());
        }
        if (null == hostEntity.getHostId()) {
            this.persistEntities(hostEntity);
            for (ClusterEntity clusterEntity : hostEntity.getClusterEntities()) {
                try {
                    this.clusters.getClusterById(clusterEntity.getClusterId()).refresh();
                }
                catch (OBDPException e) {
                    LOG.error("Error while looking up the cluster", (Throwable)e);
                    throw new RuntimeException("Cluster '" + clusterEntity.getClusterId() + "' was removed", e);
                }
            }
        }
        this.hostId = hostEntity.getHostId();
        this.hostName = hostEntity.getHostName();
        this.maintMap = this.ensureMaintMap(hostEntity.getHostStateEntity());
    }

    public int compareTo(Object o) {
        if (o != null && o instanceof Host) {
            return this.getHostName().compareTo(((Host)o).getHostName());
        }
        return -1;
    }

    @Override
    @Transactional
    public void importHostInfo(HostInfo hostInfo) {
        if (hostInfo.getIPAddress() != null && !hostInfo.getIPAddress().isEmpty()) {
            this.setIPv4(hostInfo.getIPAddress());
            this.setIPv6(hostInfo.getIPAddress());
        }
        this.setCpuCount(hostInfo.getProcessorCount());
        this.setPhCpuCount(hostInfo.getPhysicalProcessorCount());
        this.setTotalMemBytes(hostInfo.getMemoryTotal());
        this.setAvailableMemBytes(hostInfo.getFreeMemory());
        if (hostInfo.getArchitecture() != null && !hostInfo.getArchitecture().isEmpty()) {
            this.setOsArch(hostInfo.getArchitecture());
        }
        if (hostInfo.getOS() != null && !hostInfo.getOS().isEmpty()) {
            String[] release;
            Object osType = hostInfo.getOS();
            if (hostInfo.getOSRelease() != null && (release = hostInfo.getOSRelease().split("\\.")).length > 0) {
                osType = (String)osType + release[0];
            }
            this.setOsType(((String)osType).toLowerCase());
        }
        if (hostInfo.getMounts() != null && !hostInfo.getMounts().isEmpty()) {
            this.setDisksInfo(hostInfo.getMounts());
        }
        this.setAgentVersion(new AgentVersion(hostInfo.getAgentUserId()));
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (hostInfo.getHardwareIsa() != null) {
            attrs.put(HARDWAREISA, hostInfo.getHardwareIsa());
        }
        if (hostInfo.getHardwareModel() != null) {
            attrs.put(HARDWAREMODEL, hostInfo.getHardwareModel());
        }
        if (hostInfo.getInterfaces() != null) {
            attrs.put(INTERFACES, hostInfo.getInterfaces());
        }
        if (hostInfo.getKernel() != null) {
            attrs.put(KERNEL, hostInfo.getKernel());
        }
        if (hostInfo.getKernelMajVersion() != null) {
            attrs.put(KERNELMAJOREVERSON, hostInfo.getKernelMajVersion());
        }
        if (hostInfo.getKernelRelease() != null) {
            attrs.put(KERNELRELEASE, hostInfo.getKernelRelease());
        }
        if (hostInfo.getKernelVersion() != null) {
            attrs.put(KERNELVERSION, hostInfo.getKernelVersion());
        }
        if (hostInfo.getMacAddress() != null) {
            attrs.put(MACADDRESS, hostInfo.getMacAddress());
        }
        if (hostInfo.getNetMask() != null) {
            attrs.put(NETMASK, hostInfo.getNetMask());
        }
        if (hostInfo.getOSFamily() != null) {
            attrs.put(OSFAMILY, hostInfo.getOSFamily());
        }
        if (hostInfo.getPhysicalProcessorCount() != 0) {
            attrs.put(PHYSICALPROCESSORCOUNT, Long.toString(hostInfo.getPhysicalProcessorCount()));
        }
        if (hostInfo.getProcessorCount() != 0) {
            attrs.put(PROCESSORCOUNT, Long.toString(hostInfo.getProcessorCount()));
        }
        if (Boolean.toString(hostInfo.getSeLinux()) != null) {
            attrs.put(SELINUXENABLED, Boolean.toString(hostInfo.getSeLinux()));
        }
        if (hostInfo.getSwapSize() != null) {
            attrs.put(SWAPSIZE, hostInfo.getSwapSize());
        }
        if (hostInfo.getSwapFree() != null) {
            attrs.put(SWAPFREE, hostInfo.getSwapFree());
        }
        if (hostInfo.getTimeZone() != null) {
            attrs.put(TIMEZONE, hostInfo.getTimeZone());
        }
        if (hostInfo.getOSRelease() != null) {
            attrs.put(OS_RELEASE_VERSION, hostInfo.getOSRelease());
        }
        this.setHostAttributes(attrs);
    }

    @Override
    public void setLastAgentEnv(AgentEnv env) {
        this.lastAgentEnv = env;
    }

    @Override
    public AgentEnv getLastAgentEnv() {
        return this.lastAgentEnv;
    }

    @Override
    public HostState getState() {
        return this.stateMachine.getCurrentState();
    }

    @Override
    public void setState(HostState state) {
        this.stateMachine.setCurrentState(state);
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        this.ambariEventPublisher.publish(new HostStateUpdateEvent(this.getHostName(), state));
        if (hostStateEntity != null) {
            hostStateEntity.setCurrentState(state);
            hostStateEntity.setTimeInState(System.currentTimeMillis());
            this.hostStateDAO.merge(hostStateEntity);
        }
    }

    @Override
    public void setStateMachineState(HostState state) {
        this.stateMachine.setCurrentState(state);
        this.ambariEventPublisher.publish(new HostStateUpdateEvent(this.getHostName(), state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(HostEvent event) throws InvalidStateTransitionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling Host event, eventType={}, event={}", (Object)((HostEventType)((Object)event.getType())).name(), (Object)event);
        }
        HostState oldState = this.getState();
        try {
            this.writeLock.lock();
            try {
                this.stateMachine.doTransition((HostEventType)((Object)event.getType()), event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error("Can't handle Host event at current state, host=" + this.getHostName() + ", currentState=" + oldState + ", eventType=" + event.getType() + ", event=" + event);
                throw e;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (oldState != this.getState()) {
            this.ambariEventPublisher.publish(new HostStateUpdateEvent(this.getHostName(), this.getState()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host transitioned to a new state, host={}, oldState={}, currentState={}, eventType={}, event={}", new Object[]{this.getHostName(), oldState, this.getState(), ((HostEventType)((Object)event.getType())).name(), event});
            }
        }
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public Long getHostId() {
        return this.hostId;
    }

    @Override
    public Integer getCurrentPingPort() {
        return this.currentPingPort;
    }

    @Override
    public void setCurrentPingPort(Integer currentPingPort) {
        this.currentPingPort = currentPingPort;
    }

    @Override
    public void setPublicHostName(String hostName) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setPublicHostName(hostName);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public String getPublicHostName() {
        return this.getHostEntity().getPublicHostName();
    }

    @Override
    public String getIPv4() {
        return this.getHostEntity().getIpv4();
    }

    @Override
    public void setIPv4(String ip) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setIpv4(ip);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public String getIPv6() {
        return this.getHostEntity().getIpv6();
    }

    @Override
    public void setIPv6(String ip) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setIpv6(ip);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public int getCpuCount() {
        return this.getHostEntity().getCpuCount();
    }

    @Override
    public void setCpuCount(int cpuCount) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setCpuCount(cpuCount);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public int getPhCpuCount() {
        return this.getHostEntity().getPhCpuCount();
    }

    @Override
    public void setPhCpuCount(int phCpuCount) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setPhCpuCount(phCpuCount);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public long getTotalMemBytes() {
        return this.getHostEntity().getTotalMem();
    }

    @Override
    public void setTotalMemBytes(long totalMemBytes) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setTotalMem(totalMemBytes);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public long getAvailableMemBytes() {
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        return hostStateEntity != null ? hostStateEntity.getAvailableMem() : 0L;
    }

    @Override
    public void setAvailableMemBytes(long availableMemBytes) {
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        if (hostStateEntity != null) {
            hostStateEntity.setAvailableMem(availableMemBytes);
            this.hostStateDAO.merge(hostStateEntity);
        }
    }

    @Override
    public String getOsArch() {
        return this.getHostEntity().getOsArch();
    }

    @Override
    public void setOsArch(String osArch) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setOsArch(osArch);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public String getOsInfo() {
        return this.getHostEntity().getOsInfo();
    }

    @Override
    public void setOsInfo(String osInfo) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setOsInfo(osInfo);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public String getOsType() {
        return this.getHostEntity().getOsType();
    }

    @Override
    public void setOsType(String osType) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setOsType(osType);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public String getOsFamily() {
        Map<String, String> hostAttributes = this.getHostAttributes();
        return this.getOSFamilyFromHostAttributes(hostAttributes);
    }

    @Override
    public String getOsFamily(Map<String, String> hostAttributes) {
        return this.getOSFamilyFromHostAttributes(hostAttributes);
    }

    @Override
    public String getOSFamilyFromHostAttributes(Map<String, String> hostAttributes) {
        try {
            String majorVersion = hostAttributes.get(OS_RELEASE_VERSION).split("\\.")[0];
            return hostAttributes.get(OSFAMILY) + majorVersion;
        }
        catch (Exception e) {
            LOG.error("Error while getting os family from host attributes:", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<DiskInfo> getDisksInfo() {
        return this.disksInfo;
    }

    @Override
    public void setDisksInfo(List<DiskInfo> disksInfo) {
        this.disksInfo = disksInfo;
    }

    @Override
    public RecoveryReport getRecoveryReport() {
        return this.recoveryReport;
    }

    @Override
    public void setRecoveryReport(RecoveryReport recoveryReport) {
        this.recoveryReport = recoveryReport;
    }

    @Override
    public HostHealthStatus getHealthStatus() {
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        if (hostStateEntity != null) {
            return (HostHealthStatus)this.gson.fromJson(hostStateEntity.getHealthStatus(), HostHealthStatus.class);
        }
        return null;
    }

    @Override
    public HostHealthStatus getHealthStatus(HostStateEntity hostStateEntity) {
        if (hostStateEntity != null) {
            return (HostHealthStatus)this.gson.fromJson(hostStateEntity.getHealthStatus(), HostHealthStatus.class);
        }
        return null;
    }

    @Override
    public void setHealthStatus(HostHealthStatus healthStatus) {
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        if (hostStateEntity != null) {
            hostStateEntity.setHealthStatus(this.gson.toJson((Object)healthStatus));
            if (healthStatus.getHealthStatus().equals((Object)HostHealthStatus.HealthStatus.UNKNOWN)) {
                this.setStatus(HostHealthStatus.HealthStatus.UNKNOWN.name());
            }
            this.hostStateDAO.merge(hostStateEntity);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        if (StringUtils.isNotBlank((String)prefix) && !StringUtils.equals((String)this.prefix, (String)prefix)) {
            this.prefix = prefix;
        }
    }

    @Override
    public Map<String, String> getHostAttributes() {
        return (Map)this.gson.fromJson(this.getHostEntity().getHostAttributes(), hostAttributesType);
    }

    @Override
    public Map<String, String> getHostAttributes(HostEntity hostEntity) {
        return (Map)this.gson.fromJson(hostEntity.getHostAttributes(), hostAttributesType);
    }

    @Override
    public void setHostAttributes(Map<String, String> hostAttributes) {
        HostEntity hostEntity = this.getHostEntity();
        ConcurrentHashMap<String, String> hostAttrs = (ConcurrentHashMap<String, String>)this.gson.fromJson(hostEntity.getHostAttributes(), hostAttributesType);
        if (hostAttrs == null) {
            hostAttrs = new ConcurrentHashMap<String, String>();
        }
        hostAttrs.putAll(hostAttributes);
        hostEntity.setHostAttributes(this.gson.toJson(hostAttrs, hostAttributesType));
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public String getRackInfo() {
        return this.getHostEntity().getRackInfo();
    }

    @Override
    public void setRackInfo(String rackInfo) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setRackInfo(rackInfo);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public long getLastRegistrationTime() {
        return this.getHostEntity().getLastRegistrationTime();
    }

    @Override
    public void setLastRegistrationTime(long lastRegistrationTime) {
        HostEntity hostEntity = this.getHostEntity();
        hostEntity.setLastRegistrationTime(lastRegistrationTime);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    @Override
    public void setLastHeartbeatTime(long lastHeartbeatTime) {
        this.lastHeartbeatTime = lastHeartbeatTime;
    }

    @Override
    public long getLastAgentStartTime() {
        return this.lastAgentStartTime;
    }

    @Override
    public void setLastAgentStartTime(long lastAgentStartTime) {
        this.lastAgentStartTime = lastAgentStartTime;
    }

    @Override
    public AgentVersion getAgentVersion() {
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        if (hostStateEntity != null) {
            return (AgentVersion)this.gson.fromJson(hostStateEntity.getAgentVersion(), AgentVersion.class);
        }
        return null;
    }

    @Override
    public AgentVersion getAgentVersion(HostStateEntity hostStateEntity) {
        if (hostStateEntity != null) {
            return (AgentVersion)this.gson.fromJson(hostStateEntity.getAgentVersion(), AgentVersion.class);
        }
        return null;
    }

    @Override
    public void setAgentVersion(AgentVersion agentVersion) {
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        if (hostStateEntity != null) {
            hostStateEntity.setAgentVersion(this.gson.toJson((Object)agentVersion));
            this.hostStateDAO.merge(hostStateEntity);
        }
    }

    @Override
    public long getTimeInState() {
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        Long timeInState = hostStateEntity != null ? hostStateEntity.getTimeInState() : null;
        return timeInState != null ? timeInState : 0L;
    }

    @Override
    public void setTimeInState(long timeInState) {
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        if (hostStateEntity != null) {
            hostStateEntity.setTimeInState(timeInState);
            this.hostStateDAO.merge(hostStateEntity);
        }
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        if (!Objects.equals(this.status, status)) {
            this.ambariEventPublisher.publish(new HostStatusUpdateEvent(this.getHostName(), status));
        }
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host that = (Host)o;
        return this.getHostName().equals(that.getHostName());
    }

    public int hashCode() {
        return null == this.getHostName() ? 0 : this.getHostName().hashCode();
    }

    @Override
    public HostResponse convertToResponse() {
        HostResponse r = new HostResponse(this.getHostName());
        HostEntity hostEntity = this.getHostEntity();
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        Map<String, String> hostAttributes = this.getHostAttributes(hostEntity);
        r.setHostAttributes(hostAttributes);
        r.setOsFamily(this.getOsFamily(hostAttributes));
        r.setAgentVersion(this.getAgentVersion(hostStateEntity));
        r.setHealthStatus(this.getHealthStatus(hostStateEntity));
        r.setPhCpuCount(hostEntity.getPhCpuCount().intValue());
        r.setCpuCount(hostEntity.getCpuCount().intValue());
        r.setIpv4(hostEntity.getIpv4());
        r.setOsArch(hostEntity.getOsArch());
        r.setOsType(hostEntity.getOsType());
        r.setTotalMemBytes(hostEntity.getTotalMem());
        r.setLastRegistrationTime(hostEntity.getLastRegistrationTime());
        r.setPublicHostName(hostEntity.getPublicHostName());
        r.setRackInfo(hostEntity.getRackInfo());
        r.setDisksInfo(this.getDisksInfo());
        r.setStatus(this.getStatus());
        r.setLastHeartbeatTime(this.getLastHeartbeatTime());
        r.setLastAgentEnv(this.lastAgentEnv);
        r.setRecoveryReport(this.getRecoveryReport());
        r.setRecoverySummary(this.getRecoveryReport().getSummary());
        r.setHostState(this.getState());
        return r;
    }

    @Transactional
    void persistEntities(HostEntity hostEntity) {
        this.hostDAO.create(hostEntity);
        if (!hostEntity.getClusterEntities().isEmpty()) {
            for (ClusterEntity clusterEntity : hostEntity.getClusterEntities()) {
                clusterEntity.getHostEntities().add(hostEntity);
                this.clusterDAO.merge(clusterEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public boolean addDesiredConfig(long clusterId, boolean selected, String user, Config config) {
        if (null == user) {
            throw new NullPointerException("User must be specified.");
        }
        HostConfigMapping exist = this.getDesiredConfigEntity(clusterId, config.getType());
        if (null != exist && exist.getVersion().equals(config.getTag())) {
            if (!selected) {
                exist.setSelected(0);
                this.hostConfigMappingDAO.merge(exist);
            }
            return false;
        }
        this.writeLock.lock();
        HostEntity hostEntity = this.getHostEntity();
        try {
            for (HostConfigMapping e : this.hostConfigMappingDAO.findByType(clusterId, hostEntity.getHostId(), config.getType())) {
                e.setSelected(0);
                this.hostConfigMappingDAO.merge(e);
            }
            HostConfigMappingImpl hostConfigMapping = new HostConfigMappingImpl();
            hostConfigMapping.setClusterId(clusterId);
            hostConfigMapping.setCreateTimestamp(System.currentTimeMillis());
            hostConfigMapping.setHostId(hostEntity.getHostId());
            hostConfigMapping.setSelected(1);
            hostConfigMapping.setUser(user);
            hostConfigMapping.setType(config.getType());
            hostConfigMapping.setVersion(config.getTag());
            this.hostConfigMappingDAO.create(hostConfigMapping);
        }
        finally {
            this.writeLock.unlock();
        }
        this.hostDAO.merge(hostEntity);
        return true;
    }

    @Override
    public Map<String, DesiredConfig> getDesiredConfigs(long clusterId) {
        HashMap<String, DesiredConfig> map = new HashMap<String, DesiredConfig>();
        for (HostConfigMapping e : this.hostConfigMappingDAO.findSelected(clusterId, this.getHostId())) {
            DesiredConfig dc = new DesiredConfig();
            dc.setTag(e.getVersion());
            dc.setServiceName(e.getServiceName());
            map.put(e.getType(), dc);
        }
        return map;
    }

    @Override
    public Map<String, HostConfig> getDesiredHostConfigs(Cluster cluster, Map<String, DesiredConfig> clusterDesiredConfigs) throws OBDPException {
        Map<Object, Object> configGroups;
        if (null == cluster) {
            clusterDesiredConfigs = new HashMap<String, DesiredConfig>();
        }
        if (null == clusterDesiredConfigs) {
            clusterDesiredConfigs = cluster.getDesiredConfigs();
        }
        Map<String, HostConfig> hostConfigMap = clusterDesiredConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, desiredConfigEntry -> {
            HostConfig hostConfig = new HostConfig();
            hostConfig.setDefaultVersionTag(((DesiredConfig)desiredConfigEntry.getValue()).getTag());
            return hostConfig;
        }));
        Map<Object, Object> map = configGroups = cluster == null ? new HashMap() : cluster.getConfigGroupsByHostname(this.getHostName());
        if (configGroups == null || configGroups.isEmpty()) {
            return hostConfigMap;
        }
        for (ConfigGroup configGroup : configGroups.values()) {
            for (Map.Entry<String, Config> configEntry : configGroup.getConfigurations().entrySet()) {
                String configType = configEntry.getKey();
                HostConfig hostConfig = hostConfigMap.get(configType);
                if (hostConfig == null) {
                    hostConfig = new HostConfig();
                    hostConfigMap.put(configType, hostConfig);
                    Config conf = cluster.getDesiredConfigByType(configType);
                    if (conf == null) {
                        LOG.error("Config inconsistency exists: unknown configType=" + configType);
                    } else {
                        hostConfig.setDefaultVersionTag(conf.getTag());
                    }
                }
                hostConfig.getConfigGroupOverrides().put(configGroup.getId(), configEntry.getValue().getTag());
            }
        }
        return hostConfigMap;
    }

    private HostConfigMapping getDesiredConfigEntity(long clusterId, String type) {
        return this.hostConfigMappingDAO.findSelectedByType(clusterId, this.getHostId(), type);
    }

    private ConcurrentMap<Long, MaintenanceState> ensureMaintMap(HostStateEntity hostStateEntity) {
        ConcurrentHashMap<Long, MaintenanceState> map;
        if (null == hostStateEntity || null == hostStateEntity.getMaintenanceState()) {
            return new ConcurrentHashMap<Long, MaintenanceState>();
        }
        String entity = hostStateEntity.getMaintenanceState();
        try {
            Map gsonMap = (Map)this.gson.fromJson(entity, maintMapType);
            map = new ConcurrentHashMap<Long, MaintenanceState>(gsonMap);
        }
        catch (Exception e) {
            return new ConcurrentHashMap<Long, MaintenanceState>();
        }
        return map;
    }

    @Override
    public void setMaintenanceState(long clusterId, MaintenanceState state) {
        this.maintMap.put(clusterId, state);
        String json = this.gson.toJson(this.maintMap, maintMapType);
        HostStateEntity hostStateEntity = this.getHostStateEntity();
        if (hostStateEntity != null) {
            hostStateEntity.setMaintenanceState(json);
            this.hostStateDAO.merge(hostStateEntity);
            MaintenanceModeEvent event = new MaintenanceModeEvent(state, clusterId, this);
            this.eventPublisher.publish(event);
        }
    }

    @Override
    public MaintenanceState getMaintenanceState(long clusterId) {
        if (!this.maintMap.containsKey(clusterId)) {
            this.maintMap.put(clusterId, MaintenanceState.OFF);
        }
        return (MaintenanceState)((Object)this.maintMap.get(clusterId));
    }

    @Override
    public List<HostVersionEntity> getAllHostVersions() {
        return this.hostVersionDAO.findByHost(this.getHostName());
    }

    @Override
    public HostEntity getHostEntity() {
        return this.hostDAO.findById(this.hostId);
    }

    public HostStateEntity getHostStateEntity() {
        return this.hostStateDAO.findByHostId(this.hostId);
    }

    @Override
    public boolean hasComponentsAdvertisingVersions(StackId stackId) throws OBDPException {
        HostEntity hostEntity = this.getHostEntity();
        for (HostComponentStateEntity componentState : hostEntity.getHostComponentStateEntities()) {
            ComponentInfo component = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), componentState.getServiceName(), componentState.getComponentName());
            if (!component.isVersionAdvertised()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void calculateHostStatus(Long clusterId) throws OBDPException {
        int masterCount = 0;
        int mastersRunning = 0;
        int slaveCount = 0;
        int slavesRunning = 0;
        Cluster cluster = this.clusters.getCluster(clusterId);
        StackId stackId = cluster.getDesiredStackVersion();
        List<ServiceComponentHost> scHosts = cluster.getServiceComponentHosts(this.hostName);
        for (ServiceComponentHost scHost : scHosts) {
            ComponentInfo componentInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), scHost.getServiceName(), scHost.getServiceComponentName());
            String status = scHost.getState().name();
            String category = componentInfo.getCategory();
            if (category == null) {
                LOG.warn("In stack {}-{} service {} component {} category is null!", new Object[]{stackId.getStackName(), stackId.getStackVersion(), scHost.getServiceName(), scHost.getServiceComponentName()});
                continue;
            }
            if (MaintenanceState.OFF != this.maintenanceStateHelper.getEffectiveState(scHost, this)) continue;
            if (Objects.equals("MASTER", category)) {
                ++masterCount;
                if (!Objects.equals("STARTED", status)) continue;
                ++mastersRunning;
                continue;
            }
            if (!Objects.equals("SLAVE", category)) continue;
            ++slaveCount;
            if (!Objects.equals("STARTED", status)) continue;
            ++slavesRunning;
        }
        HostHealthStatus.HealthStatus healthStatus = masterCount == mastersRunning && slaveCount == slavesRunning ? HostHealthStatus.HealthStatus.HEALTHY : (masterCount > 0 && mastersRunning < masterCount ? HostHealthStatus.HealthStatus.UNHEALTHY : HostHealthStatus.HealthStatus.ALERT);
        this.setStatus(healthStatus.name());
    }

    @Transactional
    public void updateHost(HostRegistrationRequestEvent e) {
        this.importHostInfo(e.hostInfo);
        this.setLastAgentEnv(e.agentEnv);
        this.setAgentVersion(e.agentVersion);
        this.setPublicHostName(e.publicHostName);
        this.setState(HostState.INIT);
    }

    @Transactional
    public void updateHostTimestamps(HostRegistrationRequestEvent e) {
        this.setLastHeartbeatTime(e.registrationTime);
        this.setLastRegistrationTime(e.registrationTime);
        this.setLastAgentStartTime(e.agentStartTime);
        this.setTimeInState(e.registrationTime);
    }

    @Override
    public boolean isRepositoryVersionCorrect(RepositoryVersionEntity repositoryVersion) throws OBDPException {
        HostEntity hostEntity = this.getHostEntity();
        Collection<HostComponentStateEntity> hostComponentStates = hostEntity.getHostComponentStateEntities();
        for (HostComponentStateEntity hostComponentState : hostComponentStates) {
            ServiceComponentDesiredStateEntity desiredComponmentState = hostComponentState.getServiceComponentDesiredStateEntity();
            RepositoryVersionEntity desiredRepositoryVersion = desiredComponmentState.getDesiredRepositoryVersion();
            ComponentInfo componentInfo = this.obdpMetaInfo.getComponent(desiredRepositoryVersion.getStackName(), desiredRepositoryVersion.getStackVersion(), hostComponentState.getServiceName(), hostComponentState.getComponentName());
            if (!componentInfo.isVersionAdvertised() || !repositoryVersion.equals(desiredRepositoryVersion)) continue;
            String versionAdvertised = hostComponentState.getVersion();
            if (hostComponentState.getUpgradeState() != UpgradeState.IN_PROGRESS && StringUtils.equals((String)versionAdvertised, (String)repositoryVersion.getVersion())) continue;
            return false;
        }
        return true;
    }

    static class HostRegistrationReceived
    implements SingleArcTransition<HostImpl, HostEvent> {
        HostRegistrationReceived() {
        }

        @Override
        public void transition(HostImpl host, HostEvent event) {
            HostRegistrationRequestEvent e = (HostRegistrationRequestEvent)event;
            host.updateHost(e);
            String agentVersion = null;
            if (e.agentVersion != null) {
                agentVersion = e.agentVersion.getVersion();
            }
            LOG.info("Received host registration, host=" + e.hostInfo + ", registrationTime=" + e.registrationTime + ", agentVersion=" + agentVersion);
            host.clusters.updateHostMappings(host);
            boolean associatedWithCluster = false;
            try {
                associatedWithCluster = host.clusters.getClustersForHost(host.getPublicHostName()).size() > 0;
            }
            catch (HostNotFoundException e1) {
                associatedWithCluster = false;
            }
            catch (OBDPException e1) {
                LOG.error("Unable to determine the clusters for host", (Throwable)e1);
            }
            host.topologyManager.onHostRegistered(host, associatedWithCluster);
            host.setHealthStatus(new HostHealthStatus(HostHealthStatus.HealthStatus.HEALTHY, host.getHealthStatus().getHealthReport()));
            host.updateHostTimestamps(e);
        }
    }

    static class HostHeartbeatLostTransition
    implements SingleArcTransition<HostImpl, HostEvent> {
        HostHeartbeatLostTransition() {
        }

        @Override
        public void transition(HostImpl host, HostEvent event) {
            HostHeartbeatLostEvent e = (HostHeartbeatLostEvent)event;
            LOG.debug("Host transitioned to heartbeat lost state, host={}, lastHeartbeatTime={}", (Object)e.getHostName(), (Object)host.getLastHeartbeatTime());
            host.setHealthStatus(new HostHealthStatus(HostHealthStatus.HealthStatus.UNKNOWN, host.getHealthStatus().getHealthReport()));
            host.setLastAgentStartTime(0L);
            host.topologyManager.onHostHeartBeatLost(host);
        }
    }

    static class HostStatusUpdatesReceivedTransition
    implements SingleArcTransition<HostImpl, HostEvent> {
        HostStatusUpdatesReceivedTransition() {
        }

        @Override
        public void transition(HostImpl host, HostEvent event) {
            HostStatusUpdatesReceivedEvent e = (HostStatusUpdatesReceivedEvent)event;
            LOG.debug("Host transition to host status updates received state, host={}, heartbeatTime={}", (Object)e.getHostName(), (Object)e.getTimestamp());
            host.setHealthStatus(new HostHealthStatus(HostHealthStatus.HealthStatus.HEALTHY, host.getHealthStatus().getHealthReport()));
        }
    }

    static class HostBecameUnhealthyTransition
    implements SingleArcTransition<HostImpl, HostEvent> {
        HostBecameUnhealthyTransition() {
        }

        @Override
        public void transition(HostImpl host, HostEvent event) {
            HostUnhealthyHeartbeatEvent e = (HostUnhealthyHeartbeatEvent)event;
            host.setLastHeartbeatTime(e.getHeartbeatTime());
            LOG.debug("Host transitioned to an unhealthy state, host={}, heartbeatTime={}, healthStatus={}", new Object[]{e.getHostName(), e.getHeartbeatTime(), e.getHealthStatus()});
            host.setHealthStatus(e.getHealthStatus());
        }
    }

    static class HostHeartbeatReceivedTransition
    implements SingleArcTransition<HostImpl, HostEvent> {
        HostHeartbeatReceivedTransition() {
        }

        @Override
        public void transition(HostImpl host, HostEvent event) {
            long heartbeatTime = 0L;
            switch ((HostEventType)((Object)event.getType())) {
                case HOST_HEARTBEAT_HEALTHY: {
                    HostHealthyHeartbeatEvent hhevent = (HostHealthyHeartbeatEvent)event;
                    heartbeatTime = hhevent.getHeartbeatTime();
                    if (null != hhevent.getAgentEnv()) {
                        host.setLastAgentEnv(hhevent.getAgentEnv());
                    }
                    if (null == hhevent.getMounts() || hhevent.getMounts().isEmpty()) break;
                    host.setDisksInfo(hhevent.getMounts());
                    break;
                }
                case HOST_HEARTBEAT_UNHEALTHY: {
                    heartbeatTime = ((HostUnhealthyHeartbeatEvent)event).getHeartbeatTime();
                    break;
                }
            }
            if (0L == heartbeatTime) {
                LOG.error("heartbeatTime = 0 !!!");
            }
            host.setLastHeartbeatTime(heartbeatTime);
        }
    }

    static class HostBecameHealthyTransition
    implements SingleArcTransition<HostImpl, HostEvent> {
        HostBecameHealthyTransition() {
        }

        @Override
        public void transition(HostImpl host, HostEvent event) {
            HostHealthyHeartbeatEvent e = (HostHealthyHeartbeatEvent)event;
            host.setLastHeartbeatTime(e.getHeartbeatTime());
            LOG.debug("Host transitioned to a healthy state, host={}, heartbeatTime={}", (Object)e.getHostName(), (Object)e.getHeartbeatTime());
            host.setHealthStatus(new HostHealthStatus(HostHealthStatus.HealthStatus.HEALTHY, host.getHealthStatus().getHealthReport()));
        }
    }
}

